/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.karaf.log.command.DisplayLog;
import org.apache.karaf.shell.commands.Command;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

@Command(scope="log", name="tail", description="Continuously display log entries. Use ctrl-c to quit this command")
public class LogTail
extends DisplayLog {
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    protected Object doExecute() throws Exception {
        PrintEventThread printThread = new PrintEventThread();
        this.executorService.execute(printThread);
        new Thread(new ReadKeyBoardThread(this, Thread.currentThread())).start();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        printThread.abort();
        this.executorService.shutdownNow();
        return null;
    }

    class PrintEventThread
    implements Runnable {
        PrintStream out = System.out;
        boolean doDisplay = true;

        PrintEventThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Iterable le = LogTail.this.logService.getEvents(LogTail.this.entries == 0 ? Integer.MAX_VALUE : LogTail.this.entries);
            for (PaxLoggingEvent event : le) {
                if (event == null) continue;
                LogTail.this.printEvent(this.out, event);
            }
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            PaxAppender appender = new PaxAppender(){

                public void doAppend(PaxLoggingEvent event) {
                    queue.add(event);
                }
            };
            try {
                LogTail.this.logService.addAppender(appender);
                while (this.doDisplay) {
                    PaxLoggingEvent event = (PaxLoggingEvent)queue.take();
                    if (event == null) continue;
                    LogTail.this.printEvent(this.out, event);
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                LogTail.this.logService.removeAppender(appender);
            }
            this.out.println();
        }

        public void abort() {
            this.doDisplay = false;
        }
    }

    class ReadKeyBoardThread
    implements Runnable {
        private LogTail logTail;
        private Thread sessionThread;

        public ReadKeyBoardThread(LogTail logtail, Thread thread) {
            this.logTail = logtail;
            this.sessionThread = thread;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.logTail.session.getKeyboard().read()) >= 0) {
                }
                this.sessionThread.interrupt();
            }
            catch (IOException e) {}
        }
    }
}

