/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import java.io.PrintStream;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.karaf.log.command.DisplayLog;
import org.apache.karaf.shell.commands.Command;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

@Command(scope="log", name="tail", description="Continuously display log entries.")
public class LogTail
extends DisplayLog {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecute() throws Exception {
        PrintStream out = System.out;
        Iterable le = this.logService.getEvents(this.entries == 0 ? Integer.MAX_VALUE : this.entries);
        for (PaxLoggingEvent event : le) {
            this.printEvent(out, event);
        }
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        PaxAppender appender = new PaxAppender(){

            public void doAppend(PaxLoggingEvent event) {
                queue.add(event);
            }
        };
        try {
            try {
                this.logService.addAppender(appender);
                while (true) {
                    PaxLoggingEvent event = (PaxLoggingEvent)queue.take();
                    this.printEvent(out, event);
                }
            }
            catch (InterruptedException e) {
                this.logService.removeAppender(appender);
            }
        }
        catch (Throwable throwable) {
            this.logService.removeAppender(appender);
            throw throwable;
        }
        out.println();
        return null;
    }
}

