/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jpa.hibernate.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.karaf.jpa.hibernate.StatisticsMXBean;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsPublisher
implements ServiceTrackerCustomizer<EntityManagerFactory, EntityManagerFactory> {
    private static Logger LOG = LoggerFactory.getLogger(StatisticsPublisher.class);
    private BundleContext context;
    private MBeanServer mbeanServer;
    private ServiceTracker<EntityManagerFactory, EntityManagerFactory> emfTracker;

    public StatisticsPublisher(BundleContext context, MBeanServer mbeanServer) {
        this.context = context;
        this.mbeanServer = mbeanServer;
        this.emfTracker = new ServiceTracker(context, EntityManagerFactory.class, (ServiceTrackerCustomizer)this);
    }

    public void start() {
        this.emfTracker.open(true);
    }

    public void stop() {
        ServiceReference[] emfRefs;
        for (ServiceReference emfRef : emfRefs = this.emfTracker.getServiceReferences()) {
            try {
                this.mbeanServer.unregisterMBean(this.getOName((ServiceReference<EntityManagerFactory>)emfRef));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.emfTracker.close();
    }

    ObjectName getOName(ServiceReference<EntityManagerFactory> reference) {
        try {
            String unitName = (String)reference.getProperty("osgi.unit.name");
            return new ObjectName("org.hibernate.statistics", "unitName", unitName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void publishStatistics(ServiceReference<EntityManagerFactory> reference, EntityManagerFactory emf) {
        String persitenceProvider = (String)reference.getProperty("osgi.unit.provider");
        if (!"org.hibernate.ejb.HibernatePersistence".equals(persitenceProvider)) {
            return;
        }
        if (reference.getProperty("org.apache.aries.jpa.proxy.factory") != null) {
            return;
        }
        try {
            EntityManager em = emf.createEntityManager();
            SessionFactory sessionFactory = ((Session)em.unwrap(Session.class)).getSessionFactory();
            Statistics statistics = sessionFactory.getStatistics();
            statistics.setStatisticsEnabled(true);
            this.mbeanServer.registerMBean(this.getStatisticsMBean(statistics), this.getOName(reference));
        }
        catch (Exception e) {
            LOG.warn("Error publishing StatisticsMXBean" + e.getMessage(), (Throwable)e);
        }
    }

    public EntityManagerFactory addingService(ServiceReference<EntityManagerFactory> reference) {
        EntityManagerFactory emf = (EntityManagerFactory)this.context.getService(reference);
        this.publishStatistics(reference, emf);
        return emf;
    }

    private Object getStatisticsMBean(final Statistics statistics) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{StatisticsMXBean.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)statistics, args);
            }
        });
    }

    public void modifiedService(ServiceReference<EntityManagerFactory> reference, EntityManagerFactory service) {
    }

    public void removedService(ServiceReference<EntityManagerFactory> reference, EntityManagerFactory service) {
        try {
            this.mbeanServer.unregisterMBean(this.getOName(reference));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

