/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command;

import java.util.List;
import java.util.Map;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.table.Row;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="jdbc", name="query", description="Execute a SQL query on a JDBC datasource")
public class QueryCommand
extends JdbcCommandSupport {
    @Argument(index=0, name="datasource", description="The JDBC datasource to use", required=true, multiValued=false)
    String datasource;
    @Argument(index=1, name="query", description="The SQL query to execute", required=true, multiValued=false)
    String query;

    @Override
    public Object doExecute() throws Exception {
        ShellTable table = new ShellTable();
        Map map = this.getJdbcService().query(this.datasource, this.query);
        int rowCount = 0;
        for (String column : map.keySet()) {
            table.column(column);
            rowCount = ((List)map.get(column)).size();
        }
        for (int i = 0; i < rowCount; ++i) {
            Row row = table.addRow();
            for (String column : map.keySet()) {
                row.addContent(new Object[]{((List)map.get(column)).get(i)});
            }
        }
        table.print(System.out);
        return null;
    }
}

