/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command;

import java.util.Map;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="jdbc", name="info", description="Display details about a JDBC datasource")
public class InfoCommand
extends JdbcCommandSupport {
    @Argument(index=0, name="datasource", description="The JDBC datasource name", required=true, multiValued=false)
    String datasource;

    @Override
    public Object doExecute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Property");
        table.column("Value");
        Map info = this.getJdbcService().info(this.datasource);
        for (String property : info.keySet()) {
            table.addRow().addContent(new Object[]{property, info.get(property)});
        }
        table.print(System.out);
        return null;
    }
}

