/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command;

import java.util.List;
import java.util.Map;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="jdbc", name="datasources", description="List the JDBC datasources")
public class DataSourcesCommand
extends JdbcCommandSupport {
    @Override
    public Object doExecute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Product");
        table.column("Version");
        table.column("URL");
        table.column("Status");
        List datasources = this.getJdbcService().datasources();
        for (String datasource : datasources) {
            try {
                Map info = this.getJdbcService().info(datasource);
                table.addRow().addContent(new Object[]{datasource, info.get("db.product"), info.get("db.version"), info.get("url"), "OK"});
            }
            catch (Exception e) {
                table.addRow().addContent(new Object[]{datasource, "", "", "", "Error"});
            }
        }
        table.print(System.out);
        return null;
    }
}

