/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.LinkedList;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;

@Command(scope="jaas", name="manage", description="Manage user and roles of a Jaas Realm.")
public class ManageRealmCommand
extends JaasCommandSupport {
    @Option(name="--realm", description="Jaas Realm", required=false, multiValued=false)
    String realmName;
    @Option(name="--index", description="Realm Index", required=false, multiValued=false)
    int index;
    @Option(name="--module", aliases={}, description="Realm Module", required=false, multiValued=false)
    String moduleName;
    @Option(name="--force", aliases={}, description="Force the management of this realm, even if another one was under management", required=false, multiValued=false)
    boolean force;

    protected Object doExecute() throws Exception {
        if (this.realmName == null && this.index <= 0) {
            System.err.println("A valid realm or the realm index need to be specified");
            return null;
        }
        JaasRealm oldRealm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry oldEntry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        if (oldRealm != null && !oldRealm.getName().equals(this.realmName) && !this.force) {
            System.err.println("Another realm is being edited.  Cancel / update first, or use the --force option");
        } else if (oldEntry != null && !oldEntry.getLoginModuleName().equals(this.moduleName) && !this.force) {
            System.err.println("Another module is being edited.  Cancel / update first, or use the --force option");
        } else {
            JaasRealm realm = this.findRealmByNameOrIndex(this.realmName, this.index);
            if (realm != null) {
                AppConfigurationEntry entry = this.findEntryByRealmAndName(realm, this.moduleName);
                if (entry != null) {
                    LinkedList commands = null;
                    commands = (LinkedList)this.session.get("JaasCommand.COMMANDS");
                    if (commands == null) {
                        commands = new LinkedList();
                    }
                    this.session.put("JaasCommand.REALM", (Object)realm);
                    this.session.put("JaasCommand.ENTRY", (Object)entry);
                    this.session.put("JaasCommand.COMMANDS", commands);
                } else {
                    System.err.println(String.format("Could not find module: %s in realm:%s", this.moduleName, this.realmName));
                }
            } else {
                System.err.println(String.format("Could not find realm:%s", this.realmName));
            }
        }
        return null;
    }

    protected Object doExecute(BackingEngine engine) throws Exception {
        return null;
    }
}

