/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.SessionCookieConfig;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.context.DefaultServletContextHelper;
import org.ops4j.pax.web.service.spi.context.WebContainerContextWrapper;
import org.ops4j.pax.web.service.spi.model.Identity;
import org.ops4j.pax.web.service.spi.model.elements.JspConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.SessionConfigurationModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContextClassLoader;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsgiContextModel
extends Identity
implements Comparable<OsgiContextModel> {
    public static final Logger LOG = LoggerFactory.getLogger(OsgiContextModel.class);
    public static final OsgiContextModel DEFAULT_CONTEXT_MODEL;
    private String contextPath;
    private String name = null;
    private WebContainerContext httpContext;
    private ServiceReference<?> contextReference;
    private BiFunction<BundleContext, String, WebContainerContext> contextSupplier;
    private final Hashtable<String, Object> contextRegistrationProperties = new Hashtable();
    private final Map<String, String> contextParams = new HashMap<String, String>();
    private final Map<String, Object> initialContextAttributes = new HashMap<String, Object>();
    private final List<String> virtualHosts = new ArrayList<String>();
    private final List<String> connectors = new ArrayList<String>();
    private Bundle ownerBundle;
    private int serviceRank = 0;
    private long serviceId = 0L;
    private Boolean isValid;
    private int dtoFailureCode = -1;
    private Boolean shared = true;
    private final JspConfigurationModel jspConfiguration = new JspConfigurationModel();
    private final SessionConfigurationModel sessionConfiguration = new SessionConfigurationModel();
    private final SecurityConfigurationModel securityConfiguration = new SecurityConfigurationModel();
    private final List<URL> serverSpecificDescriptors = new ArrayList<URL>();
    private final boolean whiteboard;
    private boolean wab;
    private final List<Change> unregistrations = new ArrayList<Change>();
    private boolean async = false;
    private OsgiServletContextClassLoader classLoader = null;

    public OsgiContextModel(Bundle ownerBundle, Integer rank, Long serviceId, boolean whiteboard) {
        this.ownerBundle = ownerBundle;
        this.serviceRank = rank;
        this.serviceId = serviceId;
        this.contextRegistrationProperties.put("service.id", serviceId);
        this.contextRegistrationProperties.put("service.ranking", rank);
        this.whiteboard = whiteboard;
    }

    public OsgiContextModel(WebContainerContext httpContext, Bundle ownerBundle, String contextPath, boolean whiteboard) {
        this.httpContext = httpContext;
        this.ownerBundle = ownerBundle;
        this.contextPath = contextPath;
        this.whiteboard = whiteboard;
        this.name = "default";
    }

    @Override
    protected String getIdPrefix() {
        return "OCM";
    }

    public boolean isValid() {
        if (this.isValid == null) {
            try {
                this.isValid = this.performValidation();
            }
            catch (Exception ignored) {
                this.isValid = false;
            }
        }
        return this.isValid;
    }

    public Boolean performValidation() throws Exception {
        if (this.name == null || "".equals(this.name.trim())) {
            if (this.contextReference != null) {
                LOG.warn("Missing name property for context registered using {} reference", this.contextReference);
            } else if (this.httpContext != null) {
                LOG.warn("Missing name property for context {}", (Object)this.httpContext);
            }
            this.dtoFailureCode = 6;
            return Boolean.FALSE;
        }
        if (this.contextPath == null || !this.contextPath.startsWith("/")) {
            if (this.contextReference != null) {
                LOG.warn("Illegal context path (\"{}\") for context registered using {} reference. Should start with \"/\".", (Object)this.contextPath, this.contextReference);
            } else if (this.httpContext != null) {
                LOG.warn("Illegal context path (\"{}\") for context {}. Should start with \"/\".", (Object)this.contextPath, (Object)this.httpContext);
            }
            this.dtoFailureCode = 6;
            return Boolean.FALSE;
        }
        this.dtoFailureCode = -1;
        return Boolean.TRUE;
    }

    public WebContainerContext resolveHttpContext(Bundle bundle) {
        BundleContext bundleContext;
        if (this.httpContext != null) {
            return this.httpContext;
        }
        BundleContext bundleContext2 = bundleContext = bundle != null ? bundle.getBundleContext() : null;
        if (bundleContext == null) {
            throw new IllegalArgumentException("Can't resolve WebContainerContext without Bundle argument");
        }
        if (this.contextSupplier != null) {
            return this.contextSupplier.apply(bundleContext, this.getName());
        }
        if (this.contextReference != null) {
            LOG.debug("Dereferencing {} for {}", (Object)this.toString(this.contextReference), (Object)bundleContext.getBundle());
            Object context = bundleContext.getService(this.contextReference);
            if (context instanceof WebContainerContext) {
                return (WebContainerContext)context;
            }
            if (context instanceof HttpContext) {
                return new WebContainerContextWrapper(bundleContext.getBundle(), (HttpContext)context, this.name);
            }
            if (context instanceof ServletContextHelper) {
                return new WebContainerContextWrapper(bundleContext.getBundle(), (ServletContextHelper)context, this.name);
            }
            this.dtoFailureCode = 5;
            throw new IllegalStateException("Unsupported Whiteboard service for HttpContext/ServletContextHelper specified");
        }
        this.dtoFailureCode = 5;
        throw new IllegalStateException("No HttpContext/ServletContextHelper configured for " + this);
    }

    private String toString(ServiceReference<?> ref) {
        Long id = (Long)ref.getProperty("service.id");
        return String.format("ServiceReference (id=%d, objectClass=%s)", id, String.join((CharSequence)", ", Utils.getObjectClasses(ref)));
    }

    public void releaseHttpContext(Bundle bundle) {
        BundleContext context;
        if (this.contextReference == null) {
            return;
        }
        BundleContext bundleContext = context = bundle != null ? bundle.getBundleContext() : null;
        if (context != null) {
            LOG.debug("Ungetting {} for {}", (Object)this.toString(this.contextReference), (Object)context.getBundle());
            context.ungetService(this.contextReference);
        }
    }

    public void addUnregistrationChange(Change unregistration) {
        this.unregistrations.add(unregistration);
    }

    public List<Change> getUnregistrations() {
        return this.unregistrations;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    public Map<String, Object> getInitialContextAttributes() {
        return this.initialContextAttributes;
    }

    public Hashtable<String, Object> getContextRegistrationProperties() {
        return this.contextRegistrationProperties;
    }

    public List<String> getVirtualHosts() {
        return this.virtualHosts;
    }

    public List<String> getConnectors() {
        return this.connectors;
    }

    public Bundle getOwnerBundle() {
        return this.ownerBundle;
    }

    public void setOwnerBundle(Bundle ownerBundle) {
        this.ownerBundle = ownerBundle;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public int getServiceRank() {
        return this.serviceRank;
    }

    public void setServiceRank(int serviceRank) {
        this.serviceRank = serviceRank;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(long serviceId) {
        this.serviceId = serviceId;
    }

    public ServiceReference<?> getContextReference() {
        return this.contextReference;
    }

    public void setContextReference(ServiceReference<?> contextReference) {
        this.contextReference = contextReference;
    }

    public BiFunction<BundleContext, String, WebContainerContext> getContextSupplier() {
        return this.contextSupplier;
    }

    public void setContextSupplier(BiFunction<BundleContext, String, WebContainerContext> contextSupplier) {
        this.contextSupplier = contextSupplier;
    }

    public void setHttpContext(WebContainerContext httpContext) {
        this.httpContext = httpContext;
    }

    public OsgiServletContextClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(OsgiServletContextClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean hasDirectHttpContextInstance() {
        return this.httpContext != null;
    }

    public WebContainerContext getDirectHttpContextInstance() {
        return this.httpContext;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public int getDtoFailureCode() {
        return this.dtoFailureCode;
    }

    public void addTagLibs(Collection<TaglibDescriptor> tagLibs) {
        this.jspConfiguration.getTaglibs().addAll(tagLibs);
    }

    public void addJspPropertyGroupDescriptor(JspPropertyGroupDescriptor descriptor) {
        Iterator<JspPropertyGroupDescriptor> it = this.jspConfiguration.getJspPropertyGroups().iterator();
        while (it.hasNext()) {
            JspPropertyGroupDescriptor existing = it.next();
            boolean match = false;
            for (String p1 : existing.getUrlPatterns()) {
                for (String p2 : descriptor.getUrlPatterns()) {
                    if (!p1.equals(p2)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                break;
            }
            if (!match) continue;
            it.remove();
            break;
        }
        this.jspConfiguration.getJspPropertyGroups().add(descriptor);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.jspConfiguration;
    }

    public void setSessionTimeout(Integer minutes) {
        this.sessionConfiguration.setSessionTimeout(minutes);
    }

    public void setSessionCookieConfig(SessionCookieConfig config) {
        this.sessionConfiguration.setSessionCookieConfig(config);
    }

    public SessionConfigurationModel getSessionConfiguration() {
        return this.sessionConfiguration;
    }

    public SecurityConfigurationModel getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public List<URL> getServerSpecificDescriptors() {
        return this.serverSpecificDescriptors;
    }

    public boolean isWhiteboard() {
        return this.whiteboard;
    }

    public boolean isWab() {
        return this.wab;
    }

    public void setWab(boolean wab) {
        this.wab = wab;
    }

    public void setAsynchronusRegistration(boolean async) {
        this.async = async;
    }

    public boolean isAsynchronusRegistration() {
        return this.async;
    }

    @Override
    public String toString() {
        String source = ",";
        if (this.httpContext != null) {
            source = source + "context=" + this.httpContext;
        } else if (this.contextSupplier != null) {
            source = source + "context=(supplier)";
        } else if (this.contextReference != null) {
            source = source + "ref=" + this.contextReference;
        }
        return "OsgiContextModel{" + (this.whiteboard ? "WB" : (this.wab ? "WAB" : "HS")) + ",id=" + this.getId() + ",name='" + this.name + "',path='" + this.contextPath + (this.ownerBundle == null ? "',shared=true" : "',bundle=" + this.ownerBundle.getSymbolicName()) + source + "}";
    }

    @Override
    public int compareTo(OsgiContextModel o) {
        long serviceRank = (long)o.getServiceRank() - (long)this.getServiceRank();
        if (serviceRank != 0L) {
            return serviceRank > 0L ? 1 : -1;
        }
        long serviceId = this.getServiceId() - o.getServiceId();
        if (serviceId != 0L) {
            return (int)serviceId;
        }
        if (this.isWab() != o.isWab()) {
            return this.isWab() ? -1 : 1;
        }
        return this.getNumericId() - o.getNumericId();
    }

    public String getTemporaryLocation() {
        String name = this.getName();
        name = name.replace("/", "_");
        name = name.replace("\\", "_");
        name = name.replace(":", "_");
        return String.format("%s/%s", "/".equals(this.contextPath) ? "ROOT" : this.contextPath.substring(1), name);
    }

    public ServletContextDTO toDTO() {
        ServletContextDTO scDTO = new ServletContextDTO();
        scDTO.name = this.getName();
        scDTO.contextPath = this.getContextPath();
        scDTO.serviceId = this.getServiceId();
        scDTO.attributes = new HashMap();
        scDTO.attributes.putAll(this.getInitialContextAttributes());
        scDTO.initParams = new HashMap();
        scDTO.initParams.putAll(this.getContextParams());
        return scDTO;
    }

    public FailedServletContextDTO toFailedDTO(int failureReason) {
        FailedServletContextDTO scDTO = new FailedServletContextDTO();
        scDTO.name = this.getName();
        scDTO.contextPath = this.getContextPath();
        scDTO.serviceId = this.getServiceId();
        scDTO.attributes = new HashMap();
        scDTO.attributes.putAll(this.getInitialContextAttributes());
        scDTO.initParams = new HashMap();
        scDTO.initParams.putAll(this.getContextParams());
        scDTO.failureReason = failureReason;
        return scDTO;
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(OsgiContextModel.class);
        DEFAULT_CONTEXT_MODEL = new OsgiContextModel(bundle, 0, 0L, true);
        DEFAULT_CONTEXT_MODEL.setName("default");
        DEFAULT_CONTEXT_MODEL.setContextPath("/");
        DEFAULT_CONTEXT_MODEL.setContextSupplier((context, contextName) -> {
            Bundle whiteboardBundle = context == null ? null : context.getBundle();
            return new WebContainerContextWrapper(whiteboardBundle, new DefaultServletContextHelper(whiteboardBundle), (String)contextName);
        });
        Hashtable<String, Object> registration = DEFAULT_CONTEXT_MODEL.getContextRegistrationProperties();
        registration.clear();
        registration.put("osgi.http.whiteboard.context.name", "default");
        registration.remove("osgi.http.whiteboard.context.httpservice");
        registration.put("service.id", DEFAULT_CONTEXT_MODEL.getServiceId());
        registration.put("service.ranking", DEFAULT_CONTEXT_MODEL.getServiceRank());
        registration.put("osgi.http.whiteboard.context.path", "/");
        DEFAULT_CONTEXT_MODEL.getContextParams().clear();
    }
}

