/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.util.WebContainerListener;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.ops4j.pax.web.service.views.PaxWebContainerView;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebContainerManager
implements BundleListener,
ServiceTrackerCustomizer<WebContainer, ServiceReference<WebContainer>> {
    public static final Logger LOG = LoggerFactory.getLogger(WebContainerManager.class);
    private final BundleContext context;
    private final ServiceTracker<WebContainer, ServiceReference<WebContainer>> webContainerTracker;
    private final AtomicReference<ServiceReference<WebContainer>> currentWebContainerRef = new AtomicReference();
    private final WebContainerListener listener;
    private final Executor pool;
    private final Map<ServiceReference<WebContainer>, Map<Bundle, WebContainer>> containers = new HashMap<ServiceReference<WebContainer>, Map<Bundle, WebContainer>>();

    public WebContainerManager(BundleContext context, WebContainerListener listener) {
        this(context, listener, null);
    }

    public WebContainerManager(BundleContext context, WebContainerListener listener, String threadName) {
        this.context = context;
        this.listener = listener;
        ThreadFactory tf = Executors.defaultThreadFactory();
        this.pool = threadName != null ? Executors.newSingleThreadExecutor(r -> {
            Thread thread = tf.newThread(r);
            thread.setName(threadName);
            return thread;
        }) : Runnable::run;
        this.webContainerTracker = new ServiceTracker(context, WebContainer.class, (ServiceTrackerCustomizer)this);
    }

    public void initialize() {
        this.context.addBundleListener((BundleListener)this);
        this.webContainerTracker.open(false);
    }

    public void shutdown() {
        this.webContainerTracker.close();
        this.context.removeBundleListener((BundleListener)this);
        if (this.pool instanceof ExecutorService) {
            ((ExecutorService)this.pool).shutdown();
        }
    }

    private void webContainerChanged(ServiceReference<WebContainer> oldReference, ServiceReference<WebContainer> newReference) {
        this.currentWebContainerRef.set(newReference);
        this.pool.execute(() -> {
            String name = Thread.currentThread().getName();
            try {
                if (oldReference == null) {
                    Thread.currentThread().setName(name + " (add HttpService)");
                } else if (newReference == null) {
                    Thread.currentThread().setName(name + " (remove HttpService)");
                } else {
                    Thread.currentThread().setName(name + " (change HttpService)");
                }
                this.listener.webContainerChanged(oldReference, newReference);
            }
            finally {
                Thread.currentThread().setName(name);
            }
        });
    }

    public ServiceReference<WebContainer> currentWebContainerReference() {
        return this.currentWebContainerRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PaxWebContainerView> T containerView(Bundle bundle, ServiceReference<WebContainer> ref, Class<T> viewClass) {
        Map<ServiceReference<WebContainer>, Map<Bundle, WebContainer>> map = this.containers;
        synchronized (map) {
            WebContainer webContainer = this.container(bundle, ref);
            if (webContainer != null) {
                return (T)webContainer.adapt(viewClass);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebContainer container(Bundle bundle, ServiceReference<WebContainer> ref) {
        BundleContext bundleContext;
        BundleContext bundleContext2 = bundleContext = bundle != null ? bundle.getBundleContext() : null;
        if (ref == null || bundle == null) {
            return null;
        }
        Map<ServiceReference<WebContainer>, Map<Bundle, WebContainer>> map = this.containers;
        synchronized (map) {
            WebContainer webContainer;
            WebContainer container;
            Map<Bundle, WebContainer> bundleContainers = this.containers.get(ref);
            if (bundleContainers != null && (container = bundleContainers.get(bundle)) != null) {
                return container;
            }
            if (bundleContext == null) {
                return null;
            }
            try {
                webContainer = (WebContainer)bundleContext.getService(ref);
            }
            catch (IllegalStateException e) {
                return null;
            }
            if (webContainer == null) {
                LOG.warn("Can't get a WebContainer service from {}", ref);
                return null;
            }
            this.containers.computeIfAbsent(ref, r -> new HashMap()).put(bundle, webContainer);
            return webContainer;
        }
    }

    public WhiteboardWebContainerView whiteboardView(Bundle bundle) {
        return this.containerView(bundle, this.currentWebContainerRef.get(), WhiteboardWebContainerView.class);
    }

    public WhiteboardWebContainerView whiteboardView(Bundle bundle, ServiceReference<WebContainer> ref) {
        return this.containerView(bundle, ref, WhiteboardWebContainerView.class);
    }

    public void releaseContainer(Bundle bundle) {
        this.releaseContainer(bundle, this.currentWebContainerRef.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseContainer(Bundle bundle, ServiceReference<WebContainer> ref) {
        if (ref == null || bundle == null) {
            return;
        }
        Map<ServiceReference<WebContainer>, Map<Bundle, WebContainer>> map = this.containers;
        synchronized (map) {
            Map<Bundle, WebContainer> bundleContainers = this.containers.get(ref);
            if (bundleContainers != null) {
                WebContainer container = bundleContainers.remove(bundle);
                if (container != null) {
                    try {
                        BundleContext bundleContext = bundle.getBundleContext();
                        if (bundleContext != null) {
                            bundleContext.ungetService(ref);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                if (bundleContainers.isEmpty()) {
                    this.containers.remove(ref);
                }
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            this.pool.execute(() -> {
                String name = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName(name + " (stop " + event.getBundle().getSymbolicName() + ")");
                    this.listener.bundleStopped(event.getBundle());
                }
                finally {
                    Thread.currentThread().setName(name);
                }
            });
        }
    }

    public ServiceReference<WebContainer> addingService(ServiceReference<WebContainer> reference) {
        ServiceReference<WebContainer> currentReference = this.currentWebContainerRef.get();
        if (currentReference == null) {
            this.webContainerChanged(null, reference);
        } else if (currentReference.compareTo(reference) < 0) {
            this.webContainerChanged(currentReference, reference);
        }
        return reference;
    }

    public void modifiedService(ServiceReference<WebContainer> reference, ServiceReference<WebContainer> service) {
        ServiceReference bestReference = this.webContainerTracker.getServiceReference();
        ServiceReference<WebContainer> currentReference = this.currentWebContainerRef.get();
        if (bestReference != null) {
            if (currentReference == null) {
                this.webContainerChanged(null, (ServiceReference<WebContainer>)bestReference);
            } else if (bestReference.compareTo(currentReference) > 0) {
                this.webContainerChanged(currentReference, (ServiceReference<WebContainer>)bestReference);
            }
        } else if (currentReference != null) {
            this.webContainerChanged(currentReference, null);
        }
    }

    public void removedService(ServiceReference<WebContainer> reference, ServiceReference<WebContainer> service) {
        ServiceReference<WebContainer> currentReference = this.currentWebContainerRef.get();
        if (currentReference == null) {
            return;
        }
        ServiceReference bestReference = this.webContainerTracker.getServiceReference();
        this.webContainerChanged(currentReference, (ServiceReference<WebContainer>)bestReference);
    }
}

