/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.lang.management.ManagementFactory;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.config.SecurityConfiguration;
import org.ops4j.pax.web.service.spi.config.ServerConfiguration;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContextClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JettyFactory.class);
    private final Bundle paxWebJettyBundle;
    private final ClassLoader classLoader;
    private boolean alpnAvailable;
    private boolean http2Available;

    JettyFactory(Bundle paxWebJettyBundle, ClassLoader classLoader) {
        this.paxWebJettyBundle = paxWebJettyBundle;
        this.classLoader = classLoader;
        this.discovery();
    }

    private void discovery() {
        try {
            this.classLoader.loadClass("org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory");
            this.alpnAvailable = true;
        }
        catch (ClassNotFoundException e) {
            this.alpnAvailable = false;
        }
        try {
            this.classLoader.loadClass("org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory");
            this.classLoader.loadClass("org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory");
            this.http2Available = true;
        }
        catch (ClassNotFoundException e) {
            this.http2Available = false;
        }
    }

    public QueuedThreadPool createThreadPool(Configuration configuration) {
        Integer idleTimeout;
        Integer minThreads;
        ServerConfiguration sc = configuration.server();
        Integer maxThreads = sc.getServerMaxThreads();
        if (maxThreads == null) {
            maxThreads = 200;
        }
        if ((minThreads = sc.getServerMinThreads()) == null) {
            minThreads = Math.min(8, maxThreads);
        }
        if ((idleTimeout = sc.getServerIdleTimeout()) == null) {
            idleTimeout = 60000;
        }
        String prefix = sc.getServerThreadNamePrefix();
        QueuedThreadPool qtp = new QueuedThreadPool(maxThreads.intValue(), minThreads.intValue(), idleTimeout.intValue());
        if (prefix != null) {
            qtp.setName(prefix);
        }
        try {
            ServerConnector.class.getClassLoader().loadClass("org.eclipse.jetty.util.FutureCallback");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClassLoader cl = QueuedThreadPool.class.getClassLoader();
        for (int i = 1; i <= 3; ++i) {
            try {
                cl.loadClass("org.eclipse.jetty.util.thread.QueuedThreadPool$" + i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return qtp;
    }

    public Connector createDefaultConnector(Server server, Map<String, HttpConfiguration> httpConfigs, String address, Configuration configuration) {
        ServerConfiguration sc = configuration.server();
        HttpConfiguration httpConfig = this.getOrCreateHttpConfiguration(httpConfigs, sc);
        ServerConnector defaultConnector = new ServerConnector(server);
        defaultConnector.clearConnectionFactories();
        defaultConnector.setHost(address);
        defaultConnector.setPort(sc.getHttpPort().intValue());
        defaultConnector.setName(sc.getHttpConnectorName());
        if (sc.getConnectorIdleTimeout() != null) {
            defaultConnector.setIdleTimeout((long)sc.getConnectorIdleTimeout().intValue());
        }
        defaultConnector.addConnectionFactory((ConnectionFactory)new HttpConnectionFactory(httpConfig));
        if (this.http2Available) {
            LOG.info("HTTP/2 ClearText support available, adding \"h2c\" protocol support to default connector");
            defaultConnector.addConnectionFactory((ConnectionFactory)new HTTP2CServerConnectionFactory(httpConfig));
        }
        LOG.info("Default Jetty connector created: {}", (Object)defaultConnector);
        return defaultConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connector createSecureConnector(Server server, Map<String, HttpConfiguration> httpConfigs, String address, Configuration configuration) {
        String sslTruststore;
        String sslKeystore;
        ServerConfiguration sc = configuration.server();
        SecurityConfiguration secc = configuration.security();
        HttpConfiguration httpsConfig = this.getOrCreateHttpConfiguration(httpConfigs, sc);
        if (httpsConfig.getCustomizer(SecureRequestCustomizer.class) == null) {
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        }
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (secc.getSslProvider() != null) {
            sslContextFactory.setProvider(secc.getSslProvider());
        }
        if (this.http2Available) {
            sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        }
        if ((sslKeystore = secc.getSslKeystore()) != null) {
            sslContextFactory.setKeyStorePath(sslKeystore);
        }
        if (secc.getSslKeystorePassword() != null) {
            sslContextFactory.setKeyStorePassword(secc.getSslKeystorePassword());
        }
        if (secc.getSslKeyPassword() != null) {
            sslContextFactory.setKeyManagerPassword(secc.getSslKeyPassword());
        }
        if (secc.getSslKeyManagerFactoryAlgorithm() != null) {
            sslContextFactory.setKeyManagerFactoryAlgorithm(secc.getSslKeyManagerFactoryAlgorithm());
        }
        if (secc.getSslKeyAlias() != null) {
            sslContextFactory.setCertAlias(secc.getSslKeyAlias());
        }
        if (secc.getSslKeystoreType() != null) {
            sslContextFactory.setKeyStoreType(secc.getSslKeystoreType());
        }
        if (secc.getSslKeystoreProvider() != null && !"".equals(secc.getSslKeystoreProvider().trim())) {
            sslContextFactory.setKeyStoreProvider(secc.getSslKeystoreProvider());
        }
        if ((sslTruststore = secc.getTruststore()) != null) {
            sslContextFactory.setTrustStorePath(sslTruststore);
        }
        if (secc.getTruststorePassword() != null) {
            sslContextFactory.setTrustStorePassword(secc.getTruststorePassword());
        }
        if (secc.getTruststoreType() != null) {
            sslContextFactory.setTrustStoreType(secc.getTruststoreType());
        }
        if (secc.getTruststoreProvider() != null && !"".equals(secc.getTruststoreProvider().trim())) {
            sslContextFactory.setTrustStoreProvider(secc.getTruststoreProvider());
        }
        if (secc.getTrustManagerFactoryAlgorithm() != null) {
            sslContextFactory.setTrustManagerFactoryAlgorithm(secc.getTrustManagerFactoryAlgorithm());
        }
        if (secc.isClientAuthWanted() != null) {
            sslContextFactory.setWantClientAuth(secc.isClientAuthWanted().booleanValue());
        }
        if (secc.isClientAuthNeeded() != null) {
            sslContextFactory.setNeedClientAuth(secc.isClientAuthNeeded().booleanValue());
        }
        sslContextFactory.setTrustAll(false);
        sslContextFactory.setHostnameVerifier(null);
        String[] supportedProtocols = new String[]{};
        String[] supportedCipherSuites = new String[]{};
        try {
            SSLParameters params = SSLContext.getDefault().getSupportedSSLParameters();
            supportedProtocols = params.getProtocols();
            supportedCipherSuites = params.getCipherSuites();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Problem checking supported protocols and ciphers suites: " + e.getMessage(), e);
        }
        if (secc.getProtocolsIncluded() != null) {
            sslContextFactory.setIncludeProtocols(secc.getProtocolsIncluded());
        }
        if (secc.getProtocolsExcluded() != null) {
            sslContextFactory.setExcludeProtocols(secc.getProtocolsExcluded());
        }
        if (secc.getCiphersuiteIncluded() != null) {
            sslContextFactory.setIncludeCipherSuites(secc.getCiphersuiteIncluded());
        }
        if (secc.getCiphersuiteExcluded() != null) {
            sslContextFactory.setExcludeCipherSuites(secc.getCiphersuiteExcluded());
        }
        if (secc.getSslProtocol() != null) {
            sslContextFactory.setProtocol(secc.getSslProtocol());
        }
        if (secc.getSecureRandomAlgorithm() != null) {
            sslContextFactory.setSecureRandomAlgorithm(secc.getSecureRandomAlgorithm());
        }
        sslContextFactory.setUseCipherSuitesOrder(true);
        if (secc.isSslRenegotiationAllowed() != null) {
            sslContextFactory.setRenegotiationAllowed(secc.isSslRenegotiationAllowed().booleanValue());
        }
        if (secc.getSslRenegotiationLimit() != null) {
            sslContextFactory.setRenegotiationLimit(secc.getSslRenegotiationLimit().intValue());
        }
        if (secc.getSslSessionsEnabled() != null) {
            sslContextFactory.setSessionCachingEnabled(secc.getSslSessionsEnabled().booleanValue());
        }
        if (secc.getSslSessionCacheSize() != null) {
            sslContextFactory.setSslSessionCacheSize(secc.getSslSessionCacheSize().intValue());
        }
        if (secc.getSslSessionTimeout() != null) {
            sslContextFactory.setSslSessionTimeout(secc.getSslSessionTimeout().intValue());
        }
        if (secc.isValidateCerts() != null) {
            sslContextFactory.setValidateCerts(secc.isValidateCerts().booleanValue());
        }
        if (secc.isValidatePeerCerts() != null) {
            sslContextFactory.setValidatePeerCerts(secc.isValidatePeerCerts().booleanValue());
        }
        if (secc.getCrlPath() != null && !"".equals(secc.getCrlPath().trim())) {
            sslContextFactory.setCrlPath(secc.getCrlPath());
        }
        if (secc.isEnableOCSP() != null) {
            sslContextFactory.setEnableOCSP(secc.isEnableOCSP().booleanValue());
        }
        if (secc.isEnableCRLDP() != null) {
            sslContextFactory.setEnableCRLDP(secc.isEnableCRLDP().booleanValue());
        }
        if (secc.getOcspResponderURL() != null && !"".equals(secc.getOcspResponderURL().trim())) {
            sslContextFactory.setOcspResponderURL(secc.getOcspResponderURL());
        }
        if (secc.getMaxCertPathLength() != null) {
            sslContextFactory.setMaxCertPathLength(secc.getMaxCertPathLength().intValue());
        }
        ServerConnector secureConnector = new ServerConnector(server, null, null, null, -1, -1, new ConnectionFactory[0]);
        secureConnector.clearConnectionFactories();
        secureConnector.setHost(address);
        secureConnector.setPort(sc.getHttpSecurePort().intValue());
        secureConnector.setName(sc.getHttpSecureConnectorName());
        if (sc.getConnectorIdleTimeout() != null) {
            secureConnector.setIdleTimeout((long)sc.getConnectorIdleTimeout().intValue());
        }
        Object ssl = null;
        if (this.alpnAvailable) {
            LOG.info("ALPN support available, adding \"alpn\" protocol support to secure connector");
            secureConnector.addConnectionFactory((ConnectionFactory)new SslConnectionFactory((SslContextFactory)sslContextFactory, "ALPN"));
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                OsgiServletContextClassLoader cl = new OsgiServletContextClassLoader();
                Bundle bundle = FrameworkUtil.getBundle(this.getClass());
                if (bundle != null) {
                    cl.addBundle(bundle);
                    for (Bundle b : bundle.getBundleContext().getBundles()) {
                        String sn = b.getSymbolicName();
                        if (!"org.eclipse.jetty.io".equals(sn) && !"org.eclipse.jetty.alpn.java.server".equals(sn) && !"org.eclipse.jetty.alpn.openjdk8.server".equals(sn)) continue;
                        cl.addBundles(new Bundle[]{b});
                    }
                    Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                }
                ALPNServerConnectionFactory alpnConnectionFactory = new ALPNServerConnectionFactory(new String[0]);
                alpnConnectionFactory.setDefaultProtocol(HttpVersion.HTTP_1_1.asString());
                secureConnector.addConnectionFactory((ConnectionFactory)alpnConnectionFactory);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        } else {
            LOG.info("No ALPN support available, no way to upgrade to HTTP/2 over SSL, no \"h2\" protocol support added.");
            secureConnector.addConnectionFactory((ConnectionFactory)new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()));
        }
        if (this.http2Available) {
            LOG.info("HTTP/2 support available, adding \"h2\" protocol support to secure connector");
            secureConnector.addConnectionFactory((ConnectionFactory)new HTTP2ServerConnectionFactory(httpsConfig));
        }
        secureConnector.addConnectionFactory((ConnectionFactory)new HttpConnectionFactory(httpsConfig));
        LOG.info("Secure Jetty connector created: {}", (Object)secureConnector);
        return secureConnector;
    }

    private HttpConfiguration getOrCreateHttpConfiguration(Map<String, HttpConfiguration> httpConfigs, ServerConfiguration sc) {
        HttpConfiguration httpConfig = null;
        if (httpConfigs.size() > 0) {
            httpConfig = httpConfigs.values().iterator().next();
            if (httpConfigs.size() > 1) {
                LOG.warn("More than one HttpConfiguration found in external Jetty configuration. Using {}.", (Object)httpConfig);
            }
        } else {
            httpConfig = new HttpConfiguration();
            httpConfig.setSendXPoweredBy(false);
            httpConfig.setSendServerVersion(false);
        }
        if (httpConfig.getSecureScheme() == null) {
            httpConfig.setSecureScheme(HttpScheme.HTTPS.asString());
        }
        if (httpConfig.getSecurePort() <= 0) {
            httpConfig.setSecurePort(sc.getHttpSecurePort().intValue());
        }
        if (httpConfig.getOutputBufferSize() <= 0) {
            httpConfig.setOutputBufferSize(32768);
        }
        httpConfig.setMultiPartFormDataCompliance(MultiPartFormDataCompliance.RFC7578);
        if (sc.checkForwardedHeaders() != null && sc.checkForwardedHeaders().booleanValue()) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        return httpConfig;
    }

    public MBeanContainer enableJmxIfPossible(Server server) {
        try {
            ClassLoader cl = this.classLoader;
            if (this.paxWebJettyBundle != null) {
                cl = ((BundleWiring)this.paxWebJettyBundle.adapt(BundleWiring.class)).getClassLoader();
            }
            cl.loadClass("javax.management.JMX");
            cl.loadClass("org.eclipse.jetty.jmx.MBeanContainer");
            LOG.info("Adding JMX support to Jetty server");
            MBeanContainer mBeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            server.addBean((Object)mBeanContainer);
            return mBeanContainer;
        }
        catch (Throwable ignored) {
            LOG.info("No JMX available. Skipping Jetty JMX configuration.");
            return null;
        }
    }
}

