/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.util.WebContainerManager;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWhiteboardApplication {
    private static final Logger LOG = LoggerFactory.getLogger(BundleWhiteboardApplication.class);
    private final Bundle bundle;
    private final Map<ElementModel<?, ?>, Boolean> webElements = new LinkedHashMap();
    private final Map<OsgiContextModel, Boolean> webContexts = new LinkedHashMap<OsgiContextModel, Boolean>();
    private final WebContainerManager webContainerManager;
    private volatile ServiceReference<WebContainer> webContainerServiceRef;

    public BundleWhiteboardApplication(Bundle bundle, WebContainerManager webContainerManager) {
        this.bundle = bundle;
        this.webContainerManager = webContainerManager;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public List<OsgiContextModel> getWebContexts() {
        return Collections.unmodifiableList(new LinkedList<OsgiContextModel>(this.webContexts.keySet()));
    }

    public List<OsgiContextModel> getWebContainerOsgiContextModels() {
        LinkedList<OsgiContextModel> models = new LinkedList<OsgiContextModel>();
        WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(this.bundle, this.webContainerServiceRef);
        if (view != null) {
            models.addAll(view.getOsgiContextModels(this.bundle));
        }
        return models;
    }

    public List<ElementModel<?, ?>> getWebElements() {
        return Collections.unmodifiableList(new LinkedList(this.webElements.keySet()));
    }

    public void webContainerAdded(ServiceReference<WebContainer> ref) {
        this.webContainerServiceRef = ref;
        WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(this.bundle, ref);
        if (view != null) {
            this.webContexts.keySet().forEach(ctx -> {
                if (!this.webContexts.get(ctx).booleanValue()) {
                    view.addWhiteboardOsgiContextModel(ctx);
                    this.webContexts.put((OsgiContextModel)ctx, true);
                }
            });
            this.webElements.keySet().forEach(element -> {
                if (!this.webElements.get(element).booleanValue() && element.getContextModels().size() > 0) {
                    element.register(view);
                    this.webElements.put((ElementModel<?, ?>)element, true);
                }
            });
        }
    }

    public void webContainerRemoved(ServiceReference<WebContainer> ref) {
        if (ref != this.webContainerServiceRef) {
            throw new IllegalStateException("Removing unknown WebContainer reference " + ref + ", expecting " + this.webContainerServiceRef);
        }
        WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(this.bundle, ref);
        if (view != null) {
            this.webElements.keySet().forEach(element -> {
                if (element.getContextModels().size() > 0 && this.webElements.get(element).booleanValue()) {
                    this.webElements.put((ElementModel<?, ?>)element, false);
                }
            });
            this.webContexts.keySet().forEach(ctx -> {
                if (this.webContexts.get(ctx).booleanValue()) {
                    this.webContexts.put((OsgiContextModel)ctx, false);
                }
            });
        }
        this.webContainerManager.releaseContainer(this.bundle, ref);
        this.webContainerServiceRef = null;
    }

    public void addWebContext(OsgiContextModel webContext) {
        this.webContexts.put(webContext, false);
        WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(this.bundle, this.webContainerServiceRef);
        if (view != null) {
            view.addWhiteboardOsgiContextModel(webContext);
            this.webContexts.put(webContext, true);
        }
    }

    public void removeWebContext(OsgiContextModel webContext) {
        this.webContexts.remove(webContext);
        WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(this.bundle, this.webContainerServiceRef);
        if (view == null) {
            LOG.debug("{} will be unregistered when WebContainer/HttpService is available", (Object)webContext);
            return;
        }
        view.removeWhiteboardOsgiContextModel(webContext);
    }

    public void addWebElement(ElementModel<?, ?> webElement) {
        WhiteboardWebContainerView view;
        this.webElements.put(webElement, false);
        if (webElement.getContextModels().size() == 0) {
            LOG.info("No matching target context(s) for Whiteboard element {}. Filter: {}. Element may be re-registered later, when matching context/s is/are registered.", webElement, (Object)webElement.getContextFilter());
        }
        if ((view = this.webContainerManager.whiteboardView(this.bundle, this.webContainerServiceRef)) == null) {
            LOG.debug("{} will be registered when WebContainer/HttpService is available", webElement);
            return;
        }
        if (webElement.getContextModels().size() > 0) {
            webElement.register(view);
            this.webElements.put(webElement, true);
        }
    }

    public void removeWebElement(ElementModel<?, ?> webElement) {
        this.webElements.remove(webElement);
        WhiteboardWebContainerView view = this.webContainerManager.whiteboardView(this.bundle, this.webContainerServiceRef);
        if (view == null) {
            LOG.debug("{} will be unregistered when WebContainer/HttpService is available", webElement);
            return;
        }
        if (webElement.getContextModels().size() > 0) {
            webElement.unregister(view);
        }
    }

    public void cleanup() {
        this.webContexts.clear();
        this.webElements.clear();
        this.webContainerManager.releaseContainer(this.bundle);
    }

    public WhiteboardWebContainerView getWhiteboardContainer() {
        return this.webContainerManager.whiteboardView(this.bundle, this.webContainerServiceRef);
    }
}

