/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.services.staticcm;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.services.staticcm.Configurations;
import org.apache.karaf.services.staticcm.StaticConfigAdminImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class Activator
implements BundleActivator {
    public static final String CONFIG_DIRS = "org.apache.karaf.services.staticcm.ConfigDirs";
    ServiceRegistration<ConfigurationAdmin> registration;

    public void start(BundleContext context) throws Exception {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        String cfgDirs = context.getProperty(CONFIG_DIRS);
        if (cfgDirs == null) {
            cfgDirs = System.getProperty("karaf.etc");
        }
        for (String dir : cfgDirs.split(",")) {
            List<Configuration> cfgs = Configurations.loadConfigurations(context, new File(dir.trim()));
            configs.addAll(cfgs);
        }
        StaticConfigAdminImpl cm = new StaticConfigAdminImpl(context, configs);
        this.registration = context.registerService(ConfigurationAdmin.class, (Object)cm, null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

