/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.services.staticcm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.karaf.services.staticcm.StaticConfigurationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;

public class Configurations {
    public static List<Configuration> loadConfigurations(BundleContext context, File directory) throws IOException {
        HashMap<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".cfg")) continue;
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    Properties p = new Properties();
                    ((InputStream)in).mark(1);
                    boolean isXml = ((InputStream)in).read() == 60;
                    ((InputStream)in).reset();
                    if (isXml) {
                        p.loadFromXML(in);
                    } else {
                        p.load(in);
                    }
                    HashMap<String, String> strMap = new HashMap<String, String>();
                    for (Object k : p.keySet()) {
                        strMap.put(k.toString(), p.getProperty(k.toString()));
                    }
                    configs.put(file.getName(), strMap);
                }
            }
        }
        return Configurations.createConfigurations(context, configs);
    }

    public static List<Configuration> createConfigurations(BundleContext context, Map<String, Map<String, String>> configs) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (Map.Entry<String, Map<String, String>> entry : configs.entrySet()) {
            String[] pid = Configurations.parsePid(entry.getKey());
            Map<String, String> cfg = entry.getValue();
            InterpolationHelper.performSubstitution(cfg, context);
            cfg.put("service.pid", pid[0]);
            configurations.add(new StaticConfigurationImpl(pid[0], pid[1], new Hashtable<String, Object>(cfg)));
        }
        return configurations;
    }

    private static String[] parsePid(String path) {
        String pid = path.substring(0, path.lastIndexOf(46));
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }
}

