/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.services.staticcm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.services.staticcm.StaticConfigurationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;

public class Configurations {
    public static List<Configuration> loadConfigurations(BundleContext context, File directory) throws IOException {
        HashMap<String, Map<String, Object>> configs = new HashMap<String, Map<String, Object>>();
        File[] files = directory.listFiles();
        InterpolationHelper.BundleContextSubstitutionCallback cb = new InterpolationHelper.BundleContextSubstitutionCallback(context);
        TypedProperties.SubstitutionCallback substitutionCallback = (name, key, value) -> cb.getValue(value);
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".cfg")) continue;
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    ((InputStream)in).mark(1);
                    boolean isXml = ((InputStream)in).read() == 60;
                    ((InputStream)in).reset();
                    if (isXml) {
                        Properties p = new Properties();
                        p.loadFromXML(in);
                        HashMap<String, String> strMap = new HashMap<String, String>();
                        for (Object k : p.keySet()) {
                            strMap.put(k.toString(), p.getProperty(k.toString()));
                        }
                        configs.put(file.getName(), strMap);
                        continue;
                    }
                    TypedProperties prop = new TypedProperties(substitutionCallback);
                    prop.load(in);
                    configs.put(file.getName(), prop);
                }
            }
        }
        return Configurations.createConfigurations(context, configs);
    }

    public static List<Configuration> createConfigurations(BundleContext context, Map<String, Map<String, Object>> configs) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (Map.Entry<String, Map<String, Object>> entry : configs.entrySet()) {
            String factoryPid;
            String servicePid;
            String[] pid = Configurations.parsePid(entry.getKey());
            Map<String, Object> cfg = entry.getValue();
            if (pid[1] == null) {
                servicePid = pid[0];
                factoryPid = null;
                cfg.put("service.pid", pid[0]);
            } else {
                servicePid = pid[0] + "." + pid[1];
                factoryPid = pid[0];
            }
            cfg.put("service.pid", servicePid);
            if (factoryPid != null) {
                cfg.put("service.factoryPid", factoryPid);
            }
            configurations.add(new StaticConfigurationImpl(servicePid, factoryPid, new Hashtable<String, Object>(cfg)));
        }
        return configurations;
    }

    private static String[] parsePid(String path) {
        String pid = path.substring(0, path.lastIndexOf(46));
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }
}

