/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.opt.security.MBeanServerAccessController;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import javax.security.auth.Subject;

public class MBeanServerFileAccessController
extends MBeanServerAccessController {
    public static final String READONLY = "readonly";
    public static final String READWRITE = "readwrite";
    private Properties props;
    private Properties originalProps;
    private String accessFileName;

    public MBeanServerFileAccessController(String accessFileName) throws IOException {
        this.accessFileName = accessFileName;
        this.props = MBeanServerFileAccessController.propertiesFromFile(accessFileName);
        this.checkValues(this.props);
    }

    public MBeanServerFileAccessController(String accessFileName, MBeanServer mbs) throws IOException {
        this(accessFileName);
        this.setMBeanServer(mbs);
    }

    public MBeanServerFileAccessController(Properties accessFileProps) throws IOException {
        if (accessFileProps == null) {
            throw new IllegalArgumentException("Null properties");
        }
        this.originalProps = accessFileProps;
        this.props = (Properties)accessFileProps.clone();
        this.checkValues(this.props);
    }

    public MBeanServerFileAccessController(Properties accessFileProps, MBeanServer mbs) throws IOException {
        this(accessFileProps);
        this.setMBeanServer(mbs);
    }

    public void checkRead() {
        this.checkAccessLevel(READONLY);
    }

    public void checkWrite() {
        this.checkAccessLevel(READWRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws IOException {
        Properties properties = this.props;
        synchronized (properties) {
            this.props = this.accessFileName == null ? (Properties)this.originalProps.clone() : MBeanServerFileAccessController.propertiesFromFile(this.accessFileName);
            this.checkValues(this.props);
        }
    }

    private static Properties propertiesFromFile(String fname) throws IOException {
        FileInputStream fin = new FileInputStream(fname);
        Properties p = new Properties();
        p.load(fin);
        fin.close();
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAccessLevel(String accessLevel) {
        final AccessControlContext acc = AccessController.getContext();
        Subject s = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Subject.getSubject(acc);
            }
        });
        if (s == null) {
            return;
        }
        Set<Principal> principals = s.getPrincipals();
        Iterator<Principal> i = principals.iterator();
        while (i.hasNext()) {
            String grantedAccessLevel;
            Principal p = i.next();
            Properties properties = this.props;
            synchronized (properties) {
                grantedAccessLevel = this.props.getProperty(p.getName());
            }
            if (grantedAccessLevel == null) continue;
            if (accessLevel.equals(READONLY) && (grantedAccessLevel.equals(READONLY) || grantedAccessLevel.equals(READWRITE))) {
                return;
            }
            if (!accessLevel.equals(READWRITE) || !grantedAccessLevel.equals(READWRITE)) continue;
            return;
        }
        throw new SecurityException("Access denied! Invalid access level for requested MBeanServer operation.");
    }

    private void checkValues(Properties props) {
        Collection<Object> c = props.values();
        Iterator<Object> i = c.iterator();
        while (i.hasNext()) {
            String accessLevel = (String)i.next();
            if (accessLevel.equals(READONLY) || accessLevel.equals(READWRITE)) continue;
            throw new IllegalArgumentException("Syntax error in access level entry [" + accessLevel + "]");
        }
    }
}

