/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.exceptions;

import aQute.lib.exceptions.RunnableWithException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.Callable;

public class Exceptions {
    private Exceptions() {
    }

    public static <V> V unchecked(Callable<? extends V> callable) {
        try {
            return callable.call();
        }
        catch (Exception t) {
            throw Exceptions.duck(t);
        }
    }

    public static void unchecked(RunnableWithException runnable) {
        try {
            runnable.run();
        }
        catch (Exception t) {
            throw Exceptions.duck(t);
        }
    }

    public static RuntimeException duck(Throwable t) {
        Exceptions.throwsUnchecked(t);
        throw new AssertionError((Object)"unreachable");
    }

    private static <E extends Throwable> void throwsUnchecked(Throwable throwable) throws E {
        throw throwable;
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Throwable unrollCause(Throwable t, Class<? extends Throwable> unrollType) {
        Throwable cause;
        Objects.requireNonNull(t);
        while (unrollType.isInstance(t) && (cause = t.getCause()) != null) {
            t = cause;
        }
        return t;
    }

    public static Throwable unrollCause(Throwable t) {
        return Exceptions.unrollCause(t, Throwable.class);
    }

    public static String causes(Throwable t) {
        StringJoiner sj = new StringJoiner(" -> ");
        while (t != null) {
            sj.add(t.getMessage());
            t = t.getCause();
        }
        return sj.toString();
    }
}

