/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.example.config.managedfactory;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator {
    private ServiceRegistration<ManagedServiceFactory> registration;

    public void start(BundleContext bundleContext) {
        ManagedServiceFactory factory = new ManagedServiceFactory(){

            public String getName() {
                return "Example Managed Factory";
            }

            public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
                System.out.println("New configuration with pid " + pid);
                Enumeration<String> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    System.out.println(key + " = " + properties.get(key));
                }
            }

            public void deleted(String pid) {
                System.out.println("Delete configuration with pid " + pid);
            }
        };
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        serviceProperties.put("service.pid", "org.apache.karaf.example.config");
        this.registration = bundleContext.registerService(ManagedServiceFactory.class, (Object)factory, serviceProperties);
    }

    public void stop(BundleContext bundleContext) {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

