/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.blueprint.client;

import org.apache.karaf.examples.blueprint.client.ClientService;
import org.apache.karaf.examples.blueprint.common.Booking;

public class Display {
    private ClientService clientService;
    private BookingDisplayThread thread;
    private boolean bookingThreadStarted = false;

    public void setClientService(ClientService clientService) {
        this.clientService = clientService;
    }

    public void init() {
        BookingDisplayThread thread = new BookingDisplayThread(this.clientService);
        thread.start();
    }

    public void destroy() {
        this.thread.terminate();
    }

    private class BookingDisplayThread
    extends Thread {
        private ClientService clientService;
        private volatile boolean running = true;

        public BookingDisplayThread(ClientService clientService) {
            this.clientService = clientService;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Booking booking = new Booking("John Doo", "AF3030");
                    this.clientService.addBooking(booking);
                    System.out.println(this.displayBookings());
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            }
        }

        private String displayBookings() {
            StringBuilder builder = new StringBuilder();
            for (Booking booking : this.clientService.bookings()) {
                builder.append(booking.getId()).append(" | ").append(booking.getCustomer()).append(" | ").append(booking.getFlight()).append("\n");
            }
            return builder.toString();
        }

        public void terminate() {
            this.running = false;
        }
    }
}

