/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.management.internal;

import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.TabularData;
import org.apache.karaf.scr.management.ScrServiceMBean;
import org.apache.karaf.scr.management.codec.JmxComponent;
import org.apache.karaf.scr.management.internal.ScrService;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="ScrServiceMBean", enabled=true, immediate=true, properties={"org/apache/karaf/scr/management/internal/ScrServiceMBeanImpl.properties"})
public class ScrServiceMBeanImpl
extends StandardMBean
implements ScrServiceMBean {
    public static final String OBJECT_NAME = "org.apache.karaf:type=scr,name=" + System.getProperty("karaf.name", "root");
    public static final String COMPONENT_NAME = "ScrServiceMBean";
    public static final String COMPONENT_LABEL = "Apache Karaf SCR Service MBean";
    private static final Logger LOGGER = LoggerFactory.getLogger(ScrServiceMBeanImpl.class);
    private MBeanServer mBeanServer;
    private ScrService scrService;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public ScrServiceMBeanImpl() throws NotCompliantMBeanException {
        super(ScrServiceMBean.class);
    }

    @Activate
    public void activate() throws Exception {
        LOGGER.info("Activating the Apache Karaf SCR Service MBean");
        HashMap<ScrServiceMBeanImpl, String> mbeans = new HashMap<ScrServiceMBeanImpl, String>();
        mbeans.put(this, "org.apache.karaf:type=scr,name=${karaf.name}");
        try {
            this.lock.writeLock().lock();
            if (this.mBeanServer != null) {
                this.mBeanServer.registerMBean(this, new ObjectName(OBJECT_NAME));
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception registering the SCR Management MBean: " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Deactivate
    public void deactivate() throws Exception {
        LOGGER.info("Deactivating the Apache Karaf SCR Service MBean");
        try {
            this.lock.writeLock().lock();
            if (this.mBeanServer != null) {
                this.mBeanServer.unregisterMBean(new ObjectName(OBJECT_NAME));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public TabularData getComponents() {
        try {
            return JmxComponent.tableFrom(this.scrService.getComponents());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public String[] listComponents() {
        ScrService.Component[] components = this.scrService.getComponents();
        String[] componentNames = new String[components.length];
        for (int i = 0; i < componentNames.length; ++i) {
            componentNames[i] = components[i].getName();
        }
        return componentNames;
    }

    @Override
    public boolean isComponentActive(String componentName) throws MBeanException {
        try {
            return this.componentState(componentName) == 16;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public int componentState(String componentName) {
        int state = -1;
        ScrService.Component component = this.findComponent(componentName);
        if (component != null) {
            state = component.getState();
        } else {
            LOGGER.warn("No component found for name: " + componentName);
        }
        return state;
    }

    @Override
    public void activateComponent(String componentName) {
        ScrService.Component component = this.findComponent(componentName);
        if (component != null) {
            component.enable();
        } else {
            LOGGER.warn("No component found for name: " + componentName);
        }
    }

    @Override
    public void deactivateComponent(String componentName) {
        ScrService.Component component = this.findComponent(componentName);
        if (component != null) {
            component.disable();
        } else {
            LOGGER.warn("No component found for name: " + componentName);
        }
    }

    private ScrService.Component findComponent(String componentName) {
        ScrService.Component answer = null;
        if (this.scrService.getComponents(componentName) != null) {
            ScrService.Component[] components;
            ScrService.Component[] componentArray = components = this.scrService.getComponents(componentName);
            int n = componentArray.length;
            for (int i = 0; i < n; ++i) {
                ScrService.Component component;
                answer = component = componentArray[i];
            }
        }
        return answer;
    }

    @Reference
    public void setmBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public void unsetmBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = null;
    }

    @Reference
    public void setScrService(ServiceComponentRuntime scrService) {
        this.scrService = new ScrService(FrameworkUtil.getBundle(this.getClass()).getBundleContext(), scrService);
    }

    public void unsetScrService(ServiceComponentRuntime scrService) {
        this.scrService = null;
    }
}

