/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.management.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;

public class ScrService {
    private final BundleContext context;
    private final ServiceComponentRuntime runtime;

    public ScrService(BundleContext context, ServiceComponentRuntime runtime) {
        this.context = context.getBundle(0L).getBundleContext();
        this.runtime = runtime;
    }

    public Component[] getComponents() {
        ArrayList<Component> result = new ArrayList<Component>();
        Collection descriptions = this.runtime.getComponentDescriptionDTOs(new Bundle[0]);
        for (ComponentDescriptionDTO descDTO : descriptions) {
            Collection configs = this.runtime.getComponentConfigurationDTOs(descDTO);
            ComponentConfigurationDTO configDTO = null;
            if (!configs.isEmpty()) {
                configDTO = (ComponentConfigurationDTO)configs.iterator().next();
            }
            result.add(new Component(this.context, this.runtime, descDTO, configDTO));
        }
        return result.toArray(new Component[result.size()]);
    }

    public Component[] getComponents(String componentName) {
        ArrayList<Component> result = new ArrayList<Component>();
        Collection descriptions = this.runtime.getComponentDescriptionDTOs(new Bundle[0]);
        for (ComponentDescriptionDTO descDTO : descriptions) {
            if (!descDTO.name.equals(componentName)) continue;
            Collection configs = this.runtime.getComponentConfigurationDTOs(descDTO);
            ComponentConfigurationDTO configDTO = null;
            if (!configs.isEmpty()) {
                configDTO = (ComponentConfigurationDTO)configs.iterator().next();
            }
            result.add(new Component(this.context, this.runtime, descDTO, configDTO));
        }
        return result.isEmpty() ? null : result.toArray(new Component[result.size()]);
    }

    public static final class Reference {
        private static final String CARDINALITY_0_1 = "0..1";
        private static final String CARDINALITY_0_N = "0..n";
        private static final String CARDINALITY_1_N = "1..n";
        private static final String POLICY_STATIC = "static";
        private static final String POLICY_OPTION_RELUCTANT = "reluctant";
        private final ReferenceDTO dto;
        private final SatisfiedReferenceDTO satisfiedDTO;
        private final BundleContext bundleContext;

        public Reference(BundleContext bundleContext, ReferenceDTO dto, SatisfiedReferenceDTO satisfied) {
            this.bundleContext = bundleContext;
            this.dto = dto;
            this.satisfiedDTO = satisfied;
        }

        public String getName() {
            return this.dto.name;
        }

        public String getServiceName() {
            return this.dto.interfaceName;
        }

        public ServiceReference[] getServiceReferences() {
            if (this.satisfiedDTO == null) {
                return null;
            }
            ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>();
            for (ServiceReferenceDTO dto : this.satisfiedDTO.boundServices) {
                try {
                    ServiceReference[] serviceRefs = this.bundleContext.getServiceReferences((String)null, "(service.id=" + String.valueOf(dto.id) + ")");
                    if (serviceRefs == null || serviceRefs.length <= 0) continue;
                    refs.add(serviceRefs[0]);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
            return refs.toArray(new ServiceReference[refs.size()]);
        }

        public ServiceReference<?>[] getBoundServiceReferences() {
            return this.getServiceReferences();
        }

        public boolean isSatisfied() {
            return this.satisfiedDTO != null;
        }

        public boolean isOptional() {
            return CARDINALITY_0_1.equals(this.dto.cardinality) || CARDINALITY_0_N.equals(this.dto.cardinality);
        }

        public boolean isMultiple() {
            return CARDINALITY_1_N.equals(this.dto.cardinality) || CARDINALITY_0_N.equals(this.dto.cardinality);
        }

        public boolean isStatic() {
            return POLICY_STATIC.equals(this.dto.policy);
        }

        public boolean isReluctant() {
            return POLICY_OPTION_RELUCTANT.equals(this.dto.policyOption);
        }

        public String getTarget() {
            return this.dto.target;
        }

        public String getBindMethodName() {
            return this.dto.bind;
        }

        public String getUnbindMethodName() {
            return this.dto.unbind;
        }

        public String getUpdatedMethodName() {
            return this.dto.unbind;
        }
    }

    public static final class Component {
        public static final int STATE_DISABLED = 1;
        @Deprecated
        public static final int STATE_ENABLING = 512;
        @Deprecated
        public static final int STATE_ENABLED = 2;
        public static final int STATE_UNSATISFIED = 4;
        @Deprecated
        public static final int STATE_ACTIVATING = 8;
        public static final int STATE_ACTIVE = 16;
        public static final int STATE_REGISTERED = 32;
        public static final int STATE_FACTORY = 64;
        @Deprecated
        public static final int STATE_DEACTIVATING = 128;
        @Deprecated
        public static final int STATE_DISABLING = 1024;
        @Deprecated
        public static final int STATE_DISPOSING = 2048;
        @Deprecated
        public static final int STATE_DESTROYED = 256;
        public static final int STATE_DISPOSED = 256;
        private final ComponentDescriptionDTO description;
        private final ComponentConfigurationDTO configuration;
        private final BundleContext bundleContext;
        private final ServiceComponentRuntime runtime;

        public Component(BundleContext bundleContext, ServiceComponentRuntime runtime, ComponentDescriptionDTO description, ComponentConfigurationDTO configuration) {
            this.bundleContext = bundleContext;
            this.description = description;
            this.configuration = configuration;
            this.runtime = runtime;
        }

        public long getId() {
            return this.configuration != null ? this.configuration.id : -1L;
        }

        public String getName() {
            return this.description.name;
        }

        public int getState() {
            if (this.configuration == null) {
                return 4;
            }
            int s = this.configuration.state;
            switch (s) {
                case 8: {
                    return 16;
                }
                case 4: {
                    return 2;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 4;
                }
            }
            return 2;
        }

        public Bundle getBundle() {
            return this.bundleContext.getBundle(this.description.bundle.id);
        }

        public String getFactory() {
            return this.description.factory;
        }

        public boolean isServiceFactory() {
            return !"singleton".equals(this.description.scope);
        }

        public String getClassName() {
            return this.description.implementationClass;
        }

        public boolean isDefaultEnabled() {
            return this.description.defaultEnabled;
        }

        public boolean isImmediate() {
            return this.description.immediate;
        }

        public String[] getServices() {
            return this.description.serviceInterfaces.length == 0 ? null : this.description.serviceInterfaces;
        }

        public Dictionary getProperties() {
            return new Hashtable(this.description.properties);
        }

        public Reference[] getReferences() {
            if (this.configuration == null) {
                return null;
            }
            ArrayList<Reference> result = new ArrayList<Reference>();
            for (ReferenceDTO dto : this.description.references) {
                SatisfiedReferenceDTO sRef = null;
                for (SatisfiedReferenceDTO r : this.configuration.satisfiedReferences) {
                    if (!r.name.equals(dto.name)) continue;
                    sRef = r;
                    break;
                }
                result.add(new Reference(this.bundleContext, dto, sRef));
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new Reference[result.size()]);
        }

        public ComponentInstance getComponentInstance() {
            return null;
        }

        public String getActivate() {
            return this.description.activate;
        }

        public boolean isActivateDeclared() {
            return this.description.activate != null;
        }

        public String getDeactivate() {
            return this.description.deactivate;
        }

        public boolean isDeactivateDeclared() {
            return this.description.deactivate != null;
        }

        public String getModified() {
            return this.description.modified;
        }

        public String getConfigurationPolicy() {
            return this.description.configurationPolicy;
        }

        public String getConfigurationPid() {
            String[] pids = this.description.configurationPid;
            return pids[0];
        }

        public boolean isConfigurationPidDeclared() {
            return true;
        }

        public void enable() {
        }

        public void disable() {
        }
    }
}

