/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.Objects;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.features.internal.service.Blacklist;

public class RepositoryImpl
implements Repository {
    private final URI uri;
    private final Blacklist blacklist;
    private Features features;

    public RepositoryImpl(URI uri) {
        this(uri, null, false);
    }

    public RepositoryImpl(URI uri, Blacklist blacklist, boolean validate) {
        this.uri = uri;
        this.blacklist = blacklist;
        this.load(validate);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getName() {
        return this.features.getName();
    }

    @Override
    public URI[] getRepositories() {
        return (URI[])this.features.getRepository().stream().map(String::trim).map(URI::create).toArray(URI[]::new);
    }

    @Override
    public URI[] getResourceRepositories() {
        return (URI[])this.features.getResourceRepository().stream().map(String::trim).map(URI::create).toArray(URI[]::new);
    }

    @Override
    public Feature[] getFeatures() {
        return this.features.getFeature().toArray(new Feature[this.features.getFeature().size()]);
    }

    private void load(boolean validate) {
        if (this.features == null) {
            try (InterruptibleInputStream inputStream = new InterruptibleInputStream(this.uri.toURL().openStream());){
                this.features = JaxbUtil.unmarshal(this.uri.toASCIIString(), inputStream, validate);
                if (this.blacklist != null) {
                    this.blacklist.blacklist(this.features);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage() + " : " + this.uri, e);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryImpl that = (RepositoryImpl)o;
        return Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    public String toString() {
        return this.getURI().toString();
    }

    static class InterruptibleInputStream
    extends FilterInputStream {
        InterruptibleInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            return super.read(b, off, len);
        }
    }
}

