/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.region.DigraphHelper;
import org.apache.karaf.features.internal.service.BundleInstallSupport;
import org.apache.karaf.features.internal.service.FeatureConfigInstaller;
import org.apache.karaf.util.bundles.BundleUtils;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleInstallSupportImpl
implements BundleInstallSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleInstallSupportImpl.class);
    private final RegionDigraph digraph;
    private final Bundle ourBundle;
    private final BundleContext ourBundleContext;
    private final FeatureConfigInstaller configInstaller;
    private final BundleContext systemBundleContext;
    private Map<Thread, ResolverHook> hooks = new ConcurrentHashMap<Thread, ResolverHook>();
    private ServiceRegistration<ResolverHookFactory> hookRegistration;

    public BundleInstallSupportImpl(Bundle ourBundle, BundleContext ourBundleContext, BundleContext systemBundleContext, FeatureConfigInstaller configInstaller, RegionDigraph digraph) {
        this.ourBundle = ourBundle;
        this.ourBundleContext = ourBundleContext;
        this.systemBundleContext = systemBundleContext;
        this.configInstaller = configInstaller;
        this.digraph = digraph;
        if (systemBundleContext != null) {
            this.hookRegistration = systemBundleContext.registerService(ResolverHookFactory.class, triggers -> this.hooks.get(Thread.currentThread()), null);
        }
    }

    @Override
    public void unregister() {
        if (this.hookRegistration != null) {
            this.hookRegistration.unregister();
        }
    }

    @Override
    public void print(String message, boolean verbose) {
        LOGGER.info(message);
        if (verbose) {
            System.out.println(message);
        }
    }

    @Override
    public void refreshPackages(Collection<Bundle> bundles) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        FrameworkWiring fw = (FrameworkWiring)this.systemBundleContext.getBundle().adapt(FrameworkWiring.class);
        fw.refreshBundles(bundles, new FrameworkListener[]{event -> {
            if (event.getType() == 2) {
                LOGGER.error("Framework error", event.getThrowable());
            }
            latch.countDown();
        }});
        latch.await();
    }

    @Override
    public Bundle installBundle(String region, String uri, InputStream is) throws BundleException {
        if ("root".equals(region)) {
            return this.digraph.getRegion(region).installBundleAtLocation(uri, is);
        }
        return this.digraph.getRegion(region).installBundle(uri, is);
    }

    @Override
    public void updateBundle(Bundle bundle, String uri, InputStream is) throws BundleException {
        try {
            File file = BundleUtils.fixBundleWithUpdateLocation(is, uri);
            bundle.update((InputStream)new FileInputStream(file));
            file.delete();
        }
        catch (IOException e) {
            throw new BundleException("Unable to update bundle", (Throwable)e);
        }
    }

    @Override
    public void uninstall(Bundle bundle) throws BundleException {
        bundle.uninstall();
    }

    @Override
    public void startBundle(Bundle bundle) throws BundleException {
        if (bundle != this.ourBundle || bundle.getState() != 8) {
            bundle.start();
        }
    }

    @Override
    public void stopBundle(Bundle bundle, int options) throws BundleException {
        bundle.stop(options);
    }

    @Override
    public void setBundleStartLevel(Bundle bundle, int startLevel) {
        ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(startLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveBundles(Set<Bundle> bundles, final Map<Resource, List<Wire>> wiring, Map<Resource, Bundle> resToBnd) {
        final Thread thread = Thread.currentThread();
        final HashMap<Bundle, Resource> bndToRes = new HashMap<Bundle, Resource>();
        for (Resource res : resToBnd.keySet()) {
            bndToRes.put(resToBnd.get(res), res);
        }
        ResolverHook hook = new ResolverHook(){

            public void filterResolvable(Collection<BundleRevision> candidates) {
            }

            public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
            }

            public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                if (Thread.currentThread() == thread) {
                    if ("osgi.ee".equals(requirement.getNamespace())) {
                        return;
                    }
                    Bundle sourceBundle = requirement.getRevision().getBundle();
                    Resource sourceResource = (Resource)bndToRes.get(sourceBundle);
                    List wires = (List)wiring.get(sourceResource);
                    if (sourceBundle == null || wires == null) {
                        return;
                    }
                    HashSet<Resource> wired = new HashSet<Resource>();
                    wired.add(sourceResource);
                    for (Wire wire : wires) {
                        wired.add(wire.getProvider());
                        if (!"osgi.wiring.host".equals(wire.getRequirement().getNamespace())) continue;
                        for (Wire hostWire : (List)wiring.get(wire.getProvider())) {
                            wired.add(hostWire.getProvider());
                        }
                    }
                    Iterator<BundleCapability> candIter = candidates.iterator();
                    while (candIter.hasNext()) {
                        BundleCapability cand = candIter.next();
                        BundleRevision br = cand.getRevision();
                        if ((br.getTypes() & 1) != 0) {
                            br = ((BundleWire)br.getWiring().getRequiredWires(null).get(0)).getProvider();
                        }
                        Resource res = (Resource)bndToRes.get(br.getBundle());
                        if (wired.contains(br) || wired.contains(res)) continue;
                        candIter.remove();
                    }
                }
            }

            public void end() {
            }
        };
        this.hooks.put(Thread.currentThread(), hook);
        try {
            FrameworkWiring frameworkWiring = (FrameworkWiring)this.systemBundleContext.getBundle().adapt(FrameworkWiring.class);
            frameworkWiring.resolveBundles(bundles);
        }
        finally {
            this.hooks.remove(Thread.currentThread());
        }
    }

    @Override
    public void replaceDigraph(Map<String, Map<String, Map<String, Set<String>>>> policies, Map<String, Set<Long>> bundles) throws BundleException, InvalidSyntaxException {
        RegionDigraph temp = this.digraph.copy();
        for (Region region : temp.getRegions()) {
            temp.removeRegion(region);
        }
        for (String string : policies.keySet()) {
            temp.createRegion(string);
        }
        for (Map.Entry entry : bundles.entrySet()) {
            Region region = temp.getRegion((String)entry.getKey());
            Iterator<Object> iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                region.addBundle(l);
            }
        }
        for (Map.Entry entry : policies.entrySet()) {
            Region region1 = temp.getRegion((String)entry.getKey());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                Region region2 = temp.getRegion((String)entry2.getKey());
                RegionFilterBuilder rfb = temp.createRegionFilterBuilder();
                for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                    for (String flt : (Set)entry3.getValue()) {
                        rfb.allow((String)entry3.getKey(), flt);
                    }
                }
                region1.connectRegion(region2, rfb.build());
            }
        }
        DigraphHelper.verifyUnmanagedBundles(this.systemBundleContext, temp);
        this.digraph.replace(temp);
    }

    @Override
    public void saveDigraph() {
        DigraphHelper.saveDigraph(this.getDataFile("digraph.json"), this.digraph);
    }

    @Override
    public RegionDigraph getDiGraphCopy() throws BundleException {
        return this.digraph.copy();
    }

    @Override
    public void installConfigs(Feature feature) throws IOException, InvalidSyntaxException {
        if (this.configInstaller != null) {
            this.configInstaller.installFeatureConfigs(feature);
        }
    }

    @Override
    public void installLibraries(Feature feature) {
    }

    @Override
    public File getDataFile(String fileName) {
        return this.ourBundleContext.getDataFile(fileName);
    }

    @Override
    public BundleInstallSupport.FrameworkInfo getInfo() {
        BundleInstallSupport.FrameworkInfo info = new BundleInstallSupport.FrameworkInfo();
        info.ourBundle = this.ourBundle;
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.systemBundleContext.getBundle().adapt(FrameworkStartLevel.class);
        info.initialBundleStartLevel = fsl.getInitialBundleStartLevel();
        info.currentStartLevel = fsl.getStartLevel();
        info.bundles = new HashMap<Long, Bundle>();
        for (Bundle bundle : this.systemBundleContext.getBundles()) {
            info.bundles.put(bundle.getBundleId(), bundle);
        }
        info.systemBundle = info.bundles.get(0);
        return info;
    }
}

