/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.repository;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPInputStream;

public abstract class UrlLoader {
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String GZIP = "gzip";
    private final String url;
    private final long expiration;
    private long lastModified;
    private long lastChecked;

    public UrlLoader(String url, long expiration) {
        this.url = url;
        this.expiration = expiration;
    }

    public String getUrl() {
        return this.url;
    }

    protected boolean checkAndLoadCache() {
        long time = System.currentTimeMillis();
        if (this.lastChecked > 0L && (this.expiration < 0L || time - this.lastChecked < this.expiration)) {
            return false;
        }
        try {
            URL u = new URL(this.url);
            URLConnection connection = u.openConnection();
            if (connection instanceof HttpURLConnection) {
                int rc;
                HttpURLConnection con = (HttpURLConnection)connection;
                if (this.lastModified > 0L) {
                    con.setIfModifiedSince(this.lastModified);
                }
                con.setRequestProperty(HEADER_ACCEPT_ENCODING, GZIP);
                if (u.getUserInfo() != null) {
                    String encoded = Base64.getEncoder().encodeToString(u.getUserInfo().getBytes(StandardCharsets.UTF_8));
                    connection.setRequestProperty("Authorization", "Basic " + encoded);
                }
                if ((rc = con.getResponseCode()) == 304) {
                    this.lastChecked = time;
                    return false;
                }
                if (rc != 200) {
                    throw new IOException("Unexpected http response loading " + this.url + " : " + rc + " " + con.getResponseMessage());
                }
            }
            if (this.didNotChange(connection)) {
                this.lastChecked = time;
                return false;
            }
            boolean wasRead = this.read(connection);
            this.lastModified = connection.getLastModified();
            this.lastChecked = time;
            return wasRead;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean didNotChange(URLConnection connection) {
        long lm = connection.getLastModified();
        return lm > 0L && lm <= this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(URLConnection connection) throws IOException {
        try (FilterInputStream is = null;){
            is = new BufferedInputStream(connection.getInputStream());
            if (this.isGzipStream(is)) {
                is = new GZIPInputStream(is);
            }
            boolean bl = this.doRead(is);
            return bl;
        }
    }

    private boolean isGzipStream(InputStream is) throws IOException {
        is.mark(512);
        int b0 = is.read();
        int b1 = is.read();
        is.reset();
        return b0 == 31 && b1 == 139;
    }

    protected abstract boolean doRead(InputStream var1) throws IOException;
}

