/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.karaf.features.internal.model.Capability;
import org.apache.karaf.features.internal.model.Conditional;
import org.apache.karaf.features.internal.model.Config;
import org.apache.karaf.features.internal.model.Content;
import org.apache.karaf.features.internal.model.Library;
import org.apache.karaf.features.internal.model.Requirement;
import org.apache.karaf.features.internal.model.Scoping;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="feature", propOrder={"details", "config", "configfile", "feature", "bundle", "conditional", "capability", "requirement", "library", "scoping"})
public class Feature
extends Content
implements org.apache.karaf.features.Feature {
    public static final char VERSION_SEPARATOR = '/';
    public static final String DEFAULT_VERSION = "0.0.0";
    @XmlElement(name="details", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
    protected String details;
    @XmlAttribute(required=true)
    protected String name;
    @XmlTransient
    protected String version;
    @XmlAttribute
    protected String description;
    @XmlAttribute
    protected String resolver;
    @XmlAttribute
    protected String install;
    @XmlAttribute(name="start-level")
    protected Integer startLevel;
    @XmlAttribute
    protected Boolean hidden;
    @XmlElement(name="conditional", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
    protected List<Conditional> conditional;
    @XmlElement(name="capability", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
    protected List<Capability> capability;
    @XmlElement(name="requirement", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
    protected List<Requirement> requirement;
    @XmlElement(name="scoping", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
    protected Scoping scoping;
    @XmlElement(name="library", namespace="http://karaf.apache.org/xmlns/features/v1.5.0")
    protected List<Library> library;
    @XmlTransient
    protected String namespace;
    @XmlTransient
    protected List<String> resourceRepositories;
    @XmlTransient
    protected String repositoryUrl;

    public Feature() {
    }

    public Feature(String name) {
        this.name = name;
    }

    public Feature(String name, String version) {
        this.name = name;
        this.version = VersionCleaner.clean(version);
    }

    public static org.apache.karaf.features.Feature valueOf(String str) {
        int idx = str.indexOf(47);
        if (idx >= 0) {
            String strName = str.substring(0, idx);
            String strVersion = str.substring(idx + 1, str.length());
            return new Feature(strName, strVersion);
        }
        return new Feature(str);
    }

    @Override
    public String getId() {
        return this.getName() + '/' + this.getVersion();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            return DEFAULT_VERSION;
        }
        return this.version;
    }

    @XmlAttribute
    public void setVersion(String value) {
        this.version = VersionCleaner.clean(value);
    }

    @Override
    public boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    @Override
    public String getResolver() {
        return this.resolver;
    }

    @Override
    public String getInstall() {
        return this.install;
    }

    public void setInstall(String install) {
        this.install = install;
    }

    public void setResolver(String value) {
        this.resolver = value;
    }

    @Override
    public int getStartLevel() {
        return this.startLevel == null ? 0 : this.startLevel;
    }

    public void setStartLevel(Integer value) {
        this.startLevel = value;
    }

    @Override
    public boolean isHidden() {
        return this.hidden == null ? false : this.hidden;
    }

    public void setHidden(Boolean value) {
        this.hidden = value;
    }

    public List<Conditional> getConditional() {
        if (this.conditional == null) {
            this.conditional = new ArrayList<Conditional>();
        }
        return this.conditional;
    }

    public List<Capability> getCapabilities() {
        if (this.capability == null) {
            this.capability = new ArrayList<Capability>();
        }
        return this.capability;
    }

    public List<Requirement> getRequirements() {
        if (this.requirement == null) {
            this.requirement = new ArrayList<Requirement>();
        }
        return this.requirement;
    }

    @Override
    public Scoping getScoping() {
        return this.scoping;
    }

    public void setScoping(Scoping scoping) {
        this.scoping = scoping;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        if (this.name != null ? !this.name.equals(feature.name) : feature.name != null) {
            return false;
        }
        return this.version != null ? this.version.equals(feature.version) : feature.version == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    protected void interpolation(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = properties.getProperty(key);
            Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(val);
            while (matcher.find()) {
                String rep = System.getProperty(matcher.group(1));
                if (rep == null) continue;
                val = val.replace(matcher.group(0), rep);
                matcher.reset(val);
            }
            properties.put(key, val);
        }
    }

    public List<Library> getLibraries() {
        if (this.library == null) {
            this.library = new ArrayList<Library>();
        }
        return this.library;
    }

    public void postUnmarshall() {
        if (this.conditional != null) {
            for (Conditional conditional : this.conditional) {
                conditional.setOwner(this);
            }
        }
        if (this.config != null) {
            for (Config config : this.config) {
                String v = config.getValue();
                v = Stream.of(v.split("\n")).map(String::trim).collect(Collectors.joining("\n", "", "\n"));
                config.setValue(v);
            }
        }
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public List<String> getResourceRepositories() {
        return this.resourceRepositories != null ? this.resourceRepositories : Collections.emptyList();
    }

    public void setResourceRepositories(List<String> resourceRepositories) {
        this.resourceRepositories = resourceRepositories;
    }

    @Override
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }
}

