/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.camel.util.ObjectHelper;

public final class CatalogComponentHelper {
    private CatalogComponentHelper() {
    }

    public static final class Table {
        private final List<TableColumn> columns;
        private final List<Map<String, String>> rows;

        public Table(String[] headers, String[] keys) {
            assert (headers.length == keys.length);
            this.columns = new LinkedList<TableColumn>();
            this.rows = new LinkedList<Map<String, String>>();
            for (int i = 0; i < headers.length; ++i) {
                this.columns.add(new TableColumn(headers[i], keys[i]));
            }
        }

        public boolean isEmpty() {
            return this.rows.isEmpty();
        }

        public void addRow(String name, Map<String, Object> row) {
            LinkedHashMap<String, String> rowData = null;
            for (TableColumn column : this.columns) {
                Object val = row.get(column.getKey());
                if (!ObjectHelper.isNotEmpty((Object)val)) continue;
                if (rowData == null) {
                    rowData = new LinkedHashMap<String, String>();
                }
                rowData.put(column.getKey(), val.toString());
            }
            if (rowData != null) {
                rowData.put("key", name);
                this.rows.add((Map<String, String>)rowData);
                for (TableColumn column : this.columns) {
                    column.computeMaxLen(rowData);
                }
            }
        }

        public void print(PrintStream out) {
            for (int r = 0; r < this.rows.size(); ++r) {
                if (r == 0) {
                    this.printHeader(out);
                }
                Map<String, String> row = this.rows.get(r);
                for (int c = 0; c < this.columns.size(); ++c) {
                    this.columns.get(c).printValue(out, row, c == this.columns.size() - 1);
                }
            }
        }

        private void printHeader(PrintStream out) {
            TableColumn column;
            int c;
            for (c = 0; c < this.columns.size(); ++c) {
                column = this.columns.get(c);
                column.printHeader(out, c == this.columns.size() - 1);
            }
            for (c = 0; c < this.columns.size(); ++c) {
                column = this.columns.get(c);
                column.printHeaderSeparator(out, c == this.columns.size() - 1);
            }
        }
    }

    public static final class TableColumn {
        private final String header;
        private final String key;
        private int maxLen;
        private String formatString;

        public TableColumn(String header, String key) {
            this.header = header;
            this.key = key;
            this.maxLen = header.length();
            this.formatString = null;
        }

        public String getHeader() {
            return this.header;
        }

        public String getKey() {
            return this.key;
        }

        public int getMaxLen() {
            return this.maxLen;
        }

        public void computeMaxLen(Map<String, String> row) {
            String val = row.get(this.key);
            if (val != null) {
                this.maxLen = Math.max(this.maxLen, val.length());
            }
        }

        private String headerSeparator() {
            StringBuilder sb = new StringBuilder(this.header.length());
            while (sb.length() < this.header.length()) {
                sb.append('-');
            }
            return sb.toString();
        }

        private String formatString() {
            if (this.formatString == null) {
                this.formatString = "%-" + this.maxLen + '.' + this.maxLen + 's';
            }
            return this.formatString;
        }

        public void printHeader(PrintStream out, boolean newLine) {
            String outStr = String.format(this.formatString(), this.header);
            if (newLine) {
                out.println(outStr.trim());
            } else {
                out.print(outStr);
                out.print(' ');
            }
        }

        public void printHeaderSeparator(PrintStream out, boolean newLine) {
            String outStr = String.format(this.formatString(), this.headerSeparator());
            if (newLine) {
                out.println(outStr.trim());
            } else {
                out.print(outStr);
                out.print(' ');
            }
        }

        public void printValue(PrintStream out, Map<String, String> row, boolean newLine) {
            String val = row.get(this.key);
            if (val == null) {
                val = "";
            }
            String outStr = String.format(this.formatString(), val);
            if (newLine) {
                out.println(outStr.trim());
            } else {
                out.print(outStr);
                out.print(' ');
            }
        }
    }
}

