/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.support.internal;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;

public class OsgiBundleScope
implements Scope,
DisposableBean {
    public static final String SCOPE_NAME = "bundle";
    private static final Log log = LogFactory.getLog((Class)OsgiBundleScope.class);
    public static final ThreadLocal EXTERNAL_BUNDLE = new ThreadLocal();
    private final Map localBeans = new LinkedHashMap(4);
    private final Map destructionCallbacks = new LinkedHashMap(8);

    private boolean isExternalBundleCalling() {
        return EXTERNAL_BUNDLE.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory objectFactory) {
        if (this.isExternalBundleCalling()) {
            Object bean = objectFactory.getObject();
            return bean;
        }
        Map map2 = this.localBeans;
        synchronized (map2) {
            Object bean = this.localBeans.get(name);
            if (bean == null) {
                bean = objectFactory.getObject();
                this.localBeans.put(name, bean);
            }
            return bean;
        }
    }

    public String getConversationId() {
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback2) {
        if (this.isExternalBundleCalling()) {
            EXTERNAL_BUNDLE.set(callback2);
        } else {
            this.destructionCallbacks.put(name, callback2);
        }
    }

    public Object remove(String name) {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
        boolean debug = log.isDebugEnabled();
        Iterator iter = this.destructionCallbacks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Runnable callback2 = (Runnable)entry.getValue();
            if (debug) {
                log.debug((Object)("destroying local bundle scoped bean [" + entry.getKey() + "]"));
            }
            callback2.run();
        }
        this.destructionCallbacks.clear();
        this.localBeans.clear();
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public static class BundleScopeServiceFactory
    implements ServiceFactory {
        private ServiceFactory decoratedServiceFactory;
        private final Map callbacks = CollectionFactory.createConcurrentMap((int)4);

        public BundleScopeServiceFactory(ServiceFactory serviceFactory) {
            Assert.notNull((Object)serviceFactory);
            this.decoratedServiceFactory = serviceFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getService(Bundle bundle, ServiceRegistration registration) {
            try {
                Runnable callback2;
                EXTERNAL_BUNDLE.set(Boolean.TRUE);
                Object obj = this.decoratedServiceFactory.getService(bundle, registration);
                Object passedObject = EXTERNAL_BUNDLE.get();
                if (passedObject != null && passedObject instanceof Runnable && (callback2 = (Runnable)EXTERNAL_BUNDLE.get()) != null) {
                    this.callbacks.put(bundle, callback2);
                }
                Object object = obj;
                return object;
            }
            finally {
                EXTERNAL_BUNDLE.set(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            try {
                EXTERNAL_BUNDLE.set(Boolean.TRUE);
                this.decoratedServiceFactory.ungetService(bundle, registration, service);
                Runnable callback2 = (Runnable)this.callbacks.remove(bundle);
                if (callback2 != null) {
                    callback2.run();
                }
            }
            finally {
                EXTERNAL_BUNDLE.set(null);
            }
        }
    }
}

