/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.activemq.jaas.EncryptionSupport;
import org.apache.activemq.jaas.PropertiesLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadableProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadableProperties.class);
    private Properties props = new Properties();
    private Map<String, String> invertedProps;
    private Map<String, Set<String>> invertedValueProps;
    private long reloadTime = -1L;
    private final PropertiesLoader.FileNameKey key;

    public ReloadableProperties(PropertiesLoader.FileNameKey key) {
        this.key = key;
    }

    public synchronized Properties getProps() {
        return this.props;
    }

    public synchronized ReloadableProperties obtained() {
        if (this.reloadTime < 0L || this.key.isReload() && this.hasModificationAfter(this.reloadTime)) {
            block4: {
                this.props = new Properties();
                try {
                    this.load(this.key.file(), this.props);
                    this.invertedProps = null;
                    this.invertedValueProps = null;
                    if (this.key.isDebug()) {
                        LOG.debug("Load of: " + this.key);
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to load: " + this.key + ", reason:" + e.getLocalizedMessage());
                    if (!this.key.isDebug()) break block4;
                    LOG.debug("Load of: " + this.key + ", failure exception" + e);
                }
            }
            this.reloadTime = System.currentTimeMillis();
        }
        return this;
    }

    public synchronized Map<String, String> invertedPropertiesMap() {
        if (this.invertedProps == null) {
            this.invertedProps = new HashMap<String, String>(this.props.size());
            for (Map.Entry<Object, Object> val : this.props.entrySet()) {
                this.invertedProps.put((String)val.getValue(), (String)val.getKey());
            }
        }
        return this.invertedProps;
    }

    public synchronized Map<String, Set<String>> invertedPropertiesValuesMap() {
        if (this.invertedValueProps == null) {
            this.invertedValueProps = new HashMap<String, Set<String>>(this.props.size());
            for (Map.Entry<Object, Object> val : this.props.entrySet()) {
                String[] userList;
                for (String user : userList = ((String)val.getValue()).split(",")) {
                    Set<String> set2 = this.invertedValueProps.get(user);
                    if (set2 == null) {
                        set2 = new HashSet<String>();
                        this.invertedValueProps.put(user, set2);
                    }
                    set2.add((String)val.getKey());
                }
            }
        }
        return this.invertedValueProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File source, Properties props) throws IOException {
        try (FileInputStream in = new FileInputStream(source);){
            props.load(in);
            if (this.key.isDecrypt()) {
                try {
                    EncryptionSupport.decrypt(this.props);
                }
                catch (NoClassDefFoundError e) {
                    this.key.setDecrypt(false);
                    LOG.info("jasypt is not on the classpath: password decryption disabled.");
                }
            }
        }
    }

    private boolean hasModificationAfter(long reloadTime) {
        return this.key.file.lastModified() > reloadTime;
    }
}

