/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management;

import java.security.Principal;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;

public class JaasAuthenticator
implements JMXAuthenticator {
    private String realm;

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    @Override
    public Subject authenticate(Object credentials) throws SecurityException {
        if (!(credentials instanceof String[])) {
            throw new IllegalArgumentException("Expected String[2], got " + (credentials != null ? credentials.getClass().getName() : null));
        }
        String[] params = (String[])credentials;
        if (params.length != 2) {
            throw new IllegalArgumentException("Expected String[2] but length was " + params.length);
        }
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, callbacks -> {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName(params[0]);
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(params[1].toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            });
            loginContext.login();
            int roleCount = 0;
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof RolePrincipal)) continue;
                ++roleCount;
            }
            if (roleCount == 0) {
                throw new FailedLoginException("User doesn't have role defined");
            }
            return subject;
        }
        catch (LoginException e) {
            throw new SecurityException("Authentication failed", e);
        }
    }
}

