/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.apache.karaf.shell.api.console.Signal;
import org.apache.karaf.shell.api.console.SignalListener;
import org.apache.karaf.shell.api.console.Terminal;
import org.jline.terminal.Attributes;
import org.jline.terminal.Cursor;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;
import org.jline.utils.NonBlockingReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JLineTerminal
implements Terminal,
org.jline.terminal.Terminal {
    private final org.jline.terminal.Terminal terminal;
    private final ConcurrentMap<Terminal.Signal, Set<SignalListener>> listeners = new ConcurrentHashMap<Terminal.Signal, Set<SignalListener>>();
    private final ConcurrentMap<Terminal.Signal, Terminal.SignalHandler> handlers = new ConcurrentHashMap<Terminal.Signal, Terminal.SignalHandler>();
    private static final Logger LOGGER = LoggerFactory.getLogger(JLineTerminal.class);

    public JLineTerminal(org.jline.terminal.Terminal terminal) {
        this.terminal = terminal;
        for (Terminal.Signal signal : Terminal.Signal.values()) {
            terminal.handle(signal, this::handle);
            this.handlers.put(signal, Terminal.SignalHandler.SIG_DFL);
        }
    }

    @Override
    public String getType() {
        return this.terminal.getType();
    }

    public boolean puts(InfoCmp.Capability capability, Object ... params) {
        return this.terminal.puts(capability, params);
    }

    public boolean getBooleanCapability(InfoCmp.Capability capability) {
        return this.terminal.getBooleanCapability(capability);
    }

    public Integer getNumericCapability(InfoCmp.Capability capability) {
        return this.terminal.getNumericCapability(capability);
    }

    public String getStringCapability(InfoCmp.Capability capability) {
        return this.terminal.getStringCapability(capability);
    }

    @Override
    public int getWidth() {
        return this.terminal.getWidth();
    }

    @Override
    public int getHeight() {
        return this.terminal.getHeight();
    }

    public void flush() {
        this.terminal.flush();
    }

    @Override
    public boolean isAnsiSupported() {
        return true;
    }

    @Override
    public boolean isEchoEnabled() {
        return this.terminal.echo();
    }

    @Override
    public void setEchoEnabled(boolean enabled) {
        this.terminal.echo(enabled);
    }

    public void close() throws IOException {
        this.terminal.close();
    }

    public String getName() {
        return this.terminal.getName();
    }

    public NonBlockingReader reader() {
        return this.terminal.reader();
    }

    public PrintWriter writer() {
        return this.terminal.writer();
    }

    public Charset encoding() {
        return this.terminal.encoding();
    }

    public InputStream input() {
        return this.terminal.input();
    }

    public OutputStream output() {
        return this.terminal.output();
    }

    public Attributes enterRawMode() {
        return this.terminal.enterRawMode();
    }

    public boolean echo() {
        return this.terminal.echo();
    }

    public boolean echo(boolean echo) {
        return this.terminal.echo(echo);
    }

    public Attributes getAttributes() {
        return this.terminal.getAttributes();
    }

    public void setAttributes(Attributes attr) {
        this.terminal.setAttributes(attr);
    }

    public Size getSize() {
        return this.terminal.getSize();
    }

    public void setSize(Size size) {
        this.terminal.setSize(size);
    }

    public void raise(Terminal.Signal signal) {
        this.terminal.raise(signal);
    }

    public Terminal.SignalHandler handle(Terminal.Signal signal, Terminal.SignalHandler handler) {
        Objects.requireNonNull(signal);
        Objects.requireNonNull(handler);
        return this.handlers.put(signal, handler);
    }

    @Override
    public void addSignalListener(SignalListener listener) {
        this.addSignalListener(listener, EnumSet.allOf(Signal.class));
    }

    @Override
    public void addSignalListener(SignalListener listener, Signal ... signals) {
        for (Signal sig : signals) {
            this.addSignalListener(listener, sig);
        }
    }

    @Override
    public void addSignalListener(SignalListener listener, EnumSet<Signal> signals) {
        for (Signal sig : signals) {
            this.addSignalListener(listener, sig);
        }
    }

    private void addSignalListener(SignalListener listener, Signal signal) {
        Set ls = this.listeners.compute(this.signal(signal), (s, l) -> l != null ? l : new CopyOnWriteArraySet());
        ls.add(listener);
    }

    @Override
    public void removeSignalListener(SignalListener listener) {
        for (Terminal.Signal signal : Terminal.Signal.values()) {
            Set ls = (Set)this.listeners.get(signal);
            if (ls == null) continue;
            ls.remove(listener);
        }
    }

    public Cursor getCursorPosition(IntConsumer discarded) {
        return this.terminal.getCursorPosition(discarded);
    }

    public boolean hasMouseSupport() {
        return this.terminal.hasMouseSupport();
    }

    public boolean trackMouse(Terminal.MouseTracking tracking) {
        return this.terminal.trackMouse(tracking);
    }

    public MouseEvent readMouseEvent() {
        return this.terminal.readMouseEvent();
    }

    public MouseEvent readMouseEvent(IntSupplier supplier) {
        return this.terminal.readMouseEvent(supplier);
    }

    private Terminal.Signal signal(Signal sig) {
        switch (sig) {
            case INT: {
                return Terminal.Signal.INT;
            }
            case QUIT: {
                return Terminal.Signal.QUIT;
            }
            case TSTP: {
                return Terminal.Signal.TSTP;
            }
            case CONT: {
                return Terminal.Signal.CONT;
            }
            case WINCH: {
                return Terminal.Signal.WINCH;
            }
        }
        throw new UnsupportedOperationException();
    }

    private Signal signal(Terminal.Signal sig) {
        switch (sig) {
            case INT: {
                return Signal.INT;
            }
            case QUIT: {
                return Signal.QUIT;
            }
            case TSTP: {
                return Signal.TSTP;
            }
            case CONT: {
                return Signal.CONT;
            }
            case WINCH: {
                return Signal.WINCH;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected void handle(Terminal.Signal signal) {
        Set sl;
        Terminal.SignalHandler handler = (Terminal.SignalHandler)this.handlers.get(signal);
        if (handler != Terminal.SignalHandler.SIG_DFL && handler != Terminal.SignalHandler.SIG_IGN) {
            try {
                handler.handle(signal);
            }
            catch (UnsupportedOperationException uoe) {
                LOGGER.debug("unsupported operation", (Throwable)uoe);
            }
        }
        if ((sl = (Set)this.listeners.get(signal)) != null) {
            for (SignalListener l : sl) {
                l.signal(this.signal(signal));
            }
        }
    }
}

