/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh.keygenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.ssl.PKCS8Key;
import org.apache.karaf.shell.ssh.keygenerator.OpenSSHKeyPairGenerator;
import org.apache.karaf.shell.ssh.keygenerator.PemWriter;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSSHKeyPairProvider
extends AbstractKeyPairProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSSHKeyPairProvider.class);
    private File keyFile;
    private String password;
    private KeyPair cachedKey;
    private String algorithm;
    private int keySize;

    public OpenSSHKeyPairProvider(File keyFile, String algorithm, int keySize) {
        this.keyFile = keyFile;
        this.algorithm = algorithm;
        this.keySize = keySize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Iterable<KeyPair> loadKeys() {
        if (this.cachedKey != null) {
            return Collections.singleton(this.cachedKey);
        }
        if (!this.keyFile.exists()) {
            this.createServerKey();
        }
        try (FileInputStream is = new FileInputStream(this.keyFile);){
            KeyPair kp;
            this.cachedKey = kp = this.getKeyPair(is);
            Set<KeyPair> set = Collections.singleton(kp);
            return set;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KeyPair getKeyPair(FileInputStream is) throws GeneralSecurityException, IOException {
        PKCS8Key pkcs8 = new PKCS8Key((InputStream)is, this.password == null ? null : this.password.toCharArray());
        KeyPair kp = new KeyPair(pkcs8.getPublicKey(), pkcs8.getPrivateKey());
        return kp;
    }

    private void createServerKey() {
        try {
            LOGGER.info("Creating ssh server key at " + this.keyFile);
            KeyPair kp = new OpenSSHKeyPairGenerator(this.algorithm, this.keySize).generate();
            new PemWriter(this.keyFile).writeKeyPair(this.algorithm, kp);
        }
        catch (Exception e) {
            throw new RuntimeException("Key file generation failed", e);
        }
    }
}

