/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ConstantTypeBeanHolder;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.language.bean.RuntimeBeanExpressionException;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.StringHelper;

public class BeanExpression
implements Expression,
Predicate {
    private final Object bean;
    private final String beanName;
    private final Class<?> type;
    private final String method;
    private volatile BeanHolder beanHolder;

    public BeanExpression(Object bean, String method) {
        this.bean = bean;
        this.method = method;
        this.beanName = null;
        this.type = null;
    }

    public BeanExpression(String beanName, String method) {
        this.beanName = beanName;
        this.method = method;
        this.bean = null;
        this.type = null;
    }

    public BeanExpression(Class<?> type, String method) {
        this.type = type;
        this.method = method;
        this.bean = null;
        this.beanName = null;
    }

    public BeanExpression(BeanHolder beanHolder, String method) {
        this.beanHolder = beanHolder;
        this.method = method;
        this.bean = null;
        this.beanName = null;
        this.type = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BeanExpression[");
        if (this.bean != null) {
            sb.append(this.bean.toString());
        } else if (this.beanName != null) {
            sb.append(this.beanName);
        } else if (this.type != null) {
            sb.append(ObjectHelper.className(this.type));
        }
        if (this.method != null) {
            sb.append(" method:").append(this.method);
        }
        sb.append("]");
        return sb.toString();
    }

    public Object evaluate(Exchange exchange) {
        if (this.beanHolder == null) {
            this.beanHolder = this.createBeanHolder(exchange.getContext());
        }
        if (OgnlHelper.isInvalidValidOgnlExpression(this.method)) {
            ExpressionIllegalSyntaxException cause = new ExpressionIllegalSyntaxException(this.method);
            throw new RuntimeBeanExpressionException(exchange, this.beanName, this.method, cause);
        }
        if (OgnlHelper.isValidOgnlExpression(this.method)) {
            OgnlInvokeProcessor ognl = new OgnlInvokeProcessor(this.beanHolder, this.method);
            try {
                ognl.process(exchange);
                return ognl.getResult();
            }
            catch (Exception e) {
                if (e instanceof RuntimeBeanExpressionException) {
                    throw (RuntimeBeanExpressionException)e;
                }
                throw new RuntimeBeanExpressionException(exchange, BeanExpression.getBeanName(this.beanName, this.beanHolder), this.method, e);
            }
        }
        InvokeProcessor invoke = new InvokeProcessor(this.beanHolder, this.method);
        try {
            invoke.process(exchange);
            return invoke.getResult();
        }
        catch (Exception e) {
            if (e instanceof RuntimeBeanExpressionException) {
                throw (RuntimeBeanExpressionException)e;
            }
            throw new RuntimeBeanExpressionException(exchange, BeanExpression.getBeanName(this.beanName, this.beanHolder), this.method, e);
        }
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        Object result = this.evaluate(exchange);
        if (Object.class == type) {
            return (T)result;
        }
        return exchange.getContext().getTypeConverter().convertTo(type, exchange, result);
    }

    @Override
    public boolean matches(Exchange exchange) {
        Object value = this.evaluate(exchange);
        return ObjectHelper.evaluateValuePredicate(value);
    }

    private synchronized BeanHolder createBeanHolder(CamelContext context) {
        BeanHolder holder;
        if (this.bean != null) {
            holder = new ConstantBeanHolder(this.bean, context);
        } else if (this.beanName != null) {
            holder = new RegistryBean(context, this.beanName);
        } else if (this.type != null) {
            holder = new ConstantTypeBeanHolder(this.type, context);
        } else {
            throw new IllegalArgumentException("Either bean, beanName or type should be set on " + this);
        }
        return holder;
    }

    private static String getBeanName(String beanName, BeanHolder beanHolder) {
        String name = beanName;
        if (name == null && beanHolder != null && beanHolder.getBean() != null) {
            name = beanHolder.getBean().getClass().getCanonicalName();
        }
        if (name == null && beanHolder != null && beanHolder.getBeanInfo() != null && beanHolder.getBeanInfo().getType() != null) {
            name = beanHolder.getBeanInfo().getType().getCanonicalName();
        }
        return name;
    }

    private final class OgnlInvokeProcessor
    implements Processor {
        private final String ognl;
        private final BeanHolder beanHolder;
        private Object result;

        OgnlInvokeProcessor(BeanHolder beanHolder, String ognl) {
            this.beanHolder = beanHolder;
            this.ognl = ognl;
            this.result = beanHolder.getBean();
        }

        @Override
        public void process(Exchange exchange) throws Exception {
            Exchange resultExchange = exchange.copy();
            resultExchange.setException(null);
            resultExchange.setPattern(ExchangePattern.InOut);
            resultExchange.getIn().removeHeader("CamelBeanMethodName");
            String ognlPath = "";
            Object beanToCall = this.beanHolder.getBean();
            Class<?> beanType = this.beanHolder.getBeanInfo().getType();
            if (beanToCall == null && beanType == null) {
                throw new IllegalArgumentException("Bean instance and bean type is null. OGNL bean expressions requires to have either a bean instance of the class name of the bean to use.");
            }
            if (this.ognl != null) {
                OgnlHelper.validateMethodName(this.ognl);
            }
            List<String> methods = OgnlHelper.splitOgnl(this.ognl);
            for (String methodName : methods) {
                BeanHolder holder = beanToCall != null ? new ConstantBeanHolder(beanToCall, exchange.getContext()) : (beanType != null ? new ConstantTypeBeanHolder(beanType, exchange.getContext()) : null);
                boolean nullSafe = OgnlHelper.isNullSafeOperator(methodName);
                if (holder == null) {
                    String name = BeanExpression.getBeanName(null, this.beanHolder);
                    throw new RuntimeBeanExpressionException(exchange, name, this.ognl, "last method returned null and therefore cannot continue to invoke method " + methodName + " on a null instance");
                }
                ognlPath = ognlPath + methodName;
                methodName = OgnlHelper.removeLeadingOperators(methodName);
                String key = null;
                KeyValueHolder<String, String> index = OgnlHelper.isOgnlIndex(methodName);
                if (index != null) {
                    methodName = index.getKey();
                    key = index.getValue();
                }
                if (methodName != null) {
                    InvokeProcessor invoke = new InvokeProcessor(holder, methodName);
                    invoke.process(resultExchange);
                    if (resultExchange.getException() != null) {
                        throw new RuntimeBeanExpressionException(exchange, BeanExpression.this.beanName, methodName, resultExchange.getException());
                    }
                    this.result = invoke.getResult();
                }
                if (key != null) {
                    this.result = this.lookupResult(resultExchange, key, this.result, nullSafe, ognlPath, holder.getBean());
                }
                if (this.result == null && nullSafe) {
                    return;
                }
                beanToCall = this.result;
                beanType = null;
            }
        }

        private Object lookupResult(Exchange exchange, String key, Object result, boolean nullSafe, String ognlPath, Object bean) {
            List list;
            boolean checkList;
            ObjectHelper.notEmpty(key, "key", "in Simple language ognl path: " + ognlPath);
            key = key.trim();
            key = StringHelper.removeLeadingAndEndingQuotes(key);
            Map map = exchange.getContext().getTypeConverter().convertTo(Map.class, result);
            if (map != null) {
                return map.get(key);
            }
            Integer num = exchange.getContext().getTypeConverter().tryConvertTo(Integer.class, key);
            boolean bl = checkList = key.startsWith("last") || num != null;
            if (checkList && (list = exchange.getContext().getTypeConverter().convertTo(List.class, result)) != null) {
                if (key.startsWith("last")) {
                    num = list.size() - 1;
                    String after = ObjectHelper.after(key, "-");
                    if (after != null) {
                        Integer redux = exchange.getContext().getTypeConverter().tryConvertTo(Integer.class, after.trim());
                        if (redux != null) {
                            num = num - redux;
                        } else {
                            throw new ExpressionIllegalSyntaxException(key);
                        }
                    }
                }
                if (num != null && num >= 0 && list.size() > num - 1 && list.size() > 0) {
                    return list.get(num);
                }
                if (!nullSafe) {
                    throw new IndexOutOfBoundsException("Index: " + num + ", Size: " + list.size() + " out of bounds with List from bean: " + bean + "using OGNL path [" + ognlPath + "]");
                }
            }
            if (!nullSafe) {
                throw new IndexOutOfBoundsException("Key: " + key + " not found in bean: " + bean + " of type: " + ObjectHelper.classCanonicalName(bean) + " using OGNL path [" + ognlPath + "]");
            }
            return null;
        }

        public Object getResult() {
            return this.result;
        }
    }

    private final class InvokeProcessor
    implements Processor {
        private BeanHolder beanHolder;
        private String methodName;
        private Object result;

        private InvokeProcessor(BeanHolder beanHolder, String methodName) {
            this.beanHolder = beanHolder;
            this.methodName = methodName;
        }

        @Override
        public void process(Exchange exchange) throws Exception {
            BeanProcessor processor = new BeanProcessor(this.beanHolder);
            if (this.methodName != null) {
                processor.setMethod(this.methodName);
                processor.setShorthandMethod(true);
            }
            try {
                Exchange resultExchange = exchange.copy();
                resultExchange.setException(null);
                resultExchange.setPattern(ExchangePattern.InOut);
                processor.process(resultExchange);
                this.result = resultExchange.getOut().getBody();
                if (resultExchange.hasProperties()) {
                    exchange.getProperties().putAll(resultExchange.getProperties());
                }
                if (resultExchange.getOut().hasHeaders()) {
                    exchange.getIn().getHeaders().putAll(resultExchange.getOut().getHeaders());
                }
                if (resultExchange.getException() != null) {
                    exchange.setException(resultExchange.getException());
                }
            }
            catch (Exception e) {
                throw new RuntimeBeanExpressionException(exchange, BeanExpression.this.beanName, this.methodName, e);
            }
        }

        public Object getResult() {
            return this.result;
        }
    }
}

