/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvokeOnHeader;
import org.apache.camel.InvokeOnHeaders;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.Processor;
import org.apache.camel.impl.BaseSelectorProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderSelectorProducer
extends BaseSelectorProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderSelectorProducer.class);
    private final String header;
    private final String defaultHeaderValue;
    private final Object target;
    private Map<String, Processor> handlers;

    public HeaderSelectorProducer(Endpoint endpoint, String header) {
        this(endpoint, header, null, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, Object target) {
        this(endpoint, header, null, target);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, String defaultHeaderValue) {
        this(endpoint, header, defaultHeaderValue, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, String defaultHeaderValue, Object target) {
        super(endpoint);
        this.header = header;
        this.defaultHeaderValue = defaultHeaderValue;
        this.target = target != null ? target : this;
        this.handlers = new HashMap<String, Processor>();
    }

    @Override
    protected void doStart() throws Exception {
        for (Method method : this.target.getClass().getDeclaredMethods()) {
            InvokeOnHeaders annotation = method.getAnnotation(InvokeOnHeaders.class);
            if (annotation != null) {
                for (InvokeOnHeader processor : annotation.value()) {
                    this.bind(processor, method);
                }
                continue;
            }
            this.bind(method.getAnnotation(InvokeOnHeader.class), method);
        }
        this.handlers = Collections.unmodifiableMap(this.handlers);
        super.doStart();
    }

    @Override
    protected Processor getProcessor(Exchange exchange) throws Exception {
        String action = exchange.getIn().getHeader(this.header, this.defaultHeaderValue, String.class);
        if (action == null) {
            throw new NoSuchHeaderException(exchange, this.header, String.class);
        }
        return this.handlers.get(action);
    }

    @Override
    protected void onMissingProcessor(Exchange exchange) throws Exception {
        throw new IllegalStateException("Unsupported operation " + exchange.getIn().getHeader(this.header));
    }

    protected final void bind(String key, Processor processor) {
        if (this.handlers.containsKey(key)) {
            LOGGER.warn("A processor is already set for action {}", (Object)key);
        }
        this.handlers.put(key, processor);
    }

    private void bind(InvokeOnHeader handler, Method method) {
        if (handler != null && method.getParameterCount() == 1) {
            method.setAccessible(true);
            Class<?> type = method.getParameterTypes()[0];
            LOGGER.debug("bind key={}, class={}, method={}, type={}", new Object[]{handler.value(), this.getClass(), method.getName(), type});
            if (Message.class.isAssignableFrom(type)) {
                this.bind(handler.value(), (Exchange e) -> method.invoke(this.target, e.getIn()));
            } else {
                this.bind(handler.value(), (Exchange e) -> method.invoke(this.target, e));
            }
        }
    }
}

