/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.Endpoint;
import org.apache.camel.component.properties.AugmentedPropertyNameAwarePropertiesParser;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.DefaultPropertiesResolver;
import org.apache.camel.component.properties.EnvPropertiesFunction;
import org.apache.camel.component.properties.PropertiesEndpoint;
import org.apache.camel.component.properties.PropertiesFunction;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.component.properties.ServiceHostPropertiesFunction;
import org.apache.camel.component.properties.ServicePortPropertiesFunction;
import org.apache.camel.component.properties.ServicePropertiesFunction;
import org.apache.camel.component.properties.SysPropertiesFunction;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.FilePathResolver;
import org.apache.camel.util.LRUSoftCache;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesComponent
extends UriEndpointComponent {
    public static final String DEFAULT_PREFIX_TOKEN = "{{";
    public static final String DEFAULT_SUFFIX_TOKEN = "}}";
    @Deprecated
    public static final String PREFIX_TOKEN = "{{";
    @Deprecated
    public static final String SUFFIX_TOKEN = "}}";
    public static final int SYSTEM_PROPERTIES_MODE_NEVER = 0;
    public static final int SYSTEM_PROPERTIES_MODE_FALLBACK = 1;
    public static final int SYSTEM_PROPERTIES_MODE_OVERRIDE = 2;
    public static final String OVERRIDE_PROPERTIES = PropertiesComponent.class.getName() + ".OverrideProperties";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesComponent.class);
    private final Map<CacheKey, Properties> cacheMap = new LRUSoftCache<CacheKey, Properties>(1000);
    private final Map<String, PropertiesFunction> functions = new HashMap<String, PropertiesFunction>();
    private PropertiesResolver propertiesResolver = new DefaultPropertiesResolver(this);
    private PropertiesParser propertiesParser = new DefaultPropertiesParser(this);
    private boolean isDefaultCreated;
    private String[] locations;
    private boolean ignoreMissingLocation;
    private String encoding;
    private boolean cache = true;
    private String propertyPrefix;
    private String propertyPrefixResolved;
    private String propertySuffix;
    private String propertySuffixResolved;
    private boolean fallbackToUnaugmentedProperty = true;
    private String prefixToken = "{{";
    private String suffixToken = "}}";
    private Properties initialProperties;
    private Properties overrideProperties;
    private int systemPropertiesMode = 2;

    public PropertiesComponent() {
        super(PropertiesEndpoint.class);
        this.addFunction(new EnvPropertiesFunction());
        this.addFunction(new SysPropertiesFunction());
        this.addFunction(new ServicePropertiesFunction());
        this.addFunction(new ServiceHostPropertiesFunction());
        this.addFunction(new ServicePortPropertiesFunction());
    }

    public PropertiesComponent(boolean isDefaultCreated) {
        this();
        this.isDefaultCreated = isDefaultCreated;
    }

    public PropertiesComponent(String location) {
        this();
        this.setLocation(location);
    }

    public PropertiesComponent(String ... locations) {
        this();
        this.setLocations(locations);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] paths = this.locations;
        String locations = this.getAndRemoveParameter(parameters, "locations", String.class);
        Boolean ignoreMissingLocationLoc = this.getAndRemoveParameter(parameters, "ignoreMissingLocation", Boolean.class);
        if (locations != null) {
            LOG.trace("Overriding default locations with location: {}", (Object)locations);
            paths = locations.split(",");
        }
        if (ignoreMissingLocationLoc != null) {
            this.ignoreMissingLocation = ignoreMissingLocationLoc;
        }
        String endpointUri = this.parseUri(remaining, paths);
        LOG.debug("Endpoint uri parsed as: {}", (Object)endpointUri);
        Endpoint delegate = this.getCamelContext().getEndpoint(endpointUri);
        PropertiesEndpoint answer = new PropertiesEndpoint(uri, delegate, this);
        this.setProperties(answer, parameters);
        return answer;
    }

    public String parseUri(String uri) throws Exception {
        return this.parseUri(uri, this.locations);
    }

    public String parseUri(String uri, String ... paths) throws Exception {
        Properties prop = new Properties();
        if (null != this.initialProperties) {
            prop.putAll((Map<?, ?>)this.initialProperties);
        }
        if (paths != null) {
            Properties locationsProp;
            String[] locations = this.parseLocations(paths);
            CacheKey key = new CacheKey(locations);
            Properties properties = locationsProp = this.cache ? this.cacheMap.get(key) : null;
            if (locationsProp == null) {
                locationsProp = this.propertiesResolver.resolveProperties(this.getCamelContext(), this.ignoreMissingLocation, locations);
                if (this.cache) {
                    this.cacheMap.put(key, locationsProp);
                }
            }
            prop.putAll((Map<?, ?>)locationsProp);
        }
        if (this.overrideProperties != null) {
            Properties override = new Properties();
            override.putAll((Map<?, ?>)prop);
            override.putAll((Map<?, ?>)this.overrideProperties);
            prop = override;
        }
        if (!uri.contains(this.prefixToken) && !uri.startsWith(this.prefixToken)) {
            uri = this.prefixToken + uri;
        }
        if (!uri.contains(this.suffixToken) && !uri.endsWith(this.suffixToken)) {
            uri = uri + this.suffixToken;
        }
        LOG.trace("Parsing uri {} with properties: {}", (Object)uri, (Object)prop);
        if (this.propertiesParser instanceof AugmentedPropertyNameAwarePropertiesParser) {
            return ((AugmentedPropertyNameAwarePropertiesParser)this.propertiesParser).parseUri(uri, prop, this.prefixToken, this.suffixToken, this.propertyPrefixResolved, this.propertySuffixResolved, this.fallbackToUnaugmentedProperty);
        }
        return this.propertiesParser.parseUri(uri, prop, this.prefixToken, this.suffixToken);
    }

    public boolean isDefaultCreated() {
        return this.isDefaultCreated;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locations) {
        if (locations != null && locations.length > 0) {
            for (int i = 0; i < locations.length; ++i) {
                String loc = locations[i];
                locations[i] = loc.trim();
            }
        }
        this.locations = locations;
    }

    public void setLocation(String location) {
        if (location != null) {
            this.setLocations(location.split(","));
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public PropertiesResolver getPropertiesResolver() {
        return this.propertiesResolver;
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
    }

    public PropertiesParser getPropertiesParser() {
        return this.propertiesParser;
    }

    public void setPropertiesParser(PropertiesParser propertiesParser) {
        this.propertiesParser = propertiesParser;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
        this.propertyPrefixResolved = propertyPrefix;
        if (ObjectHelper.isNotEmpty(this.propertyPrefix)) {
            this.propertyPrefixResolved = FilePathResolver.resolvePath(this.propertyPrefix);
        }
    }

    public String getPropertySuffix() {
        return this.propertySuffix;
    }

    public void setPropertySuffix(String propertySuffix) {
        this.propertySuffix = propertySuffix;
        this.propertySuffixResolved = propertySuffix;
        if (ObjectHelper.isNotEmpty(this.propertySuffix)) {
            this.propertySuffixResolved = FilePathResolver.resolvePath(this.propertySuffix);
        }
    }

    public boolean isFallbackToUnaugmentedProperty() {
        return this.fallbackToUnaugmentedProperty;
    }

    public void setFallbackToUnaugmentedProperty(boolean fallbackToUnaugmentedProperty) {
        this.fallbackToUnaugmentedProperty = fallbackToUnaugmentedProperty;
    }

    public boolean isIgnoreMissingLocation() {
        return this.ignoreMissingLocation;
    }

    public void setIgnoreMissingLocation(boolean ignoreMissingLocation) {
        this.ignoreMissingLocation = ignoreMissingLocation;
    }

    public String getPrefixToken() {
        return this.prefixToken;
    }

    public void setPrefixToken(String prefixToken) {
        this.prefixToken = prefixToken == null ? "{{" : prefixToken;
    }

    public String getSuffixToken() {
        return this.suffixToken;
    }

    public void setSuffixToken(String suffixToken) {
        this.suffixToken = suffixToken == null ? "}}" : suffixToken;
    }

    public Properties getInitialProperties() {
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public Map<String, PropertiesFunction> getFunctions() {
        return this.functions;
    }

    public void addFunction(PropertiesFunction function) {
        this.functions.put(function.getName(), function);
    }

    public boolean hasFunction(String name) {
        return this.functions.containsKey(name);
    }

    public int getSystemPropertiesMode() {
        return this.systemPropertiesMode;
    }

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        this.systemPropertiesMode = systemPropertiesMode;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.systemPropertiesMode != 0 && this.systemPropertiesMode != 1 && this.systemPropertiesMode != 2) {
            throw new IllegalArgumentException("Option systemPropertiesMode has invalid value: " + this.systemPropertiesMode);
        }
        if (this.propertiesParser instanceof DefaultPropertiesParser) {
            ((DefaultPropertiesParser)this.propertiesParser).setPropertiesComponent(this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.cacheMap.clear();
        super.doStop();
    }

    private String[] parseLocations(String[] locations) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String location : locations) {
            LOG.trace("Parsing location: {} ", (Object)location);
            try {
                location = FilePathResolver.resolvePath(location);
                LOG.debug("Parsed location: {} ", (Object)location);
                if (!ObjectHelper.isNotEmpty(location)) continue;
                answer.add(location);
            }
            catch (IllegalArgumentException e) {
                if (!this.ignoreMissingLocation) {
                    throw e;
                }
                LOG.debug("Ignored missing location: {}", (Object)location);
            }
        }
        return answer.toArray(new String[answer.size()]);
    }

    private static final class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String[] locations;

        private CacheKey(String[] locations) {
            this.locations = locations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return Arrays.equals(this.locations, that.locations);
        }

        public int hashCode() {
            return this.locations != null ? Arrays.hashCode(this.locations) : 0;
        }

        public String toString() {
            return "LocationKey[" + Arrays.asList(this.locations).toString() + "]";
        }
    }
}

