/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.processor.ConvertBodyProcessor;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class DefaultFluentProducerTemplate
extends ServiceSupport
implements FluentProducerTemplate {
    private final CamelContext context;
    private final ClassValue<ConvertBodyProcessor> resultProcessors;
    private Map<String, Object> headers;
    private Object body;
    private Endpoint endpoint;
    private Consumer<ProducerTemplate> templateCustomizer;
    private Supplier<Exchange> exchangeSupplier;
    private Supplier<Processor> processorSupplier;
    private volatile ProducerTemplate template;
    private Endpoint defaultEndpoint;
    private int maximumCacheSize;
    private boolean eventNotifierEnabled = true;

    public DefaultFluentProducerTemplate(CamelContext context) {
        this.context = context;
        this.headers = null;
        this.body = null;
        this.endpoint = null;
        this.templateCustomizer = null;
        this.exchangeSupplier = null;
        this.processorSupplier = () -> this::populateExchange;
        this.template = null;
        this.resultProcessors = new ClassValue<ConvertBodyProcessor>(){

            @Override
            protected ConvertBodyProcessor computeValue(Class<?> type) {
                return new ConvertBodyProcessor(type);
            }
        };
    }

    @Override
    public CamelContext getCamelContext() {
        return this.context;
    }

    @Override
    public int getCurrentCacheSize() {
        if (this.template == null) {
            return 0;
        }
        return this.template.getCurrentCacheSize();
    }

    @Override
    public void cleanUp() {
        if (this.template != null) {
            this.template.cleanUp();
        }
    }

    @Override
    public void setDefaultEndpointUri(String endpointUri) {
        this.setDefaultEndpoint(this.getCamelContext().getEndpoint(endpointUri));
    }

    @Override
    public Endpoint getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    @Override
    public void setDefaultEndpoint(Endpoint defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    @Override
    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    @Override
    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    @Override
    public boolean isEventNotifierEnabled() {
        return this.eventNotifierEnabled;
    }

    @Override
    public void setEventNotifierEnabled(boolean eventNotifierEnabled) {
        this.eventNotifierEnabled = eventNotifierEnabled;
    }

    @Override
    public FluentProducerTemplate withHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(key, value);
        return this;
    }

    @Override
    public FluentProducerTemplate clearHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
        return this;
    }

    @Override
    public FluentProducerTemplate withBody(Object body) {
        this.body = body;
        return this;
    }

    @Override
    public FluentProducerTemplate withBodyAs(Object body, Class<?> type) {
        this.body = type != null ? this.context.getTypeConverter().convertTo(type, body) : body;
        return this;
    }

    @Override
    public FluentProducerTemplate clearBody() {
        this.body = null;
        return this;
    }

    @Override
    public FluentProducerTemplate withTemplateCustomizer(Consumer<ProducerTemplate> templateCustomizer) {
        this.templateCustomizer = templateCustomizer;
        return this;
    }

    @Override
    public FluentProducerTemplate withExchange(Exchange exchange) {
        return this.withExchange(() -> exchange);
    }

    @Override
    public FluentProducerTemplate withExchange(Supplier<Exchange> exchangeSupplier) {
        this.exchangeSupplier = exchangeSupplier;
        return this;
    }

    @Override
    public FluentProducerTemplate withProcessor(Processor processor) {
        return this.withProcessor(() -> processor);
    }

    @Override
    public FluentProducerTemplate withProcessor(Supplier<Processor> processorSupplier) {
        this.processorSupplier = processorSupplier;
        return this;
    }

    @Override
    public FluentProducerTemplate to(String endpointUri) {
        return this.to(this.context.getEndpoint(endpointUri));
    }

    @Override
    public FluentProducerTemplate to(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Override
    public Object request() throws CamelExecutionException {
        return this.request(Object.class);
    }

    @Override
    public <T> T request(Class<T> type) throws CamelExecutionException {
        Object result;
        Endpoint target;
        Endpoint endpoint = target = this.endpoint != null ? this.endpoint : this.defaultEndpoint;
        if (target == null) {
            throw new IllegalArgumentException("No endpoint configured on FluentProducerTemplate. You can configure an endpoint with to(uri)");
        }
        if (type == Exchange.class) {
            result = this.template().request(target, this.processorSupplier.get());
        } else if (type == Message.class) {
            Exchange exchange = this.template().request(target, this.processorSupplier.get());
            result = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        } else {
            Exchange exchange = this.template().send(target, ExchangePattern.InOut, this.processorSupplier.get(), this.resultProcessors.get(type));
            result = this.context.getTypeConverter().convertTo(type, ExchangeHelper.extractResultBody(exchange, exchange.getPattern()));
        }
        return (T)result;
    }

    @Override
    public Future<Object> asyncRequest() {
        return this.asyncRequest(Object.class);
    }

    @Override
    public <T> Future<T> asyncRequest(Class<T> type) {
        Endpoint target;
        Endpoint endpoint = target = this.endpoint != null ? this.endpoint : this.defaultEndpoint;
        if (target == null) {
            throw new IllegalArgumentException("No endpoint configured on FluentProducerTemplate. You can configure an endpoint with to(uri)");
        }
        CompletableFuture<T> result = this.headers != null ? this.template().asyncRequestBodyAndHeaders(target, this.body, this.headers, type) : this.template().asyncRequestBody(target, this.body, type);
        return result;
    }

    @Override
    public Exchange send() throws CamelExecutionException {
        Endpoint target;
        Endpoint endpoint = target = this.endpoint != null ? this.endpoint : this.defaultEndpoint;
        if (target == null) {
            throw new IllegalArgumentException("No endpoint configured on FluentProducerTemplate. You can configure an endpoint with to(uri)");
        }
        return this.exchangeSupplier != null ? this.template().send(target, this.exchangeSupplier.get()) : this.template().send(target, this.processorSupplier.get());
    }

    @Override
    public Future<Exchange> asyncSend() {
        Endpoint target;
        Endpoint endpoint = target = this.endpoint != null ? this.endpoint : this.defaultEndpoint;
        if (target == null) {
            throw new IllegalArgumentException("No endpoint configured on FluentProducerTemplate. You can configure an endpoint with to(uri)");
        }
        return this.exchangeSupplier != null ? this.template().asyncSend(target, this.exchangeSupplier.get()) : this.template().asyncSend(target, this.processorSupplier.get());
    }

    public static FluentProducerTemplate on(CamelContext context) {
        return new DefaultFluentProducerTemplate(context);
    }

    private ProducerTemplate template() {
        ObjectHelper.notNull(this.context, "CamelContext");
        if (this.template == null) {
            ProducerTemplate producerTemplate = this.template = this.maximumCacheSize > 0 ? this.context.createProducerTemplate(this.maximumCacheSize) : this.context.createProducerTemplate();
            if (this.defaultEndpoint != null) {
                this.template.setDefaultEndpoint(this.defaultEndpoint);
            }
            this.template.setEventNotifierEnabled(this.eventNotifierEnabled);
            if (this.templateCustomizer != null) {
                this.templateCustomizer.accept(this.template);
            }
        }
        return this.template;
    }

    private void populateExchange(Exchange exchange) throws Exception {
        if (this.headers != null && !this.headers.isEmpty()) {
            exchange.getIn().getHeaders().putAll(this.headers);
        }
        if (this.body != null) {
            exchange.getIn().setBody(this.body);
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.template == null) {
            this.template = this.template();
        }
        ServiceHelper.startService(this.template);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.template);
    }
}

