/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.utils.collections.DictionaryAsMap;
import org.apache.karaf.log.core.Level;
import org.apache.karaf.log.core.internal.LogServiceInternal;

public class LogServiceLog4j2Impl
implements LogServiceInternal {
    static final String ROOT_LOGGER_LEVEL = "log4j2.rootLogger.level";
    static final String LOGGER_PREFIX = "log4j2.logger.";
    static final String NAME_SUFFIX = ".name";
    static final String LEVEL_SUFFIX = ".level";
    private final Map<String, Object> config;
    private Pattern namePattern;
    private Pattern levelPattern;

    public LogServiceLog4j2Impl(Dictionary<String, Object> config) {
        this.config = new DictionaryAsMap<String, Object>(config);
        this.namePattern = Pattern.compile("log4j2\\.logger\\.([a-zA-Z_]+)\\.name");
        this.levelPattern = Pattern.compile("log4j2\\.logger\\.([a-zA-Z_]+)\\.level");
    }

    @Override
    public Map<String, String> getLevel(String logger) {
        TreeMap<String, String> loggers = new TreeMap<String, String>();
        String root = (String)this.config.get(ROOT_LOGGER_LEVEL);
        loggers.put("ROOT", root);
        if ("ROOT".equals(logger)) {
            return loggers;
        }
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, String> levels = new HashMap<String, String>();
        for (String string : this.config.keySet()) {
            String loggerName = this.getMatching(this.namePattern, string);
            if (loggerName != null) {
                names.put(loggerName, this.config.get(string).toString());
            }
            if ((loggerName = this.getMatching(this.levelPattern, string)) == null) continue;
            levels.put(loggerName, this.config.get(string).toString());
        }
        for (Map.Entry entry : names.entrySet()) {
            loggers.put((String)entry.getValue(), (String)levels.get(entry.getKey()));
        }
        if ("ALL".equalsIgnoreCase(logger)) {
            return loggers;
        }
        String l = logger;
        String string;
        while ((string = (String)loggers.get(l != null ? l : "ROOT")) == null && l != null) {
            int idx = l.lastIndexOf(46);
            if (idx < 0) {
                l = null;
                continue;
            }
            l = l.substring(0, idx);
        }
        return Collections.singletonMap(logger, string);
    }

    private String getMatching(Pattern pattern, String key) {
        Matcher matcher = pattern.matcher(key);
        return matcher.matches() ? matcher.group(1) : null;
    }

    @Override
    public void setLevel(String logger, String level) {
        if (logger == null || "ROOT".equalsIgnoreCase(logger)) {
            this.config.put(ROOT_LOGGER_LEVEL, level);
        } else {
            String loggerKey = null;
            for (String key : this.config.keySet()) {
                String name;
                Matcher matcher = Pattern.compile("\\Qlog4j2.logger.\\E([a-zA-Z_]+)\\Q.name\\E").matcher(key);
                if (!matcher.matches() || !(name = this.config.get(key).toString()).matches(logger)) continue;
                loggerKey = matcher.group(1);
                break;
            }
            if (loggerKey != null) {
                if (Level.isDefault(level)) {
                    this.config.remove(this.level(loggerKey));
                } else {
                    this.config.put(this.level(loggerKey), level);
                }
            } else {
                loggerKey = logger.replace('.', '_').toLowerCase();
                this.config.put(this.name(loggerKey), logger);
                this.config.put(this.level(loggerKey), level);
            }
        }
    }

    private String name(String logger) {
        return LOGGER_PREFIX + logger + NAME_SUFFIX;
    }

    private String level(String logger) {
        return LOGGER_PREFIX + logger + LEVEL_SUFFIX;
    }
}

