/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.ConfigurationHelper;
import org.apache.camel.impl.DefaultEndpointConfiguration;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class MappedEndpointConfiguration
extends DefaultEndpointConfiguration {
    private Map<String, Object> params = new LinkedHashMap<String, Object>();

    MappedEndpointConfiguration(CamelContext camelContext) {
        super(camelContext);
    }

    MappedEndpointConfiguration(CamelContext camelContext, String uri) {
        super(camelContext);
        this.setURI(uri);
    }

    @Override
    public <T> T getParameter(String name) {
        return (T)this.params.get(name);
    }

    @Override
    public <T> void setParameter(String name, T value) {
        this.params.put(name, value);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof MappedEndpointConfiguration)) {
            return false;
        }
        return this == other || this.getClass() == other.getClass() && this.params.equals(((MappedEndpointConfiguration)other).params);
    }

    public int hashCode() {
        return this.params.hashCode();
    }

    @Override
    protected void parseURI() {
        ConfigurationHelper.populateFromURI(this.getCamelContext(), this, new ConfigurationHelper.ParameterSetter(){

            @Override
            public <T> void set(CamelContext camelContext, EndpointConfiguration config, String name, T value) {
                if (name != null && value != null) {
                    MappedEndpointConfiguration.this.params.put(name, value);
                }
            }
        });
    }

    @Override
    public String toUriString(EndpointConfiguration.UriFormat format) {
        Set<Map.Entry<String, Object>> entries = this.params.entrySet();
        ArrayList<String> queryParams = new ArrayList<String>();
        String scheme = null;
        String schemeSpecificPart = null;
        String authority = null;
        String path = null;
        String fragment = null;
        TypeConverter converter = this.getCamelContext().getTypeConverter();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equals("scheme")) {
                scheme = converter.convertTo(String.class, value);
                continue;
            }
            if (key.equals("schemeSpecificPart")) {
                schemeSpecificPart = converter.convertTo(String.class, value);
                continue;
            }
            if (key.equals("authority")) {
                authority = converter.convertTo(String.class, value);
                continue;
            }
            if (key.equals("userInfo") || key.equals("host") || key.equals("port")) continue;
            if (key.equals("path")) {
                path = converter.convertTo(String.class, value);
                continue;
            }
            if (key.equals("query")) continue;
            if (key.equals("fragment")) {
                fragment = converter.convertTo(String.class, value);
                continue;
            }
            if (value instanceof List) {
                for (Object item : (List)value) {
                    queryParams.add(key + "=" + UnsafeUriCharactersEncoder.encode(item.toString()));
                }
                continue;
            }
            queryParams.add(key + "=" + UnsafeUriCharactersEncoder.encode(value.toString()));
        }
        Collections.sort(queryParams);
        String q = "";
        for (String entry : queryParams) {
            q = q + (q.length() == 0 ? "" : "&");
            q = q + entry;
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        if (scheme != null) {
            stringBuilder.append(scheme);
            stringBuilder.append(":");
        }
        if (authority != null) {
            stringBuilder.append("//");
            stringBuilder.append(authority);
            stringBuilder.append(path);
            if (q.length() > 0) {
                stringBuilder.append("?");
                stringBuilder.append(q);
            }
            if (fragment != null) {
                stringBuilder.append("#");
                stringBuilder.append(fragment);
            }
        } else {
            if (!schemeSpecificPart.startsWith("//")) {
                stringBuilder.append("//");
            }
            stringBuilder.append(schemeSpecificPart);
        }
        return stringBuilder.toString();
    }
}

