/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.discovery;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.jolokia.discovery.AbstractDiscoveryMessage;
import org.jolokia.discovery.AgentDetails;
import org.jolokia.discovery.DiscoveryIncomingMessage;

public final class DiscoveryOutgoingMessage
extends AbstractDiscoveryMessage {
    private final InetAddress targetAddress;
    private final int targetPort;

    private DiscoveryOutgoingMessage(AbstractDiscoveryMessage.MessageType pType, InetAddress pTargetAddress, int pTargetPort, AgentDetails pAgentDetails) {
        this.targetAddress = pTargetAddress;
        this.targetPort = pTargetPort;
        this.setType(pType);
        this.setAgentDetails(pAgentDetails);
    }

    public InetAddress getTargetAddress() {
        return this.targetAddress;
    }

    public int getTargetPort() {
        return this.targetPort;
    }

    public DatagramPacket createDatagramPacket(InetAddress address, int port) {
        byte[] out = this.getData();
        return new DatagramPacket(out, out.length, address, port);
    }

    public static class Builder {
        private AgentDetails agentDetails;
        private AbstractDiscoveryMessage.MessageType type;
        private InetAddress targetAddress;
        private int targetPort;
        private String agentId;

        public Builder(AbstractDiscoveryMessage.MessageType pType) {
            this.type = pType;
        }

        public Builder agentDetails(AgentDetails pAgentDetails) {
            this.agentDetails = pAgentDetails;
            return this;
        }

        public Builder agentId(String pAgentId) {
            this.agentId = pAgentId;
            return this;
        }

        public Builder respondTo(DiscoveryIncomingMessage pMsg) {
            if (pMsg != null) {
                this.targetAddress = pMsg.getSourceAddress();
                this.targetPort = pMsg.getSourcePort();
            }
            return this;
        }

        public DiscoveryOutgoingMessage build() {
            return new DiscoveryOutgoingMessage(this.type, this.targetAddress, this.targetPort, this.agentDetails != null ? this.agentDetails : new AgentDetails(this.agentId));
        }
    }
}

