/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Traceable;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.processor.aggregate.UseOriginalAggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class Splitter
extends MulticastProcessor
implements AsyncProcessor,
Traceable {
    private final Expression expression;

    public Splitter(CamelContext camelContext, Expression expression, Processor destination, AggregationStrategy aggregationStrategy) {
        this(camelContext, expression, destination, aggregationStrategy, false, null, false, false, false, 0L, null, false);
    }

    @Deprecated
    public Splitter(CamelContext camelContext, Expression expression, Processor destination, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean useSubUnitOfWork) {
        this(camelContext, expression, destination, aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, useSubUnitOfWork, false);
    }

    public Splitter(CamelContext camelContext, Expression expression, Processor destination, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean shutdownExecutorService, boolean streaming, boolean stopOnException, long timeout, Processor onPrepare, boolean useSubUnitOfWork, boolean parallelAggregate) {
        super(camelContext, Collections.singleton(destination), aggregationStrategy, parallelProcessing, executorService, shutdownExecutorService, streaming, stopOnException, timeout, onPrepare, useSubUnitOfWork, parallelAggregate);
        this.expression = expression;
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notNull(destination, "destination");
    }

    @Override
    public String toString() {
        return "Splitter[on: " + this.expression + " to: " + this.getProcessors().iterator().next() + " aggregate: " + this.getAggregationStrategy() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "split[" + this.expression + "]";
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null) {
            AggregationStrategy original = new UseOriginalAggregationStrategy(exchange, true);
            if (this.isShareUnitOfWork()) {
                original = new ShareUnitOfWorkAggregationStrategy(original);
            }
            this.setAggregationStrategyOnExchange(exchange, original);
        }
        return super.process(exchange, callback);
    }

    @Override
    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        Object value = this.expression.evaluate(exchange, Object.class);
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        Iterable<ProcessorExchangePair> answer = this.isStreaming() ? this.createProcessorExchangePairsIterable(exchange, value) : this.createProcessorExchangePairsList(exchange, value);
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        return answer;
    }

    private Iterable<ProcessorExchangePair> createProcessorExchangePairsIterable(Exchange exchange, Object value) {
        return new SplitterIterable(exchange, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<ProcessorExchangePair> createProcessorExchangePairsList(Exchange exchange, Object value) {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>();
        Iterable<ProcessorExchangePair> pairs = this.createProcessorExchangePairsIterable(exchange, value);
        try {
            for (ProcessorExchangePair pair : pairs) {
                if (pair == null) continue;
                result.add(pair);
            }
        }
        finally {
            if (pairs instanceof Closeable) {
                IOHelper.close((Closeable)((Object)pairs), "Splitter:ProcessorExchangePairs");
            }
        }
        return result;
    }

    @Override
    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs, Iterator<ProcessorExchangePair> it) {
        exchange.setUnitOfWork(null);
        exchange.setProperty("CamelSplitIndex", index);
        if (allPairs instanceof Collection) {
            exchange.setProperty("CamelSplitSize", ((Collection)allPairs).size());
        }
        if (it.hasNext()) {
            exchange.setProperty("CamelSplitComplete", Boolean.FALSE);
        } else {
            exchange.setProperty("CamelSplitComplete", Boolean.TRUE);
            exchange.setProperty("CamelSplitSize", index + 1);
        }
    }

    @Override
    protected Integer getExchangeIndex(Exchange exchange) {
        return exchange.getProperty("CamelSplitIndex", Integer.class);
    }

    public Expression getExpression() {
        return this.expression;
    }

    private static Exchange copyExchangeNoAttachments(Exchange exchange, boolean preserveExchangeId) {
        Exchange answer = ExchangeHelper.createCopy(exchange, preserveExchangeId);
        answer.getIn().setAttachmentObjects(null);
        answer.getProperties().remove("CamelMessageHistory");
        return answer;
    }

    private final class SplitterIterable
    implements Iterable<ProcessorExchangePair>,
    Closeable {
        final Object value;
        final Iterator<?> iterator;
        private final Exchange copy;
        private final RouteContext routeContext;
        private final Exchange original;

        private SplitterIterable(Exchange exchange, Object value) {
            this.original = exchange;
            this.value = value;
            this.iterator = ObjectHelper.createIterator(value);
            this.copy = Splitter.copyExchangeNoAttachments(exchange, true);
            this.routeContext = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getRouteContext() : null;
        }

        @Override
        public Iterator<ProcessorExchangePair> iterator() {
            return new Iterator<ProcessorExchangePair>(){
                private int index;
                private boolean closed;

                @Override
                public boolean hasNext() {
                    if (this.closed) {
                        return false;
                    }
                    boolean answer = SplitterIterable.this.iterator.hasNext();
                    if (!answer) {
                        this.closed = true;
                        try {
                            SplitterIterable.this.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeCamelException("Scanner aborted because of an IOException!", e);
                        }
                    }
                    return answer;
                }

                @Override
                public ProcessorExchangePair next() {
                    Object part = SplitterIterable.this.iterator.next();
                    if (part != null) {
                        Exchange newExchange = ExchangeHelper.createCorrelatedCopy(SplitterIterable.this.copy, false);
                        if (newExchange.getProperty("CamelStreamCacheUnitOfWork") == null) {
                            newExchange.setProperty("CamelStreamCacheUnitOfWork", SplitterIterable.this.original.getUnitOfWork());
                        }
                        if (Splitter.this.isShareUnitOfWork()) {
                            Splitter.this.prepareSharedUnitOfWork(newExchange, SplitterIterable.this.copy);
                        }
                        if (part instanceof Message) {
                            newExchange.setIn((Message)part);
                        } else {
                            Message in = newExchange.getIn();
                            in.setBody(part);
                        }
                        return Splitter.this.createProcessorExchangePair(this.index++, Splitter.this.getProcessors().iterator().next(), newExchange, SplitterIterable.this.routeContext);
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove is not supported by this iterator");
                }
            };
        }

        @Override
        public void close() throws IOException {
            if (this.value instanceof Scanner) {
                Scanner scanner = (Scanner)this.value;
                scanner.close();
                IOException ioException = scanner.ioException();
                if (ioException != null) {
                    throw ioException;
                }
            } else if (this.value instanceof Closeable) {
                IOHelper.closeWithException((Closeable)this.value);
            }
        }
    }
}

