/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.remote;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.remote.ConsulConfigurationDefinition;
import org.apache.camel.model.remote.DnsConfigurationDefinition;
import org.apache.camel.model.remote.EtcdConfigurationDefinition;
import org.apache.camel.model.remote.KubernetesConfigurationDefinition;
import org.apache.camel.model.remote.RibbonConfigurationDefinition;
import org.apache.camel.model.remote.ServiceCallConfigurationDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.ServiceCallLoadBalancer;
import org.apache.camel.spi.ServiceCallServerListStrategy;

@Metadata(label="eip,routing")
@XmlRootElement(name="serviceCall")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceCallDefinition
extends NoOutputDefinition<ServiceCallDefinition> {
    @XmlAttribute
    @Metadata(required="true")
    private String name;
    @XmlAttribute
    @Metadata(required="true")
    private String uri;
    @XmlAttribute
    private ExchangePattern pattern;
    @XmlElement
    private ServiceCallConfigurationDefinition serviceCallConfiguration;
    @XmlAttribute
    private String serviceCallConfigurationRef;
    @XmlAttribute
    private String loadBalancerRef;
    @XmlTransient
    private ServiceCallLoadBalancer loadBalancer;
    @XmlAttribute
    private String serverListStrategyRef;
    @XmlTransient
    private ServiceCallServerListStrategy serverListStrategy;

    public String toString() {
        return "ServiceCall[" + this.name + "]";
    }

    @Override
    public String getLabel() {
        return "serviceCall";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        throw new IllegalStateException("Cannot find Camel component supporting the ServiceCall EIP such as camel-kubernetes or camel-ribbon.");
    }

    public ServiceCallDefinition pattern(ExchangePattern pattern) {
        this.setPattern(pattern);
        return this;
    }

    public ServiceCallDefinition name(String name) {
        this.setName(name);
        return this;
    }

    public ServiceCallDefinition uri(String uri) {
        this.setUri(uri);
        return this;
    }

    public KubernetesConfigurationDefinition kubernetesConfiguration() {
        this.serviceCallConfiguration = new KubernetesConfigurationDefinition(this);
        return (KubernetesConfigurationDefinition)this.serviceCallConfiguration;
    }

    public RibbonConfigurationDefinition ribbonConfiguration() {
        this.serviceCallConfiguration = new RibbonConfigurationDefinition(this);
        return (RibbonConfigurationDefinition)this.serviceCallConfiguration;
    }

    public ConsulConfigurationDefinition consulConfiguration() {
        this.serviceCallConfiguration = new ConsulConfigurationDefinition(this);
        return (ConsulConfigurationDefinition)this.serviceCallConfiguration;
    }

    public EtcdConfigurationDefinition etcdConfiguration() {
        this.serviceCallConfiguration = new EtcdConfigurationDefinition(this);
        return (EtcdConfigurationDefinition)this.serviceCallConfiguration;
    }

    public DnsConfigurationDefinition dnsConfiguration() {
        this.serviceCallConfiguration = new DnsConfigurationDefinition(this);
        return (DnsConfigurationDefinition)this.serviceCallConfiguration;
    }

    public ServiceCallDefinition serviceCallConfiguration(ServiceCallConfigurationDefinition configuration) {
        this.serviceCallConfiguration = configuration;
        return this;
    }

    public ServiceCallDefinition serviceCallConfiguration(String ref) {
        this.serviceCallConfigurationRef = ref;
        return this;
    }

    public ServiceCallDefinition loadBalancer(String loadBalancerRef) {
        this.setLoadBalancerRef(loadBalancerRef);
        return this;
    }

    public ServiceCallDefinition loadBalancer(ServiceCallLoadBalancer loadBalancer) {
        this.setLoadBalancer(loadBalancer);
        return this;
    }

    public ServiceCallDefinition serverListStrategy(String serverListStrategyRef) {
        this.setServerListStrategyRef(serverListStrategyRef);
        return this;
    }

    public ServiceCallDefinition serverListStrategy(ServiceCallServerListStrategy serverListStrategy) {
        this.setServerListStrategy(serverListStrategy);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public ServiceCallConfigurationDefinition getServiceCallConfiguration() {
        return this.serviceCallConfiguration;
    }

    public void setServiceCallConfiguration(ServiceCallConfigurationDefinition serviceCallConfiguration) {
        this.serviceCallConfiguration = serviceCallConfiguration;
    }

    public String getServiceCallConfigurationRef() {
        return this.serviceCallConfigurationRef;
    }

    public void setServiceCallConfigurationRef(String serviceCallConfigurationRef) {
        this.serviceCallConfigurationRef = serviceCallConfigurationRef;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getLoadBalancerRef() {
        return this.loadBalancerRef;
    }

    public void setLoadBalancerRef(String loadBalancerRef) {
        this.loadBalancerRef = loadBalancerRef;
    }

    public ServiceCallLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(ServiceCallLoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public String getServerListStrategyRef() {
        return this.serverListStrategyRef;
    }

    public void setServerListStrategyRef(String serverListStrategyRef) {
        this.serverListStrategyRef = serverListStrategyRef;
    }

    public ServiceCallServerListStrategy getServerListStrategy() {
        return this.serverListStrategy;
    }

    public void setServerListStrategy(ServiceCallServerListStrategy serverListStrategy) {
        this.serverListStrategy = serverListStrategy;
    }
}

