/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.util.regex.Pattern;
import org.apache.felix.gogo.runtime.BaseTokenizer;
import org.apache.felix.gogo.runtime.EOFError;
import org.apache.felix.gogo.runtime.Token;

public class Tokenizer
extends BaseTokenizer {
    private final Pattern redir = Pattern.compile("[0-9&]?>|[0-9]?>>|[0-9]?>&|[0-9]?<|[0-9]?<>|<<<|<<\\-?");
    protected boolean inArray;
    protected int word = 0;
    protected Token pushed;
    protected Token last;

    public Tokenizer(CharSequence text) {
        super(text);
    }

    @Override
    public Token text() {
        return this.text;
    }

    public Token next() {
        if (this.pushed != null) {
            Token t = this.pushed;
            this.pushed = null;
            return t;
        }
        this.skipSpace(this.last == null || Token.eq(this.last, "\n"));
        int start = this.index - 1;
        block16: while (true) {
            switch (this.ch) {
                case '\uffff': {
                    return this.token(start);
                }
                case '[': {
                    this.word = 0;
                    this.inArray = true;
                    return this.token(start);
                }
                case ']': {
                    this.inArray = false;
                    ++this.word;
                    return this.token(start);
                }
                case '{': {
                    if (start == this.index - 1 && Character.isWhitespace(this.peek())) {
                        this.word = 0;
                        return this.token(start);
                    }
                    if (this.ch == '{') {
                        this.find('}', '{');
                    } else {
                        this.find(')', '(');
                    }
                    this.getch();
                    continue block16;
                }
                case '(': {
                    if (start == this.index - 1) {
                        this.word = 0;
                        return this.token(start);
                    }
                    if (this.ch == '{') {
                        this.find('}', '{');
                    } else {
                        this.find(')', '(');
                    }
                    this.getch();
                    continue block16;
                }
                case '<': 
                case '>': {
                    Token tn;
                    Token t = this.text.subSequence(start, this.index);
                    if (!this.eot() && this.redir.matcher(tn = this.text.subSequence(start, this.index + 1)).matches()) {
                        this.getch();
                        continue block16;
                    }
                    if (this.redir.matcher(t).matches() && start < this.index - 1) {
                        this.getch();
                    }
                    this.word = 0;
                    return this.token(start);
                }
                case '-': {
                    Token t = this.text.subSequence(start, this.index);
                    if (this.redir.matcher(t).matches()) {
                        this.getch();
                        return this.token(start);
                    }
                    this.getch();
                    continue block16;
                }
                case '&': {
                    if (start == this.index - 1) {
                        if (this.peek() == '&' || this.peek() == '>') {
                            this.getch();
                            this.getch();
                        }
                        this.word = 0;
                        return this.token(start);
                    }
                    if (this.redir.matcher(this.text.subSequence(start, this.index)).matches()) {
                        this.getch();
                        continue block16;
                    }
                    this.word = 0;
                    return this.token(start);
                }
                case '|': {
                    if (start == this.index - 1 && (this.peek() == '|' || this.peek() == '&')) {
                        this.getch();
                        this.getch();
                    }
                    this.word = 0;
                    return this.token(start);
                }
                case ';': {
                    this.word = 0;
                    return this.token(start);
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ')': 
                case '}': {
                    ++this.word;
                    return this.token(start);
                }
                case '=': {
                    if (this.inArray || this.word < 1 || this.index == start + 1) {
                        ++this.word;
                        return this.token(start);
                    }
                    this.getch();
                    continue block16;
                }
                case '\\': {
                    this.escape();
                    this.getch();
                    continue block16;
                }
                case '\"': 
                case '\'': {
                    this.skipQuote();
                    this.getch();
                    continue block16;
                }
            }
            this.getch();
        }
    }

    private Token token(int start) {
        if (start == this.index - 1) {
            if (this.ch == '\uffff') {
                return null;
            }
            if (this.ch == '\r' && this.peek() == '\n') {
                this.getch();
            }
            this.getch();
            this.last = this.text.subSequence(this.index - 2, this.index - 1);
        } else {
            this.last = this.text.subSequence(start, this.index - 1);
        }
        return this.last;
    }

    public void push(Token token) {
        this.pushed = token;
    }

    public Token readHereDoc(boolean ignoreLeadingTabs) {
        short sLine = this.line;
        short sCol = this.column;
        this.skipSpace();
        int start = this.index - 1;
        while (this.ch != '\n' && this.ch != '\uffff') {
            this.getch();
        }
        if (this.ch == '\uffff') {
            throw new EOFError(sLine, sCol, "expected here-doc start", "heredoc", "foo");
        }
        Token token = this.text.subSequence(start, this.index - 1);
        this.getch();
        int nlIndex = start = this.index - 1;
        boolean nl = true;
        while (true) {
            if (nl) {
                if (ignoreLeadingTabs && this.ch == '\t') {
                    ++nlIndex;
                } else {
                    nl = false;
                }
            }
            if (this.ch == '\n' || this.ch == '\uffff') {
                Token s = this.text.subSequence(nlIndex, this.index - 1);
                if (Token.eq(s, token)) {
                    Token hd = this.text.subSequence(start, s.start());
                    this.getch();
                    return hd;
                }
                nlIndex = this.index;
                nl = true;
            }
            if (this.ch == '\uffff') {
                throw new EOFError(sLine, sCol, "unexpected eof found in here-doc", "heredoc", token.toString());
            }
            this.getch();
        }
    }
}

