/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.felix.gogo.jline.BaseConverters;
import org.apache.felix.gogo.jline.Builtin;
import org.apache.felix.gogo.jline.Posix;
import org.apache.felix.gogo.jline.Procedural;
import org.apache.felix.gogo.jline.Shell;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        InputStream sin = System.in;
        PrintStream sout = System.out;
        PrintStream serr = System.err;
        try (Terminal terminal = TerminalBuilder.builder().name("gogo").type(System.getenv("TERM")).system(true).streams(sin, (OutputStream)sout).nativeSignals(true).signalHandler(Terminal.SignalHandler.SIG_IGN).build();){
            ThreadIOImpl tio = new ThreadIOImpl();
            tio.start();
            try {
                CommandProcessorImpl processor = new CommandProcessorImpl(tio);
                MyContext context = new MyContext();
                Shell shell = new Shell(context, processor);
                processor.addCommand("gogo", (Object)processor, "addCommand");
                processor.addCommand("gogo", (Object)processor, "removeCommand");
                processor.addCommand("gogo", (Object)processor, "eval");
                processor.addConverter(new BaseConverters());
                Main.register(processor, new Builtin(), Builtin.functions);
                Main.register(processor, new Procedural(), Procedural.functions);
                Main.register(processor, new Posix(processor), Posix.functions);
                Main.register(processor, shell, Shell.functions);
                CommandSessionImpl session = processor.createSession(terminal.input(), terminal.output(), terminal.output());
                session.put(".context", context);
                session.put(".terminal", terminal);
                try {
                    String[] argv = new String[args.length + 1];
                    argv[0] = "--login";
                    System.arraycopy(args, 0, argv, 1, args.length);
                    shell.gosh(session, argv);
                }
                catch (Exception e) {
                    Object loc = session.get(".location");
                    if (null == loc || !loc.toString().contains(":")) {
                        loc = "gogo";
                    }
                    System.err.println(loc + ": " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
                finally {
                    session.close();
                }
            }
            finally {
                tio.stop();
            }
        }
    }

    static void register(CommandProcessorImpl processor, Object target, String[] functions) {
        for (String function : functions) {
            processor.addCommand("gogo", target, function);
        }
    }

    private static class MyContext
    implements Shell.Context {
        private MyContext() {
        }

        @Override
        public String getProperty(String name) {
            return System.getProperty(name);
        }

        @Override
        public void exit() throws Exception {
            System.exit(0);
        }
    }
}

