/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Map;
import org.apache.karaf.log.core.Level;
import org.apache.karaf.log.core.LogService;
import org.apache.karaf.log.core.internal.LogServiceInternal;
import org.apache.karaf.log.core.internal.LogServiceLog4j1Impl;
import org.apache.karaf.log.core.internal.LogServiceLog4j2Impl;
import org.apache.karaf.log.core.internal.LruList;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class LogServiceImpl
implements LogService {
    static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    private final ConfigurationAdmin configAdmin;
    private final LruList events;

    public LogServiceImpl(ConfigurationAdmin configAdmin, LruList events) {
        this.configAdmin = configAdmin;
        this.events = events;
    }

    private LogServiceInternal getDelegate(Dictionary<String, Object> config) {
        if (config.get("log4j.rootLogger") != null) {
            return new LogServiceLog4j1Impl(config);
        }
        if (config.get("log4j2.rootLogger.level") != null) {
            return new LogServiceLog4j2Impl(config);
        }
        throw new IllegalStateException("Unrecognized configuration");
    }

    @Override
    public String getLevel() {
        return this.getLevel("ROOT").get("ROOT");
    }

    @Override
    public Map<String, String> getLevel(String logger) {
        Configuration cfg;
        try {
            cfg = this.configAdmin.getConfiguration(CONFIGURATION_PID, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving Log information from config admin", e);
        }
        if (logger == null) {
            logger = "ROOT";
        }
        return this.getDelegate(cfg.getProperties()).getLevel(logger);
    }

    @Override
    public void setLevel(String level) {
        this.setLevel("ROOT", level);
    }

    @Override
    public void setLevel(String logger, String level) {
        level = level.toUpperCase();
        Level lvl = Level.valueOf(level);
        if (logger == null) {
            logger = "ROOT";
        }
        if (lvl == Level.DEFAULT && "ROOT".equals(logger)) {
            throw new IllegalStateException("Can not unset the ROOT logger");
        }
        Configuration cfg = this.getConfiguration();
        Dictionary props = cfg.getProperties();
        this.getDelegate(props).setLevel(logger, level);
        try {
            cfg.update(props);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing log config to config admin", e);
        }
    }

    private boolean checkIfFromRequestedLog(PaxLoggingEvent event, String logger) {
        return event.getLoggerName().lastIndexOf(logger) >= 0;
    }

    private Configuration getConfiguration() {
        try {
            return this.configAdmin.getConfiguration(CONFIGURATION_PID, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving Log information from config admin", e);
        }
    }

    @Override
    public Iterable<PaxLoggingEvent> getEvents() {
        return this.events.getElements();
    }

    @Override
    public Iterable<PaxLoggingEvent> getEvents(int maxNum) {
        return this.events.getElements(maxNum);
    }

    @Override
    public void clearEvents() {
        this.events.clear();
    }

    @Override
    public PaxLoggingEvent getLastException(String logger) {
        PaxLoggingEvent throwableEvent = null;
        Iterable<PaxLoggingEvent> le = this.getEvents();
        for (PaxLoggingEvent event : le) {
            if (event.getThrowableStrRep() != null && logger != null && this.checkIfFromRequestedLog(event, logger)) {
                throwableEvent = event;
                continue;
            }
            if (event.getThrowableStrRep() == null || logger != null) continue;
            throwableEvent = event;
        }
        return throwableEvent;
    }

    @Override
    public void addAppender(PaxAppender appender) {
        this.events.addAppender(appender);
    }

    @Override
    public void removeAppender(PaxAppender appender) {
        this.events.removeAppender(appender);
    }
}

