/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.jsp.JspServletWrapper;
import org.ops4j.pax.web.service.SharedWebContainerContext;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.WebContainerDTO;
import org.ops4j.pax.web.service.internal.ConfigurationImpl;
import org.ops4j.pax.web.service.internal.DefaultHttpContext;
import org.ops4j.pax.web.service.internal.DefaultSharedWebContainerContext;
import org.ops4j.pax.web.service.internal.StoppableHttpService;
import org.ops4j.pax.web.service.internal.WebContainerContextWrapper;
import org.ops4j.pax.web.service.internal.WhiteboardDtoService;
import org.ops4j.pax.web.service.internal.util.SupportUtils;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerEvent;
import org.ops4j.pax.web.service.spi.ServerListener;
import org.ops4j.pax.web.service.spi.ServletEvent;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.ResourceModel;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.service.spi.model.ServiceModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.ops4j.pax.web.service.spi.model.WebSocketModel;
import org.ops4j.pax.web.service.spi.model.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.util.ResourceDelegatingBundleClassLoader;
import org.ops4j.pax.web.service.whiteboard.WhiteboardElement;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpServiceStarted
implements StoppableHttpService {
    private static final String PAX_WEB_JSP_SERVLET = "jsp";
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceStarted.class);
    private static SharedWebContainerContext sharedWebContainerContext = new DefaultSharedWebContainerContext();
    final Bundle serviceBundle;
    private final ClassLoader bundleClassLoader;
    private final ServerController serverController;
    private final ServerModel serverModel;
    private final ServiceModel serviceModel;
    private final ServerListener serverListener;
    private final ServletListener eventDispatcher;
    private final Object lock = new Object();

    HttpServiceStarted(Bundle bundle, ServerController srvController, ServerModel serverModel, ServletListener eventDispatcher) {
        LOG.debug("Creating http service for: " + bundle);
        NullArgumentException.validateNotNull(bundle, "Bundle");
        NullArgumentException.validateNotNull(srvController, "Server controller");
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.serviceBundle = bundle;
        Set wiredBundles = ClassPathUtil.getBundlesInClassSpace((Bundle)bundle, new LinkedHashSet());
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        bundles.add(bundle);
        bundles.addAll(wiredBundles);
        this.bundleClassLoader = new ResourceDelegatingBundleClassLoader(bundles);
        this.serverController = srvController;
        this.serverModel = serverModel;
        this.eventDispatcher = eventDispatcher;
        this.serviceModel = new ServiceModel();
        this.serverListener = new ServerListener(){

            public void stateChanged(ServerEvent event) {
                LOG.debug("Handling event: [" + event + "]");
                if (event == ServerEvent.STARTED) {
                    for (ServletModel servletModel : HttpServiceStarted.this.serviceModel.getServletModels()) {
                        HttpServiceStarted.this.servletEvent(1, HttpServiceStarted.this.serviceBundle, servletModel);
                        HttpServiceStarted.this.serverController.addServlet(servletModel);
                        HttpServiceStarted.this.servletEvent(2, HttpServiceStarted.this.serviceBundle, servletModel);
                    }
                    for (ServletModel servletModel : HttpServiceStarted.this.serviceModel.getEventListenerModels()) {
                        HttpServiceStarted.this.serverController.addEventListener((EventListenerModel)servletModel);
                    }
                    for (ServletModel servletModel : HttpServiceStarted.this.serviceModel.getFilterModels()) {
                        HttpServiceStarted.this.serverController.addFilter((FilterModel)servletModel);
                    }
                    for (ServletModel servletModel : HttpServiceStarted.this.serviceModel.getErrorPageModels()) {
                        HttpServiceStarted.this.serverController.addErrorPage((ErrorPageModel)servletModel);
                    }
                }
            }
        };
        this.serverController.addListener(this.serverListener);
    }

    @Override
    public void stop() {
        this.serverController.removeListener(this.serverListener);
        for (ServletModel servletModel : this.serviceModel.getServletModels()) {
            this.servletEvent(3, this.serviceBundle, servletModel);
            this.serverModel.removeServletModel(servletModel);
            this.servletEvent(4, this.serviceBundle, servletModel);
        }
        for (ServletModel servletModel : this.serviceModel.getFilterModels()) {
            this.serverModel.removeFilterModel((FilterModel)servletModel);
        }
        for (ServletModel servletModel : this.serviceModel.getContextModels()) {
            this.serverController.removeContext((HttpContext)servletModel.getHttpContext());
        }
        this.serverModel.deassociateHttpContexts(this.serviceBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext httpContext) throws ServletException, NamespaceException {
        Object object = this.lock;
        synchronized (object) {
            this.registerServlet(alias, servlet, initParams, null, null, httpContext);
        }
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException, NamespaceException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servlet, alias, initParams, loadOnStartup, asyncSupported);
        this.registerServlet(model);
    }

    private void servletEvent(int type, Bundle bundle, ServletModel model) {
        Class<?> servletClass = model.getServletClass();
        if (servletClass == null) {
            servletClass = model.getServlet().getClass();
        }
        this.eventDispatcher.servletEvent(new ServletEvent(type, bundle, model.getAlias(), model.getName(), model.getUrlPatterns(), model.getServlet(), servletClass, (HttpContext)model.getContextModel().getHttpContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServlet(ServletModel model) throws ServletException, NamespaceException {
        this.servletEvent(1, this.serviceBundle, model);
        boolean serverSuccess = false;
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.serverModel.addServletModel(model);
            serverSuccess = true;
            this.serviceModel.addServletModel(model);
            serviceSuccess = true;
            this.serverController.addServlet(model);
            controllerSuccess = true;
            ContextModel contextModel = model.getContextModel();
            if (model.getServlet() != null && !this.isWebAppWebContainerContext(contextModel)) {
                try {
                    this.serverController.getContext(contextModel).start();
                }
                catch (Exception e) {
                    LOG.error("Could not start the servlet context for context path [" + contextModel.getContextName() + "]", (Throwable)e);
                }
            }
        }
        finally {
            if (!controllerSuccess) {
                if (serviceSuccess) {
                    this.serviceModel.removeServletModel(model);
                }
                if (serverSuccess) {
                    this.serverModel.removeServletModel(model);
                }
                this.servletEvent(5, this.serviceBundle, model);
            } else {
                this.servletEvent(2, this.serviceBundle, model);
            }
        }
    }

    private boolean isWebAppWebContainerContext(ContextModel contextModel) {
        return contextModel.getHttpContext().getClass().getName().equals("org.ops4j.pax.web.extender.war.internal.WebAppWebContainerContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        Object object = this.lock;
        synchronized (object) {
            ContextModel contextModel = this.getOrCreateContext(httpContext);
            LOG.debug("Registering resource using context [" + contextModel + "]");
            Servlet servlet = this.serverController.createResourceServlet(contextModel, alias, name);
            ResourceModel model = new ResourceModel(contextModel, servlet, alias, name);
            try {
                this.registerServlet((ServletModel)model);
            }
            catch (ServletException e) {
                LOG.error("Caught ServletException: ", (Throwable)e);
                throw new NamespaceException("Resource cant be resolved: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String alias) {
        Object object = this.lock;
        synchronized (object) {
            ServletModel model = this.serviceModel.getServletModelWithAlias(alias);
            if (model == null) {
                throw new IllegalArgumentException("Alias [" + alias + "] was never registered");
            }
            this.servletEvent(3, this.serviceBundle, model);
            this.serverModel.removeServletModel(model);
            this.serviceModel.removeServletModel(model);
            this.serverController.removeServlet(model);
            this.servletEvent(4, this.serviceBundle, model);
        }
    }

    public WebContainerContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.serviceBundle, WebContainerContext.DefaultContextIds.DEFAULT.getValue());
    }

    public WebContainerContext createDefaultHttpContext(String contextID) {
        return new DefaultHttpContext(this.serviceBundle, contextID);
    }

    public SharedWebContainerContext createDefaultSharedHttpContext() {
        return new DefaultSharedWebContainerContext();
    }

    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, null, urlPatterns, initParams, null, null, httpContext);
    }

    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, null, urlPatterns, initParams, loadOnStartup, asyncSupported, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, servletName, urlPatterns, initParams, null, null, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig, HttpContext httpContext) throws ServletException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servlet, servletName, urlPatterns, null, initParams, loadOnStartup, asyncSupported, multiPartConfig);
        try {
            this.registerServlet(model);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servlet, servletName, urlPatterns, null, initParams, loadOnStartup, asyncSupported, null);
        try {
            this.registerServlet(model);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void unregisterServlet(Servlet servlet) {
        ServletModel model = this.serviceModel.removeServlet(servlet);
        if (model != null) {
            this.servletEvent(3, this.serviceBundle, model);
            this.serverModel.removeServletModel(model);
            this.serverController.removeServlet(model);
            this.servletEvent(4, this.serviceBundle, model);
        }
    }

    public void unregisterServlet(String servletName) {
        ServletModel model = this.serviceModel.removeServlet(servletName);
        if (model != null) {
            this.servletEvent(3, this.serviceBundle, model);
            this.serverModel.removeServletModel(model);
            this.serverController.removeServlet(model);
            this.servletEvent(4, this.serviceBundle, model);
        }
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) throws ServletException {
        this.registerServlet(servletClass, urlPatterns, initParams, null, null, httpContext);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servletClass, null, urlPatterns, null, initParams, loadOnStartup, asyncSupported, null);
        try {
            this.registerServlet(model);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig, HttpContext httpContext) throws ServletException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servletClass, null, urlPatterns, null, initParams, loadOnStartup, asyncSupported, multiPartConfig);
        try {
            this.registerServlet(model);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    public void unregisterServlets(Class<? extends Servlet> servletClass) {
        Set models = this.serviceModel.removeServletClass(servletClass);
        if (models != null) {
            for (ServletModel model : models) {
                this.servletEvent(3, this.serviceBundle, model);
                this.serverModel.removeServletModel(model);
                this.serverController.removeServlet(model);
                this.servletEvent(4, this.serviceBundle, model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(EventListener listener, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        EventListenerModel model = new EventListenerModel(contextModel, listener);
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.serviceModel.addEventListenerModel(model);
            serviceSuccess = true;
            this.serverController.addEventListener(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess && serviceSuccess) {
                this.serviceModel.removeEventListener(listener);
            }
        }
    }

    public void unregisterEventListener(EventListener listener) {
        EventListenerModel model = this.serviceModel.removeEventListener(listener);
        if (model != null) {
            this.serverController.removeEventListener(model);
        }
    }

    public void registerFilter(Filter filter, String[] urlPatterns, String[] servletNames, Dictionary<String, ?> initParams, HttpContext httpContext) {
        this.registerFilter(filter, urlPatterns, servletNames, initParams, (Boolean)false, httpContext);
    }

    public void registerFilter(Filter filter, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, Boolean asyncSupported, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        FilterModel model = new FilterModel(contextModel, filter, urlPatterns, servletNames, initParams, asyncSupported.booleanValue());
        if (initParams != null && !initParams.isEmpty() && initParams.get("filterRank") != null && this.serviceModel.getFilterModels().length > 0) {
            String filterRankingString = initParams.get("filterRank");
            Integer filterRanking = Integer.valueOf(filterRankingString);
            FilterModel[] filterModels = this.serviceModel.getFilterModels();
            Integer firstRanking = Integer.valueOf((String)filterModels[0].getInitParams().get("filterRank"));
            Integer lastRanking = filterModels.length == 1 ? firstRanking : Integer.valueOf((String)filterModels[filterModels.length - 1].getInitParams().get("filterRank"));
            if (filterRanking < firstRanking) {
                Arrays.stream(filterModels).forEach(this::unregister);
                this.registerFilter(model);
                Arrays.stream(filterModels).forEach(this::registerFilter);
            } else if (filterRanking > lastRanking) {
                this.registerFilter(model);
            } else {
                List<FilterModel> filteredModels = Arrays.stream(filterModels).filter(removableFilterModel -> Integer.valueOf((String)removableFilterModel.getInitParams().get("filterRank")) > filterRanking).collect(Collectors.toList());
                filteredModels.forEach(this::unregister);
                this.registerFilter(model);
                filteredModels.forEach(this::registerFilter);
            }
        } else {
            this.registerFilter(model);
        }
    }

    private void unregister(FilterModel model) {
        this.serviceModel.removeFilter(model.getName());
        this.serverModel.removeFilterModel(model);
        this.serverController.removeFilter(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFilter(FilterModel model) {
        boolean serverSuccess = false;
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.serverModel.addFilterModel(model);
            serverSuccess = true;
            this.serviceModel.addFilterModel(model);
            serviceSuccess = true;
            this.serverController.addFilter(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess) {
                if (serviceSuccess) {
                    this.serviceModel.removeFilter(model.getName());
                }
                if (serverSuccess) {
                    this.serverModel.removeFilterModel(model);
                }
            }
        }
    }

    public void registerFilter(Class<? extends Filter> filterClass, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, HttpContext httpContext) {
        this.registerFilter(filterClass, urlPatterns, servletNames, initParams, false, httpContext);
    }

    public void registerFilter(Class<? extends Filter> filterClass, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, boolean asyncSupported, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        FilterModel model = new FilterModel(contextModel, filterClass, urlPatterns, servletNames, initParams, asyncSupported);
        this.registerFilter(model);
    }

    public void unregisterFilter(Filter filter) {
        FilterModel model = this.serviceModel.removeFilter(filter);
        if (model != null) {
            this.serverModel.removeFilterModel(model);
            this.serverController.removeFilter(model);
        }
    }

    public void unregisterFilter(Class<? extends Filter> filterClass) {
        FilterModel model = this.serviceModel.removeFilter(filterClass);
        if (model != null) {
            this.serverModel.removeFilterModel(model);
            this.serverController.removeFilter(model);
        }
    }

    public void unregisterFilter(String filterName) {
        FilterModel model = this.serviceModel.removeFilter(filterName);
        if (model != null) {
            this.serverModel.removeFilterModel(model);
            this.serverController.removeFilter(model);
        }
    }

    public void setContextParam(Dictionary<String, ?> params, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        Map contextParams = contextModel.getContextParams();
        if (!contextParams.equals(params)) {
            if (!this.serviceModel.canBeConfigured(httpContext)) {
                throw new IllegalStateException("Http context already used. Context params can be set/changed only before first usage");
            }
            contextModel.setContextParams(params);
        }
        this.serviceModel.addContextModel(contextModel);
    }

    public void setSessionTimeout(Integer minutes, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        Integer sessionTimeout = contextModel.getSessionTimeout();
        if (!(minutes == sessionTimeout || minutes != null && minutes.equals(sessionTimeout))) {
            if (!this.serviceModel.canBeConfigured(httpContext)) {
                throw new IllegalStateException("Http context already used. Session timeout can be set/changed only before first usage");
            }
            contextModel.setSessionTimeout(minutes);
        }
        this.serviceModel.addContextModel(contextModel);
    }

    public void registerJsps(String[] urlPatterns, HttpContext httpContext) {
        this.registerJsps(urlPatterns, null, httpContext);
    }

    public void registerJsps(String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) {
        this.registerJspServlet(urlPatterns, initParams, httpContext, null);
    }

    public void registerJspServlet(String[] urlPatterns, HttpContext httpContext, String jspFile) {
        this.registerJspServlet(urlPatterns, null, httpContext, jspFile);
    }

    public void registerJspServlet(String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext, String jspFile) {
        if (!SupportUtils.isJSPAvailable()) {
            throw new UnsupportedOperationException("Jsp support is not enabled. Is org.ops4j.pax.web.jsp bundle installed?");
        }
        JspServletWrapper jspServlet = new JspServletWrapper(this.serviceBundle, jspFile);
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        initParams = this.createInitParams(contextModel, initParams == null ? new Hashtable() : initParams);
        this.serviceModel.addContextModel(contextModel);
        try {
            String[] stringArray;
            String string = this.getJspServletName(jspFile);
            if (urlPatterns == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*.jsp";
            } else {
                stringArray = urlPatterns;
            }
            this.registerServlet((Servlet)jspServlet, string, stringArray, initParams, httpContext);
        }
        catch (ServletException ignore) {
            LOG.error("Internal error. Please report.", (Throwable)ignore);
        }
        Map jspServlets = contextModel.getJspServlets();
        jspServlets.put(jspServlet, urlPatterns);
    }

    private String getJspServletName(String jspFile) {
        return jspFile == null ? PAX_WEB_JSP_SERVLET : null;
    }

    private Dictionary<String, ?> createInitParams(ContextModel contextModel, Dictionary<String, ?> initParams) {
        LinkedList<Configuration> configurations = new LinkedList<Configuration>();
        Configuration serverControllerConfiguration = this.serverController.getConfiguration();
        if (initParams != null) {
            DictionaryPropertyResolver propertyResolver = new DictionaryPropertyResolver(initParams);
            ConfigurationImpl configurationImpl = new ConfigurationImpl(propertyResolver);
            configurations.add(configurationImpl);
        }
        configurations.add(serverControllerConfiguration);
        for (Configuration configuration : configurations) {
            File temporaryDirectory;
            String scratchDir = configuration.getJspScratchDir();
            if (scratchDir == null && (temporaryDirectory = configuration.getTemporaryDirectory()) != null) {
                scratchDir = temporaryDirectory.toString();
            }
            if (configuration.equals(serverControllerConfiguration)) {
                File tempDir = new File(scratchDir, contextModel.getContextName());
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                }
                scratchDir = tempDir.toString();
            }
            Integer jspCheckInterval = configuration.getJspCheckInterval();
            Boolean jspClassDebugInfo = configuration.getJspClassDebugInfo();
            Boolean jspDevelopment = configuration.getJspDevelopment();
            Boolean jspEnablePooling = configuration.getJspEnablePooling();
            String jspIeClassId = configuration.getJspIeClassId();
            String jspJavaEncoding = configuration.getJspJavaEncoding();
            Boolean jspKeepgenerated = configuration.getJspKeepgenerated();
            String jspLogVerbosityLevel = configuration.getJspLogVerbosityLevel();
            Boolean jspMappedfile = configuration.getJspMappedfile();
            Integer jspTagpoolMaxSize = configuration.getJspTagpoolMaxSize();
            Boolean jspPrecompilation = configuration.getJspPrecompilation();
            HashMap<String, Object> params = new HashMap<String, Object>(12);
            params.put("checkInterval", jspCheckInterval);
            params.put("classdebuginfo", jspClassDebugInfo);
            params.put("development", jspDevelopment);
            params.put("enablePooling", jspEnablePooling);
            params.put("ieClassId", jspIeClassId);
            params.put("javaEncoding", jspJavaEncoding);
            params.put("keepgenerated", jspKeepgenerated);
            params.put("logVerbosityLevel", jspLogVerbosityLevel);
            params.put("mappedfile", jspMappedfile);
            params.put("scratchdir", scratchDir);
            params.put("tagpoolMaxSize", jspTagpoolMaxSize);
            params.put("usePrecompiled", jspPrecompilation);
            params.keySet().removeAll(Collections.list(initParams.keys()));
            for (Map.Entry entry : params.entrySet()) {
                Object param = entry.getValue();
                if (param == null) continue;
                String initParam = (String)entry.getKey();
                ((Hashtable)initParams).put(initParam, param.toString());
            }
        }
        LOG.debug("JSP scratchdir: " + initParams.get("scratchdir"));
        return initParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterJsps(HttpContext httpContext) {
        if (!SupportUtils.isJSPAvailable()) {
            throw new UnsupportedOperationException("Jsp support is not enabled. Is org.ops4j.pax.web.jsp bundle installed?");
        }
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.serviceModel.getContextModel(httpContext);
        if (contextModel == null) {
            throw new IllegalArgumentException("Jsp support is not enabled for http context [" + httpContext + "]");
        }
        Iterator jspServlets = contextModel.getJspServlets().keySet().iterator();
        while (jspServlets.hasNext()) {
            Servlet jspServlet = (Servlet)jspServlets.next();
            try {
                this.unregisterServlet(jspServlet);
            }
            finally {
                jspServlets.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterJsps(String[] urlPatterns, HttpContext httpContext) {
        if (!SupportUtils.isJSPAvailable()) {
            throw new UnsupportedOperationException("Jsp support is not enabled. Is org.ops4j.pax.web.jsp bundle installed?");
        }
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.serviceModel.getContextModel(httpContext);
        if (contextModel == null) {
            throw new IllegalArgumentException("Jsp support is not enabled for http context [" + httpContext + "]");
        }
        Iterator jspServlets = contextModel.getJspServlets().entrySet().iterator();
        while (jspServlets.hasNext()) {
            Map.Entry entry = jspServlets.next();
            Object[] candidateUrlPatterns = (String[])entry.getValue();
            if (!Arrays.equals(urlPatterns, candidateUrlPatterns)) continue;
            Servlet jspServlet = (Servlet)entry.getKey();
            try {
                this.unregisterServlet(jspServlet);
            }
            finally {
                jspServlets.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerErrorPage(String error, String location, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [{}]", (Object)contextModel);
        ErrorPageModel model = new ErrorPageModel(contextModel, error, location);
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.serviceModel.addErrorPageModel(model);
            serviceSuccess = true;
            this.serverController.addErrorPage(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess && serviceSuccess) {
                this.serviceModel.removeErrorPage(error, contextModel);
            }
        }
    }

    public void unregisterErrorPage(String error, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ErrorPageModel model = this.serviceModel.removeErrorPage(error, this.serviceModel.getContextModel(httpContext));
        if (model != null) {
            this.serverController.removeErrorPage(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWelcomeFiles(String[] welcomeFiles, boolean redirect, HttpContext httpContext) {
        ContextModel contextModel = this.serviceModel.getContextModel(httpContext);
        WelcomeFileModel model = new WelcomeFileModel(contextModel, welcomeFiles);
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.serviceModel.addWelcomeFileModel(model);
            serviceSuccess = true;
            this.serverController.addWelcomFiles(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess && serviceSuccess) {
                this.serviceModel.removeWelcomeFileModel(Arrays.toString(welcomeFiles), contextModel);
            }
        }
    }

    public void unregisterWelcomeFiles(String[] welcomeFiles, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        NullArgumentException.validateNotNull(welcomeFiles, "WelcomeFiles");
        ContextModel contextModel = this.serviceModel.getContextModel(httpContext);
        WelcomeFileModel model = this.serviceModel.removeWelcomeFileModel(Arrays.toString(welcomeFiles), contextModel);
        if (model != null) {
            this.serverController.removeWelcomeFiles(model);
        }
    }

    public void registerLoginConfig(String authMethod, String realmName, String formLoginPage, String formErrorPage, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        String contextModelAuthMethod = contextModel.getAuthMethod();
        String contextModelRealmName = contextModel.getRealmName();
        String contextModelFormLoginPage = contextModel.getFormLoginPage();
        String contextModelFormErrorPage = contextModel.getFormErrorPage();
        if (!Arrays.asList(contextModelAuthMethod, contextModelRealmName, contextModelFormLoginPage, contextModelFormErrorPage).equals(Arrays.asList(authMethod, realmName, formLoginPage, formErrorPage))) {
            if (!this.serviceModel.canBeConfigured(httpContext)) {
                throw new IllegalStateException("Http context already used. Session timeout can be set/changed only before first usage");
            }
            contextModel.setAuthMethod(authMethod);
            contextModel.setRealmName(realmName);
            contextModel.setFormLoginPage(formLoginPage);
            contextModel.setFormErrorPage(formErrorPage);
        }
        this.serviceModel.addContextModel(contextModel);
    }

    public void unregisterLoginConfig(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.serviceModel.getContextModel(httpContext);
        if (contextModel == null || contextModel.getAuthMethod() == null || contextModel.getRealmName() == null) {
            throw new IllegalArgumentException("Security Realm and authorization method are not registered for http context [" + httpContext + "]");
        }
    }

    public void registerConstraintMapping(String constraintName, String url, String mapping, String dataConstraint, boolean authentication, List<String> roles, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        SecurityConstraintMappingModel secConstraintMapModel = new SecurityConstraintMappingModel(contextModel, constraintName, mapping, url, dataConstraint, authentication, roles);
        this.serviceModel.addSecurityConstraintMappingModel(secConstraintMapModel);
        this.serverController.addSecurityConstraintMapping(secConstraintMapModel);
    }

    public void unregisterConstraintMapping(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
    }

    public void registerServletContainerInitializer(ServletContainerInitializer servletContainerInitializer, Class<?>[] classes, HttpContext httpContext) {
        Map containerInitializers;
        Set containerInitializersClasses;
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        HashSet clazzes = new HashSet();
        if (classes != null) {
            Collections.addAll(clazzes, classes);
        }
        Set set = containerInitializersClasses = (containerInitializers = contextModel.getContainerInitializers()) == null ? null : (Set)containerInitializers.get(servletContainerInitializer);
        if (!clazzes.equals(containerInitializersClasses)) {
            if (!this.serviceModel.canBeConfigured(httpContext)) {
                throw new IllegalStateException("Http context already used. ServletContainerInitializer can be set/changed only before first usage");
            }
            contextModel.addContainerInitializer(servletContainerInitializer, clazzes);
        }
        this.serviceModel.addContextModel(contextModel);
    }

    public void registerJettyWebXml(URL jettyWebXmlURL, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        URL contextModelJettyWebXmlURL = contextModel.getJettyWebXmlURL();
        if (!(contextModelJettyWebXmlURL == jettyWebXmlURL || contextModelJettyWebXmlURL != null && contextModelJettyWebXmlURL.equals(jettyWebXmlURL))) {
            if (!this.serviceModel.canBeConfigured(httpContext)) {
                throw new IllegalStateException("Http context already used. ServletContainerInitializer can be set/changed only before first usage");
            }
            contextModel.setJettyWebXmlUrl(jettyWebXmlURL);
        }
        this.serviceModel.addContextModel(contextModel);
    }

    private ContextModel getOrCreateContext(HttpContext httpContext) {
        Object context = httpContext == null ? this.createDefaultHttpContext() : (!(httpContext instanceof WebContainerContext) ? new WebContainerContextWrapper(this.serviceBundle, httpContext) : (WebContainerContext)httpContext);
        this.serverModel.associateHttpContext(context, this.serviceBundle, httpContext instanceof SharedWebContainerContext);
        ContextModel contextModel = this.serviceModel.getContextModel((HttpContext)context);
        if (contextModel == null) {
            contextModel = new ContextModel(context, this.serviceBundle, this.bundleClassLoader);
            contextModel.setVirtualHosts(this.serverController.getConfiguration().getVirtualHosts());
        }
        return contextModel;
    }

    public SharedWebContainerContext getDefaultSharedHttpContext() {
        return sharedWebContainerContext;
    }

    public void unregisterServletContainerInitializer(HttpContext httpContext) {
    }

    public void begin(HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Beginning and ssing context [" + contextModel + "]");
        try {
            this.serverController.getContext(contextModel);
            contextModel.setWebBundle(true);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Exception starting HttpContext registration", (Throwable)e);
        }
    }

    public void end(HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        try {
            this.serverController.getContext(contextModel).start();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Exception finalizing HttpContext registration", (Throwable)e);
        }
    }

    public void setConnectorsAndVirtualHosts(List<String> connectors, List<String> virtualHosts, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        if (!this.serviceModel.canBeConfigured(httpContext)) {
            throw new IllegalStateException("Http context already used. ServletContainerInitializer can be set only before first usage");
        }
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        List<String> realVirtualHosts = new LinkedList<String>(virtualHosts);
        if (connectors.size() > 0) {
            for (String connector : connectors) {
                realVirtualHosts.add("@" + connector);
            }
        }
        if (realVirtualHosts.size() == 0) {
            realVirtualHosts = this.serverController.getConfiguration().getVirtualHosts();
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("VirtualHostList=[");
            for (String virtualHost : realVirtualHosts) {
                sb.append(virtualHost).append(",");
            }
            sb.append("]");
            LOG.debug(sb.toString());
        }
        contextModel.setVirtualHosts(realVirtualHosts);
        this.serviceModel.addContextModel(contextModel);
    }

    public void registerJspConfigTagLibs(String tagLibLocation, String tagLibUri, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        contextModel.addTagLibLocation(tagLibLocation);
        contextModel.addTagLibUri(tagLibUri);
        this.serviceModel.addContextModel(contextModel);
    }

    public void registerJspConfigPropertyGroup(List<String> includeCodes, List<String> includePreludes, List<String> urlPatterns, Boolean elIgnored, Boolean scriptingInvalid, Boolean isXml, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        contextModel.addJspIncludeCodes(includeCodes);
        contextModel.addJspIncludePreludes(includePreludes);
        contextModel.addJspUrlPatterns(urlPatterns);
        contextModel.addJspElIgnored(elIgnored);
        contextModel.addJspScriptingInvalid(scriptingInvalid);
        contextModel.addJspIsXml(isXml);
        this.serviceModel.addContextModel(contextModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWebSocket(final Object webSocket, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http Context");
        NullArgumentException.validateNotNull(webSocket, "WebSocket");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        WebSocketModel model = new WebSocketModel(contextModel, webSocket);
        boolean controllerSuccess = false;
        boolean serviceSuccess = false;
        try {
            contextModel.addContainerInitializer(new ServletContainerInitializer(){
                private Integer maxTry = 20;

                public void onStartup(Set<Class<?>> c, final ServletContext ctx) throws ServletException {
                    Callable<Boolean> task = new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return this.registerWebSocket(ctx, 1);
                        }
                    };
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    Future<Boolean> future = executor.submit(task);
                    try {
                        Boolean success = future.get(this.maxTry * 500 + 2000, TimeUnit.MILLISECONDS);
                        if (success.booleanValue()) {
                            LOG.info("registered WebSocket");
                        } else {
                            LOG.error("Failed to create WebSocket, obviosly the endpoint couldn't be registered");
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOG.error("Failed to wait for registering of WebSocket", (Throwable)e);
                    }
                }

                private boolean registerWebSocket(ServletContext ctx, int registerTry) {
                    if (registerTry == this.maxTry) {
                        LOG.error("Tried to Register Websocket for {} times, will stop now", (Object)registerTry);
                        return false;
                    }
                    ServerContainer serverContainer = (ServerContainer)ctx.getAttribute(ServerContainer.class.getName());
                    if (serverContainer != null) {
                        try {
                            serverContainer.addEndpoint(webSocket.getClass());
                            return true;
                        }
                        catch (DeploymentException e) {
                            LOG.error("Failed to register WebSocket", (Throwable)e);
                            return false;
                        }
                    }
                    try {
                        LOG.debug("couldn't find ServerContainer, will try again in 500ms");
                        LOG.debug("this is the {} try", (Object)registerTry);
                        Thread.sleep(500L);
                        return this.registerWebSocket(ctx, registerTry++);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Failed to register WebSocket due to: ", (Throwable)e);
                        return false;
                    }
                }
            }, null);
            controllerSuccess = true;
            this.serviceModel.addWebSocketModel(model);
            serviceSuccess = true;
        }
        finally {
            if (!controllerSuccess && serviceSuccess) {
                this.serviceModel.removeWebSocketModel(webSocket);
            }
        }
        if (!this.isWebAppWebContainerContext(contextModel)) {
            try {
                this.serverController.getContext(contextModel).start();
            }
            catch (Exception e) {
                LOG.error("Could not start the servlet context for context path [" + contextModel.getContextName() + "]", (Throwable)e);
            }
        }
    }

    public void unregisterWebSocket(Object webSocket, HttpContext httpContext) {
    }

    public RequestInfoDTO calculateRequestInfoDTO(String path, Iterator<WhiteboardElement> iterator) {
        return this.withWhiteboardDtoService(service -> service.calculateRequestInfoDTO(path, iterator, this.serverModel, this.serviceModel));
    }

    public RuntimeDTO createWhiteboardRuntimeDTO(Iterator<WhiteboardElement> iterator) {
        return this.withWhiteboardDtoService(service -> service.createWhiteboardRuntimeDTO(iterator, this.serverModel, this.serviceModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withWhiteboardDtoService(Function<WhiteboardDtoService, T> function) {
        WhiteboardDtoService service;
        BundleContext bundleContext = this.serviceBundle.getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(WhiteboardDtoService.class);
        if (ref != null && (service = (WhiteboardDtoService)bundleContext.getService(ref)) != null) {
            try {
                T t = function.apply(service);
                return t;
            }
            finally {
                bundleContext.ungetService(ref);
            }
        }
        throw new IllegalStateException(String.format("Service '%s' could not be retrieved!", WhiteboardDtoService.class.getName()));
    }

    public String toString() {
        return super.toString() + " for bundle " + this.serviceBundle;
    }

    public WebContainerDTO getWebcontainerDTO() {
        WebContainerDTO dto = new WebContainerDTO();
        dto.port = this.serverController.getHttpPort();
        dto.securePort = this.serverController.getHttpSecurePort();
        dto.listeningAddresses = this.serverController.getConfiguration().getListeningAddresses();
        return dto;
    }
}

