/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.jolokia.config.ConfigKey;
import org.jolokia.jvmagent.CleanupThread;
import org.jolokia.jvmagent.JolokiaHttpHandler;
import org.jolokia.jvmagent.JolokiaServerConfig;
import org.jolokia.util.NetworkUtil;

public class JolokiaServer {
    private JolokiaServerConfig config;
    private boolean lazy;
    private CleanupThread cleaner = null;
    private HttpServer httpServer;
    private InetSocketAddress serverAddress;
    private String url;
    private JolokiaHttpHandler jolokiaHttpHandler;
    private ThreadFactory daemonThreadFactory = new DaemonThreadFactory();

    public JolokiaServer(JolokiaServerConfig pConfig, boolean pLazy) throws IOException {
        this.init(pConfig, pLazy);
    }

    public JolokiaServer(HttpServer pServer, JolokiaServerConfig pConfig, boolean pLazy) {
        this.init(pServer, pConfig, pLazy);
    }

    protected JolokiaServer() {
    }

    public void start() {
        String configUrl = NetworkUtil.replaceExpression(this.config.getJolokiaConfig().get(ConfigKey.DISCOVERY_AGENT_URL));
        this.jolokiaHttpHandler.start(this.lazy, configUrl != null ? configUrl : this.url, this.config.getAuthenticator() != null);
        if (this.httpServer != null) {
            ThreadGroup threadGroup = new ThreadGroup("jolokia");
            threadGroup.setDaemon(false);
            Thread starterThread = new Thread(threadGroup, new Runnable(){

                @Override
                public void run() {
                    JolokiaServer.this.httpServer.start();
                }
            });
            starterThread.start();
            this.cleaner = new CleanupThread(this.httpServer, threadGroup);
            this.cleaner.start();
        }
    }

    public void stop() {
        this.jolokiaHttpHandler.stop();
        if (this.cleaner != null) {
            this.cleaner.stopServer();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public JolokiaServerConfig getServerConfig() {
        return this.config;
    }

    protected final void init(JolokiaServerConfig pConfig, boolean pLazy) throws IOException {
        this.httpServer = this.createHttpServer(pConfig);
        this.init(this.httpServer, pConfig, pLazy);
    }

    protected final void init(HttpServer pServer, JolokiaServerConfig pConfig, boolean pLazy) {
        this.config = pConfig;
        this.lazy = pLazy;
        String contextPath = pConfig.getContextPath();
        this.jolokiaHttpHandler = new JolokiaHttpHandler(pConfig.getJolokiaConfig());
        HttpContext context = pServer.createContext(contextPath, this.jolokiaHttpHandler);
        Authenticator authenticator = pConfig.getAuthenticator();
        if (authenticator != null) {
            context.setAuthenticator(authenticator);
        }
        this.url = this.detectAgentUrl(pServer, pConfig, contextPath);
    }

    private String detectAgentUrl(HttpServer pServer, JolokiaServerConfig pConfig, String pContextPath) {
        int port;
        InetAddress realAddress;
        this.serverAddress = pServer.getAddress();
        if (this.serverAddress != null) {
            realAddress = this.serverAddress.getAddress();
            if (realAddress.isAnyLocalAddress()) {
                try {
                    realAddress = NetworkUtil.getLocalAddress();
                }
                catch (IOException e) {
                    try {
                        realAddress = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e1) {
                        realAddress = this.serverAddress.getAddress();
                    }
                }
            }
            port = this.serverAddress.getPort();
        } else {
            realAddress = pConfig.getAddress();
            port = pConfig.getPort();
        }
        return String.format("%s://%s:%d%s", pConfig.getProtocol(), realAddress.getHostAddress(), port, pContextPath);
    }

    private HttpServer createHttpServer(JolokiaServerConfig pConfig) throws IOException {
        int port = pConfig.getPort();
        InetAddress address = pConfig.getAddress();
        String protocol = pConfig.getProtocol();
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        HttpServer server = protocol.equalsIgnoreCase("https") ? this.createHttpsServer(socketAddress, pConfig) : HttpServer.create(socketAddress, pConfig.getBacklog());
        String mode = pConfig.getExecutor();
        ExecutorService executor = "fixed".equalsIgnoreCase(mode) ? Executors.newFixedThreadPool(pConfig.getThreadNr(), this.daemonThreadFactory) : ("cached".equalsIgnoreCase(mode) ? Executors.newCachedThreadPool(this.daemonThreadFactory) : Executors.newSingleThreadExecutor(this.daemonThreadFactory));
        server.setExecutor(executor);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpServer createHttpsServer(InetSocketAddress pSocketAddress, JolokiaServerConfig pConfig) {
        try {
            HttpsServer server = HttpsServer.create(pSocketAddress, pConfig.getBacklog());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            char[] password = pConfig.getKeystorePassword();
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(pConfig.getKeystore());
                ks.load(fis, password);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            server.setHttpsConfigurator(new JolokiaHttpsConfigurator(sslContext, pConfig.useSslClientAuthentication()));
            return server;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Cannot use keystore for https communication: " + e, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot open keystore for https communication: " + e, e);
        }
    }

    public InetSocketAddress getAddress() {
        return this.serverAddress;
    }

    private static final class JolokiaHttpsConfigurator
    extends HttpsConfigurator {
        private boolean useClientAuthentication;

        private JolokiaHttpsConfigurator(SSLContext pSSLContext, boolean pUseClientAuthenication) {
            super(pSSLContext);
            this.useClientAuthentication = pUseClientAuthenication;
        }

        @Override
        public void configure(HttpsParameters params) {
            try {
                SSLContext context = SSLContext.getDefault();
                SSLEngine engine = context.createSSLEngine();
                params.setNeedClientAuth(this.useClientAuthentication);
                params.setCipherSuites(engine.getEnabledCipherSuites());
                params.setProtocols(engine.getEnabledProtocols());
                params.setSSLParameters(context.getDefaultSSLParameters());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("jolokia: Exception while configuring SSL context: " + e, e);
            }
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

