/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.ArrayList;
import java.util.List;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;
import org.jline.utils.WCWidth;

public abstract class AttributedCharSequence
implements CharSequence {
    public String toAnsi() {
        return this.toAnsi(null);
    }

    public String toAnsi(Terminal terminal) {
        StringBuilder sb = new StringBuilder();
        int style = 0;
        int foreground = -1;
        int background = -1;
        Integer max_colors = terminal == null ? Integer.valueOf(8) : terminal.getNumericCapability(InfoCmp.Capability.max_colors);
        boolean color256 = max_colors != null && max_colors >= 256;
        for (int i = 0; i < this.length(); ++i) {
            char c = this.charAt(i);
            int s = this.styleCodeAt(i) & 0xFFFFFBFF;
            if (style != s) {
                int bg;
                int d = (style ^ s) & 0x7FF;
                int fg = (s & 0x100) != 0 ? (s & 0xFF0000) >>> 16 : -1;
                int n = bg = (s & 0x200) != 0 ? (s & 0xFF000000) >>> 24 : -1;
                if (s == 0) {
                    sb.append("\u001b[0m");
                    background = -1;
                    foreground = -1;
                } else {
                    sb.append("\u001b[");
                    boolean first = true;
                    if ((d & 3) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 1) != 0 ? "1" : ((s & 2) != 0 ? "2" : "22"), first);
                    }
                    if ((d & 4) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 4) != 0 ? "3" : "23", first);
                    }
                    if ((d & 8) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 8) != 0 ? "4" : "24", first);
                    }
                    if ((d & 0x10) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 0x10) != 0 ? "5" : "25", first);
                    }
                    if ((d & 0x20) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 0x20) != 0 ? "7" : "27", first);
                    }
                    if ((d & 0x40) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 0x40) != 0 ? "8" : "28", first);
                    }
                    if ((d & 0x80) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 0x80) != 0 ? "9" : "29", first);
                    }
                    if (foreground != fg) {
                        first = fg >= 0 ? (fg < 8 || !color256 ? AttributedCharSequence.attr(sb, Integer.toString(30 + AttributedCharSequence.roundTo8Color(fg)), first) : AttributedCharSequence.attr(sb, "38;5;" + Integer.toString(fg), first)) : AttributedCharSequence.attr(sb, "39", first);
                        foreground = fg;
                    }
                    if (background != bg) {
                        first = bg >= 0 ? (bg < 8 || !color256 ? AttributedCharSequence.attr(sb, Integer.toString(40 + AttributedCharSequence.roundTo8Color(bg)), first) : AttributedCharSequence.attr(sb, "48;5;" + Integer.toString(bg), first)) : AttributedCharSequence.attr(sb, "49", first);
                        background = bg;
                    }
                    sb.append("m");
                }
                style = s;
            }
            sb.append(c);
        }
        if (style != 0) {
            sb.append("\u001b[0m");
        }
        return sb.toString();
    }

    private static int roundTo8Color(int col) {
        return col % 8;
    }

    private static boolean attr(StringBuilder sb, String s, boolean first) {
        if (!first) {
            sb.append(";");
        }
        sb.append(s);
        return false;
    }

    public abstract AttributedStyle styleAt(int var1);

    int styleCodeAt(int index) {
        return this.styleAt(index).getStyle();
    }

    public boolean isHidden(int index) {
        return (this.styleCodeAt(index) & 0x400) != 0;
    }

    public int runStart(int index) {
        AttributedStyle style = this.styleAt(index);
        while (index > 0 && this.styleAt(index - 1).equals(style)) {
            --index;
        }
        return index;
    }

    public int runLimit(int index) {
        AttributedStyle style = this.styleAt(index);
        while (index < this.length() - 1 && this.styleAt(index + 1).equals(style)) {
            ++index;
        }
        return index + 1;
    }

    @Override
    public abstract AttributedString subSequence(int var1, int var2);

    public AttributedString substring(int start, int end) {
        return this.subSequence(start, end);
    }

    protected abstract char[] buffer();

    protected abstract int offset();

    @Override
    public char charAt(int index) {
        return this.buffer()[this.offset() + index];
    }

    public int codePointAt(int index) {
        return Character.codePointAt(this.buffer(), index + this.offset());
    }

    public boolean contains(char c) {
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public int codePointBefore(int index) {
        return Character.codePointBefore(this.buffer(), index + this.offset());
    }

    public int codePointCount(int index, int length) {
        return Character.codePointCount(this.buffer(), index + this.offset(), length);
    }

    public int columnLength() {
        int cp;
        int cols = 0;
        int len = this.length();
        for (int cur = 0; cur < len; cur += Character.charCount(cp)) {
            cp = this.codePointAt(cur);
            if (this.isHidden(cur)) continue;
            cols += WCWidth.wcwidth(cp);
        }
        return cols;
    }

    public AttributedString columnSubSequence(int start, int stop) {
        int cp;
        int begin = 0;
        int col = 0;
        while (begin < this.length()) {
            int w;
            int cp2 = this.codePointAt(begin);
            int n = w = this.isHidden(begin) ? 0 : WCWidth.wcwidth(cp2);
            if (col + w > start) break;
            ++begin;
            col += w;
        }
        int end = begin;
        while (end < this.length() && (cp = this.codePointAt(end)) != 10) {
            int w;
            int n = w = this.isHidden(end) ? 0 : WCWidth.wcwidth(cp);
            if (col + w > stop) break;
            ++end;
            col += w;
        }
        return this.subSequence(begin, end);
    }

    public List<AttributedString> columnSplitLength(int columns) {
        return this.columnSplitLength(columns, false, true);
    }

    public List<AttributedString> columnSplitLength(int columns, boolean includeNewlines, boolean delayLineWrap) {
        int cur;
        ArrayList<AttributedString> strings = new ArrayList<AttributedString>();
        int beg = cur = 0;
        int col = 0;
        while (cur < this.length()) {
            int w;
            int cp = this.codePointAt(cur);
            int n = w = this.isHidden(cur) ? 0 : WCWidth.wcwidth(cp);
            if (cp == 10) {
                if (!delayLineWrap && col == columns) {
                    strings.add(this.subSequence(beg, cur));
                    strings.add(includeNewlines ? AttributedString.NEWLINE : AttributedString.EMPTY);
                } else {
                    strings.add(this.subSequence(beg, includeNewlines ? cur + 1 : cur));
                }
                beg = cur + 1;
                col = 0;
            } else if ((col += w) > columns) {
                strings.add(this.subSequence(beg, cur));
                beg = cur;
                col = w;
            }
            cur += Character.charCount(cp);
        }
        strings.add(this.subSequence(beg, cur));
        return strings;
    }

    @Override
    public String toString() {
        return new String(this.buffer(), this.offset(), this.length());
    }

    public AttributedString toAttributedString() {
        return this.substring(0, this.length());
    }
}

