/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.Channel;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;

public interface Closeable
extends Channel {
    public static final String CLOSE_WAIT_TIMEOUT = "sshd-close-wait-time";
    public static final long DEFAULT_CLOSE_WAIT_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);

    public CloseFuture close(boolean var1);

    public void addCloseFutureListener(SshFutureListener<CloseFuture> var1);

    public void removeCloseFutureListener(SshFutureListener<CloseFuture> var1);

    public boolean isClosed();

    public boolean isClosing();

    @Override
    default public boolean isOpen() {
        return !this.isClosed() && !this.isClosing();
    }

    @Override
    default public void close() throws IOException {
        Closeable.close(this);
    }

    public static long getMaxCloseWaitTime(PropertyResolver resolver) {
        return resolver == null ? DEFAULT_CLOSE_WAIT_TIMEOUT : PropertyResolverUtils.getLongProperty(resolver, CLOSE_WAIT_TIMEOUT, DEFAULT_CLOSE_WAIT_TIMEOUT);
    }

    public static void close(Closeable closeable) throws IOException {
        long maxWait;
        CloseFuture future;
        boolean successful;
        if (closeable == null) {
            return;
        }
        if (!(closeable.isClosed() || closeable.isClosing() || (successful = (future = closeable.close(true)).await(maxWait = closeable instanceof PropertyResolver ? Closeable.getMaxCloseWaitTime((PropertyResolver)((Object)closeable)) : DEFAULT_CLOSE_WAIT_TIMEOUT)))) {
            throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
        }
    }
}

