/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.common.util.ValidateUtils;

public class DefaultCloseableHandle
extends SftpClient.CloseableHandle {
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final SftpClient client;

    public DefaultCloseableHandle(SftpClient client, String path, byte[] id) {
        super(path, id);
        this.client = ValidateUtils.checkNotNull(client, "No client for path=%s", (Object)path);
    }

    public final SftpClient getSftpClient() {
        return this.client;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.client.close(this);
        }
    }
}

