/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.subsystem.AbstractSubsystemClient;
import org.apache.sshd.client.subsystem.sftp.DefaultCloseableHandle;
import org.apache.sshd.client.subsystem.sftp.RawSftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.extensions.BuiltinSftpClientExtensions;
import org.apache.sshd.client.subsystem.sftp.extensions.SftpClientExtension;
import org.apache.sshd.client.subsystem.sftp.extensions.SftpClientExtensionFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.subsystem.sftp.SftpConstants;
import org.apache.sshd.common.subsystem.sftp.SftpException;
import org.apache.sshd.common.subsystem.sftp.SftpHelper;
import org.apache.sshd.common.subsystem.sftp.SftpUniversalOwnerAndGroup;
import org.apache.sshd.common.subsystem.sftp.extensions.ParserUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public abstract class AbstractSftpClient
extends AbstractSubsystemClient
implements SftpClient,
RawSftpClient {
    private final SftpClient.Attributes fileOpenAttributes = new SftpClient.Attributes();
    private final AtomicReference<Map<String, Object>> parsedExtensionsHolder = new AtomicReference<Object>(null);

    protected AbstractSftpClient() {
        this.fileOpenAttributes.setType(1);
    }

    @Override
    public Channel getChannel() {
        return this.getClientChannel();
    }

    @Override
    public <E extends SftpClientExtension> E getExtension(Class<? extends E> extensionType) {
        SftpClientExtension instance = this.getExtension(BuiltinSftpClientExtensions.fromType(extensionType));
        if (instance == null) {
            return null;
        }
        return (E)((SftpClientExtension)extensionType.cast(instance));
    }

    @Override
    public SftpClientExtension getExtension(String extensionName) {
        return this.getExtension(BuiltinSftpClientExtensions.fromName(extensionName));
    }

    protected SftpClientExtension getExtension(SftpClientExtensionFactory factory) {
        if (factory == null) {
            return null;
        }
        Map<String, byte[]> extensions = this.getServerExtensions();
        Map<String, Object> parsed = this.getParsedServerExtensions(extensions);
        return factory.create(this, this, extensions, parsed);
    }

    protected Map<String, Object> getParsedServerExtensions() {
        return this.getParsedServerExtensions(this.getServerExtensions());
    }

    protected Map<String, Object> getParsedServerExtensions(Map<String, byte[]> extensions) {
        Map<String, Object> parsed = this.parsedExtensionsHolder.get();
        if (parsed == null) {
            parsed = ParserUtils.parse(extensions);
            if (parsed == null) {
                parsed = Collections.emptyMap();
            }
            this.parsedExtensionsHolder.set(parsed);
        }
        return parsed;
    }

    protected void checkCommandStatus(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        this.checkResponseStatus(cmd, response);
    }

    protected void checkResponseStatus(int cmd, Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            this.checkResponseStatus(cmd, id, substatus, msg, lang);
        } else {
            this.handleUnexpectedPacket(cmd, 101, id, type, length, buffer);
        }
    }

    protected void checkResponseStatus(int cmd, int id, int substatus, String msg, String lang) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("checkResponseStatus({})[id={}] cmd={} status={} lang={} msg={}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), SftpConstants.getStatusName(substatus), lang, msg});
        }
        if (substatus != 0) {
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
    }

    protected void throwStatusException(int cmd, int id, int substatus, String msg, String lang) throws IOException {
        throw new SftpException(substatus, msg);
    }

    protected byte[] checkHandle(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkHandleResponse(cmd, response);
    }

    protected byte[] checkHandleResponse(int cmd, Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 102) {
            return ValidateUtils.checkNotNullAndNotEmpty(buffer.getBytes(), "Null/empty handle in buffer", GenericUtils.EMPTY_OBJECT_ARRAY);
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkHandleResponse({})[id={}] {} - status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), SftpConstants.getStatusName(substatus), lang, msg});
            }
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
        return this.handleUnexpectedHandlePacket(cmd, id, type, length, buffer);
    }

    protected byte[] handleUnexpectedHandlePacket(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        this.handleUnexpectedPacket(cmd, 102, id, type, length, buffer);
        throw new SshException("No handling for unexpected handle packet id=" + id + ", type=" + SftpConstants.getCommandMessageName(type) + ", length=" + length);
    }

    protected SftpClient.Attributes checkAttributes(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkAttributesResponse(cmd, response);
    }

    protected SftpClient.Attributes checkAttributesResponse(int cmd, Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 105) {
            return this.readAttributes(buffer);
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkAttributesResponse()[id={}] {} - status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), SftpConstants.getStatusName(substatus), lang, msg});
            }
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
        return this.handleUnexpectedAttributesPacket(cmd, id, type, length, buffer);
    }

    protected SftpClient.Attributes handleUnexpectedAttributesPacket(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        IOException err = this.handleUnexpectedPacket(cmd, 105, id, type, length, buffer);
        if (err != null) {
            throw err;
        }
        return null;
    }

    protected String checkOneName(int cmd, Buffer request) throws IOException {
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkOneNameResponse(cmd, response);
    }

    protected String checkOneNameResponse(int cmd, Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 104) {
            int len = buffer.getInt();
            if (len != 1) {
                throw new SshException("SFTP error: received " + len + " names instead of 1");
            }
            String name = buffer.getString();
            String longName = null;
            int version = this.getVersion();
            if (version == 3) {
                longName = buffer.getString();
            }
            SftpClient.Attributes attrs = this.readAttributes(buffer);
            Boolean indicator = SftpHelper.getEndOfListIndicatorValue(buffer, version);
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkOneNameResponse({})[id={}] {} ({})[{}] eol={}: {}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), name, longName, indicator, attrs});
            }
            return name;
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkOneNameResponse({})[id={}] {} status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), SftpConstants.getStatusName(substatus), lang, msg});
            }
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
        return this.handleUnknownOneNamePacket(cmd, id, type, length, buffer);
    }

    protected String handleUnknownOneNamePacket(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        IOException err = this.handleUnexpectedPacket(cmd, 104, id, type, length, buffer);
        if (err != null) {
            throw err;
        }
        return null;
    }

    protected SftpClient.Attributes readAttributes(Buffer buffer) throws IOException {
        SftpClient.Attributes attrs = new SftpClient.Attributes();
        int flags = buffer.getInt();
        int version = this.getVersion();
        if (version == 3) {
            if ((flags & 1) != 0) {
                attrs.setSize(buffer.getLong());
            }
            if ((flags & 2) != 0) {
                attrs.owner(buffer.getInt(), buffer.getInt());
            }
            if ((flags & 4) != 0) {
                int perms = buffer.getInt();
                attrs.setPermissions(perms);
                attrs.setType(SftpHelper.permissionsToFileType(perms));
            }
            if ((flags & 8) != 0) {
                attrs.setAccessTime(SftpHelper.readTime(buffer, version, flags));
                attrs.setModifyTime(SftpHelper.readTime(buffer, version, flags));
            }
        } else if (version >= 4) {
            Object object;
            attrs.setType(buffer.getUByte());
            if ((flags & 1) != 0) {
                attrs.setSize(buffer.getLong());
            }
            if (version >= 6 && (flags & 0x400) != 0) {
                long perms = buffer.getLong();
            }
            if ((flags & 0x80) != 0) {
                attrs.setOwner(buffer.getString());
                attrs.setGroup(buffer.getString());
            }
            if ((flags & 4) != 0) {
                attrs.setPermissions(buffer.getInt());
            }
            int perms = attrs.getPermissions();
            attrs.setPermissions(perms |= SftpHelper.fileTypeToPermission(attrs.getType()));
            if ((flags & 8) != 0) {
                attrs.setAccessTime(SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x10) != 0) {
                attrs.setCreateTime(SftpHelper.readTime(buffer, version, flags));
            }
            if ((flags & 0x20) != 0) {
                attrs.setModifyTime(SftpHelper.readTime(buffer, version, flags));
            }
            if (version >= 6 && (flags & 0x8000) != 0) {
                object = SftpHelper.readTime(buffer, version, flags);
            }
            if ((flags & 0x40) != 0) {
                attrs.setAcl(SftpHelper.readACLs(buffer, version));
            }
            if ((flags & 0x200) != 0) {
                int bits = buffer.getInt();
                int valid = -1;
                if (version >= 6) {
                    valid = buffer.getInt();
                }
            }
            if (version >= 6) {
                if ((flags & 0x800) != 0) {
                    boolean bl = buffer.getBoolean();
                }
                if ((flags & 0x1000) != 0) {
                    object = buffer.getString();
                }
                if ((flags & 0x2000) != 0) {
                    int n = buffer.getInt();
                }
                if ((flags & 0x4000) != 0) {
                    String string = buffer.getString();
                }
            }
        } else {
            throw new IllegalStateException("readAttributes - unsupported version: " + version);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            attrs.setExtensions(SftpHelper.readExtensions(buffer));
        }
        return attrs;
    }

    protected void writeAttributes(Buffer buffer, SftpClient.Attributes attributes) throws IOException {
        int version = this.getVersion();
        int flagsMask = 0;
        Set<SftpClient.Attribute> flags = Objects.requireNonNull(attributes, "No attributes").getFlags();
        if (version == 3) {
            for (SftpClient.Attribute a : flags) {
                switch (a) {
                    case Size: {
                        flagsMask |= 1;
                        break;
                    }
                    case UidGid: {
                        flagsMask |= 2;
                        break;
                    }
                    case Perms: {
                        flagsMask |= 4;
                        break;
                    }
                    case AccessTime: {
                        if (!flags.contains((Object)SftpClient.Attribute.ModifyTime)) break;
                        flagsMask |= 8;
                        break;
                    }
                    case ModifyTime: {
                        if (!flags.contains((Object)SftpClient.Attribute.AccessTime)) break;
                        flagsMask |= 8;
                        break;
                    }
                    case Extensions: {
                        flagsMask |= Integer.MIN_VALUE;
                        break;
                    }
                }
            }
            buffer.putInt(flagsMask);
            if ((flagsMask & 1) != 0) {
                buffer.putLong(attributes.getSize());
            }
            if ((flagsMask & 2) != 0) {
                buffer.putInt(attributes.getUserId());
                buffer.putInt(attributes.getGroupId());
            }
            if ((flagsMask & 4) != 0) {
                buffer.putInt(attributes.getPermissions());
            }
            if ((flagsMask & 8) != 0) {
                SftpHelper.writeTime(buffer, version, flagsMask, attributes.getAccessTime());
                SftpHelper.writeTime(buffer, version, flagsMask, attributes.getModifyTime());
            }
        } else if (version >= 4) {
            for (SftpClient.Attribute a : flags) {
                switch (a) {
                    case Size: {
                        flagsMask |= 1;
                        break;
                    }
                    case OwnerGroup: {
                        flagsMask |= 0x80;
                        break;
                    }
                    case Perms: {
                        flagsMask |= 4;
                        break;
                    }
                    case AccessTime: {
                        flagsMask |= 8;
                        break;
                    }
                    case ModifyTime: {
                        flagsMask |= 0x20;
                        break;
                    }
                    case CreateTime: {
                        flagsMask |= 0x10;
                        break;
                    }
                    case Acl: {
                        flagsMask |= 0x40;
                        break;
                    }
                    case Extensions: {
                        flagsMask |= Integer.MIN_VALUE;
                        break;
                    }
                }
            }
            buffer.putInt(flagsMask);
            buffer.putByte((byte)attributes.getType());
            if ((flagsMask & 1) != 0) {
                buffer.putLong(attributes.getSize());
            }
            if ((flagsMask & 0x80) != 0) {
                String owner = attributes.getOwner();
                buffer.putString(GenericUtils.isEmpty(owner) ? SftpUniversalOwnerAndGroup.Owner.getName() : owner);
                String group = attributes.getGroup();
                buffer.putString(GenericUtils.isEmpty(group) ? SftpUniversalOwnerAndGroup.Group.getName() : group);
            }
            if ((flagsMask & 4) != 0) {
                buffer.putInt(attributes.getPermissions());
            }
            if ((flagsMask & 8) != 0) {
                SftpHelper.writeTime(buffer, version, flagsMask, attributes.getAccessTime());
            }
            if ((flagsMask & 0x10) != 0) {
                SftpHelper.writeTime(buffer, version, flagsMask, attributes.getCreateTime());
            }
            if ((flagsMask & 0x20) != 0) {
                SftpHelper.writeTime(buffer, version, flagsMask, attributes.getModifyTime());
            }
            if ((flagsMask & 0x40) != 0) {
                SftpHelper.writeACLs(buffer, version, attributes.getAcl());
            }
        } else {
            throw new UnsupportedOperationException("writeAttributes(" + attributes + ") unsupported version: " + version);
        }
        if ((flagsMask & Integer.MIN_VALUE) != 0) {
            SftpHelper.writeExtensions(buffer, attributes.getExtensions());
        }
    }

    @Override
    public SftpClient.CloseableHandle open(String path, Collection<SftpClient.OpenMode> options) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("open(" + path + ")[" + options + "] client is closed");
        }
        if (GenericUtils.isEmpty(options)) {
            options = EnumSet.of(SftpClient.OpenMode.Read);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer.putString(path);
        int version = this.getVersion();
        int mode = 0;
        if (version == 3) {
            for (SftpClient.OpenMode m : options) {
                switch (m) {
                    case Read: {
                        mode |= 1;
                        break;
                    }
                    case Write: {
                        mode |= 2;
                        break;
                    }
                    case Append: {
                        mode |= 4;
                        break;
                    }
                    case Create: {
                        mode |= 8;
                        break;
                    }
                    case Truncate: {
                        mode |= 0x10;
                        break;
                    }
                    case Exclusive: {
                        mode |= 0x20;
                        break;
                    }
                }
            }
        } else {
            if (version >= 5) {
                int access = 0;
                if (options.contains((Object)SftpClient.OpenMode.Read)) {
                    access |= 0x81;
                }
                if (options.contains((Object)SftpClient.OpenMode.Write)) {
                    access |= 0x102;
                }
                if (options.contains((Object)SftpClient.OpenMode.Append)) {
                    access |= 4;
                }
                buffer.putInt(access);
            }
            mode = options.contains((Object)SftpClient.OpenMode.Create) && options.contains((Object)SftpClient.OpenMode.Exclusive) ? (mode |= 0) : (options.contains((Object)SftpClient.OpenMode.Create) && options.contains((Object)SftpClient.OpenMode.Truncate) ? (mode |= 1) : (options.contains((Object)SftpClient.OpenMode.Create) ? (mode |= 3) : (options.contains((Object)SftpClient.OpenMode.Truncate) ? (mode |= 4) : (mode |= 2))));
        }
        buffer.putInt(mode);
        this.writeAttributes(buffer, this.fileOpenAttributes);
        DefaultCloseableHandle handle = new DefaultCloseableHandle(this, path, this.checkHandle(3, buffer));
        if (this.log.isTraceEnabled()) {
            this.log.trace("open({})[{}] options={}: {}", new Object[]{this.getClientSession(), path, options, handle});
        }
        return handle;
    }

    @Override
    public void close(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("close(" + handle + ") client is closed");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("close({}) {}", (Object)this.getClientSession(), (Object)handle);
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        this.checkCommandStatus(4, buffer);
    }

    @Override
    public void remove(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("remove(" + path + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("remove({}) {}", (Object)this.getClientSession(), (Object)path);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer.putString(path);
        this.checkCommandStatus(13, buffer);
    }

    @Override
    public void rename(String oldPath, String newPath, Collection<SftpClient.CopyMode> options) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("rename(" + oldPath + " => " + newPath + ")[" + options + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("rename({}) {} => {}", new Object[]{this.getClientSession(), oldPath, newPath});
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(oldPath.length() + newPath.length() + 64, false);
        buffer.putString(oldPath);
        buffer.putString(newPath);
        int numOptions = GenericUtils.size(options);
        int version = this.getVersion();
        if (version >= 5) {
            int opts = 0;
            if (numOptions > 0) {
                for (SftpClient.CopyMode opt : options) {
                    switch (opt) {
                        case Atomic: {
                            opts |= 2;
                            break;
                        }
                        case Overwrite: {
                            opts |= 1;
                            break;
                        }
                    }
                }
            }
            buffer.putInt(opts);
        } else if (numOptions > 0) {
            throw new UnsupportedOperationException("rename(" + oldPath + " => " + newPath + ")" + " - copy options can not be used with this SFTP version: " + options);
        }
        this.checkCommandStatus(18, buffer);
    }

    @Override
    public int read(SftpClient.Handle handle, long fileOffset, byte[] dst, int dstOffset, int len, AtomicReference<Boolean> eofSignalled) throws IOException {
        if (eofSignalled != null) {
            eofSignalled.set(null);
        }
        if (!this.isOpen()) {
            throw new IOException("read(" + handle + "/" + fileOffset + ")[" + dstOffset + "/" + len + "] client is closed");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(fileOffset);
        buffer.putInt(len);
        return this.checkData(5, buffer, dstOffset, dst, eofSignalled);
    }

    protected int checkData(int cmd, Buffer request, int dstOffset, byte[] dst, AtomicReference<Boolean> eofSignalled) throws IOException {
        if (eofSignalled != null) {
            eofSignalled.set(null);
        }
        int reqId = this.send(cmd, request);
        Buffer response = this.receive(reqId);
        return this.checkDataResponse(cmd, response, dstOffset, dst, eofSignalled);
    }

    protected int checkDataResponse(int cmd, Buffer buffer, int dstoff, byte[] dst, AtomicReference<Boolean> eofSignalled) throws IOException {
        if (eofSignalled != null) {
            eofSignalled.set(null);
        }
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 103) {
            int len = buffer.getInt();
            buffer.getRawBytes(dst, dstoff, len);
            Boolean indicator = SftpHelper.getEndOfFileIndicatorValue(buffer, this.getVersion());
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkDataResponse({}][id={}] {} offset={}, len={}, EOF={}", new Object[]{this.getClientChannel(), SftpConstants.getCommandMessageName(cmd), id, dstoff, len, indicator});
            }
            if (eofSignalled != null) {
                eofSignalled.set(indicator);
            }
            return len;
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkDataResponse({})[id={}] {} status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getCommandMessageName(cmd), SftpConstants.getStatusName(substatus), lang, msg});
            }
            if (substatus == 1) {
                return -1;
            }
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
        return this.handleUnknownDataPacket(cmd, id, type, length, buffer);
    }

    protected int handleUnknownDataPacket(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        IOException err = this.handleUnexpectedPacket(cmd, 103, id, type, length, buffer);
        if (err != null) {
            throw err;
        }
        return 0;
    }

    @Override
    public void write(SftpClient.Handle handle, long fileOffset, byte[] src, int srcOffset, int len) throws IOException {
        if (fileOffset < 0L || srcOffset < 0 || len < 0) {
            throw new IllegalArgumentException("write(" + handle + ") please ensure all parameters " + " are non-negative values: file-offset=" + fileOffset + ", src-offset=" + srcOffset + ", len=" + len);
        }
        if (srcOffset + len > src.length) {
            throw new IllegalArgumentException("write(" + handle + ")" + " cannot read bytes " + srcOffset + " to " + (srcOffset + len) + " when array is only of length " + src.length);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + handle + "/" + fileOffset + ")[" + srcOffset + "/" + len + "] client is closed");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("write({}) handle={}, file-offset={}, buf-offset={}, len={}", new Object[]{this.getClientChannel(), handle, fileOffset, srcOffset, len});
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + len + 64, false);
        buffer.putBytes(id);
        buffer.putLong(fileOffset);
        buffer.putBytes(src, srcOffset, len);
        this.checkCommandStatus(6, buffer);
    }

    @Override
    public void mkdir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("mkdir(" + path + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("mkdir({}) {}", (Object)this.getClientSession(), (Object)path);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer.putString(path);
        buffer.putInt(0L);
        int version = this.getVersion();
        if (version != 3) {
            ((Buffer)buffer).putByte((byte)0);
        }
        this.checkCommandStatus(14, buffer);
    }

    @Override
    public void rmdir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("rmdir(" + path + ") client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("rmdir({}) {}", (Object)this.getClientSession(), (Object)path);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer.putString(path);
        this.checkCommandStatus(15, buffer);
    }

    @Override
    public SftpClient.CloseableHandle openDir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("openDir(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer.putString(path);
        DefaultCloseableHandle handle = new DefaultCloseableHandle(this, path, this.checkHandle(11, buffer));
        if (this.log.isTraceEnabled()) {
            this.log.trace("openDir({})[{}}: {}", new Object[]{this.getClientSession(), path, handle});
        }
        return handle;
    }

    @Override
    public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle, AtomicReference<Boolean> eolIndicator) throws IOException {
        if (eolIndicator != null) {
            eolIndicator.set(null);
        }
        if (!this.isOpen()) {
            throw new IOException("readDir(" + handle + ") client is closed");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 8, false);
        buffer.putBytes(id);
        int cmdId = this.send(12, buffer);
        Buffer response = this.receive(cmdId);
        return this.checkDirResponse(12, response, eolIndicator);
    }

    protected List<SftpClient.DirEntry> checkDirResponse(int cmd, Buffer buffer, AtomicReference<Boolean> eolIndicator) throws IOException {
        if (eolIndicator != null) {
            eolIndicator.set(null);
        }
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 104) {
            int len = buffer.getInt();
            int version = this.getVersion();
            ClientChannel channel = this.getClientChannel();
            if (this.log.isDebugEnabled()) {
                this.log.debug("checkDirResponse({}}[id={}] reading {} entries", new Object[]{channel, id, len});
            }
            ArrayList<SftpClient.DirEntry> entries = new ArrayList<SftpClient.DirEntry>(len);
            for (int i = 0; i < len; ++i) {
                String name = buffer.getString();
                String longName = version == 3 ? buffer.getString() : null;
                SftpClient.Attributes attrs = this.readAttributes(buffer);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("checkDirResponse({})[id={}][{}] ({})[{}]: {}", new Object[]{channel, id, i, name, longName, attrs});
                }
                entries.add(new SftpClient.DirEntry(name, longName, attrs));
            }
            Boolean indicator = SftpHelper.getEndOfListIndicatorValue(buffer, version);
            if (eolIndicator != null) {
                eolIndicator.set(indicator);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("checkDirResponse({}}[id={}] read count={}, eol={}", new Object[]{channel, entries.size(), indicator});
            }
            return entries;
        }
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("checkDirResponse({})[id={}] - status: {} [{}] {}", new Object[]{this.getClientChannel(), id, SftpConstants.getStatusName(substatus), lang, msg});
            }
            if (substatus == 1) {
                return null;
            }
            this.throwStatusException(cmd, id, substatus, msg, lang);
        }
        return this.handleUnknownDirListingPacket(cmd, id, type, length, buffer);
    }

    protected List<SftpClient.DirEntry> handleUnknownDirListingPacket(int cmd, int id, int type, int length, Buffer buffer) throws IOException {
        IOException err = this.handleUnexpectedPacket(cmd, 104, id, type, length, buffer);
        if (err != null) {
            throw err;
        }
        return Collections.emptyList();
    }

    protected IOException handleUnexpectedPacket(int cmd, int expected, int id, int type, int length, Buffer buffer) throws IOException {
        throw new SshException("Unexpected SFTP packet received while awaiting " + SftpConstants.getCommandMessageName(expected) + " response to " + SftpConstants.getCommandMessageName(cmd) + ": type=" + SftpConstants.getCommandMessageName(type) + ", id=" + id + ", length=" + length);
    }

    @Override
    public String canonicalPath(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("canonicalPath(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer.putString(path);
        return this.checkOneName(16, buffer);
    }

    @Override
    public SftpClient.Attributes stat(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("stat(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer.putString(path);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65535L);
        }
        return this.checkAttributes(17, buffer);
    }

    @Override
    public SftpClient.Attributes lstat(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("lstat(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer.putString(path);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65535L);
        }
        return this.checkAttributes(7, buffer);
    }

    @Override
    public SftpClient.Attributes stat(SftpClient.Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("stat(" + handle + ") client is closed");
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 8, false);
        buffer.putBytes(id);
        int version = this.getVersion();
        if (version >= 4) {
            buffer.putInt(65535L);
        }
        return this.checkAttributes(8, buffer);
    }

    @Override
    public void setStat(String path, SftpClient.Attributes attributes) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("setStat(" + path + ")[" + attributes + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({})[{}]: {}", new Object[]{this.getClientSession(), path, attributes});
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putString(path);
        this.writeAttributes(buffer, attributes);
        this.checkCommandStatus(9, buffer);
    }

    @Override
    public void setStat(SftpClient.Handle handle, SftpClient.Attributes attributes) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("setStat(" + handle + ")[" + attributes + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setStat({})[{}]: {}", new Object[]{this.getClientSession(), handle, attributes});
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 128, false);
        buffer.putBytes(id);
        this.writeAttributes(buffer, attributes);
        this.checkCommandStatus(10, buffer);
    }

    @Override
    public String readLink(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readLink(" + path + ") client is closed");
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(path.length() + 64, false);
        buffer.putString(path);
        return this.checkOneName(19, buffer);
    }

    @Override
    public void link(String linkPath, String targetPath, boolean symbolic) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("link(" + linkPath + " => " + targetPath + ")[symbolic=" + symbolic + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("link({})[symbolic={}] {} => {}", new Object[]{this.getClientSession(), symbolic, linkPath, targetPath});
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(linkPath.length() + targetPath.length() + 64, false);
        int version = this.getVersion();
        if (version < 6) {
            if (!symbolic) {
                throw new UnsupportedOperationException("Hard links are not supported in sftp v" + version);
            }
            buffer.putString(targetPath);
            buffer.putString(linkPath);
            this.checkCommandStatus(20, buffer);
        } else {
            buffer.putString(targetPath);
            buffer.putString(linkPath);
            buffer.putBoolean(symbolic);
            this.checkCommandStatus(21, buffer);
        }
    }

    @Override
    public void lock(SftpClient.Handle handle, long offset, long length, int mask) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("lock(" + handle + ")[offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask) + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("lock({})[{}] offset={}, length={}, mask=0x{}", new Object[]{this.getClientSession(), handle, offset, length, Integer.toHexString(mask)});
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(offset);
        buffer.putLong(length);
        buffer.putInt(mask);
        this.checkCommandStatus(22, buffer);
    }

    @Override
    public void unlock(SftpClient.Handle handle, long offset, long length) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("unlock" + handle + ")[offset=" + offset + ", length=" + length + "] client is closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("unlock({})[{}] offset={}, length={}", new Object[]{this.getClientSession(), handle, offset, length});
        }
        byte[] id = Objects.requireNonNull(handle, "No handle").getIdentifier();
        ByteArrayBuffer buffer = new ByteArrayBuffer(id.length + 64, false);
        buffer.putBytes(id);
        buffer.putLong(offset);
        buffer.putLong(length);
        this.checkCommandStatus(23, buffer);
    }
}

