/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.simple;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.client.scp.CloseableScpClient;
import org.apache.sshd.client.scp.ScpClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractSimpleClient
extends AbstractLoggingBean
implements SimpleClient {
    protected AbstractSimpleClient() {
    }

    @Override
    public SftpClient sftpLogin(SocketAddress target, String username, String password) throws IOException {
        return this.createSftpClient(this.sessionLogin(target, username, password));
    }

    @Override
    public SftpClient sftpLogin(SocketAddress target, String username, KeyPair identity) throws IOException {
        return this.createSftpClient(this.sessionLogin(target, username, identity));
    }

    protected SftpClient createSftpClient(ClientSession session) throws IOException {
        Exception err = null;
        try {
            SftpClient client = session.createSftpClient();
            try {
                return this.createSftpClient(session, client);
            }
            catch (Exception e) {
                err = GenericUtils.accumulateException(err, e);
                try {
                    client.close();
                }
                catch (Exception t) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("createSftpClient({}) failed ({}) to close client: {}", new Object[]{session, t.getClass().getSimpleName(), t.getMessage()});
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("createSftpClient(" + session + ") client close failure details", (Throwable)t);
                    }
                    err = GenericUtils.accumulateException(err, t);
                }
            }
        }
        catch (Exception e) {
            err = GenericUtils.accumulateException(err, e);
        }
        this.log.warn("createSftpClient({}) failed ({}) to create session: {}", new Object[]{session, err.getClass().getSimpleName(), err.getMessage()});
        try {
            session.close();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("createSftpClient({}) failed ({}) to close session: {}", new Object[]{session, e.getClass().getSimpleName(), e.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("createSftpClient(" + session + ") session close failure details", (Throwable)e);
            }
            err = GenericUtils.accumulateException(err, e);
        }
        if (err instanceof IOException) {
            throw (IOException)err;
        }
        throw new IOException(err);
    }

    protected SftpClient createSftpClient(ClientSession session, SftpClient client) throws IOException {
        ClassLoader loader = this.getClass().getClassLoader();
        Class[] interfaces = new Class[]{SftpClient.class};
        return (SftpClient)Proxy.newProxyInstance(loader, interfaces, (proxy, method, args) -> {
            Throwable err = null;
            Object result = null;
            String name = method.getName();
            try {
                result = method.invoke((Object)client, args);
            }
            catch (Throwable t) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("invoke(SftpClient#{}) failed ({}) to execute: {}", new Object[]{name, t.getClass().getSimpleName(), t.getMessage()});
                }
                err = GenericUtils.accumulateException(err, t);
            }
            if ("close".equals(name) && GenericUtils.isEmpty(args)) {
                try {
                    session.close();
                }
                catch (Throwable t) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("invoke(ClientSession#{}) failed ({}) to execute: {}", new Object[]{name, t.getClass().getSimpleName(), t.getMessage()});
                    }
                    err = GenericUtils.accumulateException(err, t);
                }
            }
            if (err != null) {
                throw err;
            }
            return result;
        });
    }

    @Override
    public CloseableScpClient scpLogin(String host, String username, String password) throws IOException {
        return this.scpLogin(host, 22, username, password);
    }

    @Override
    public CloseableScpClient scpLogin(String host, int port, String username, String password) throws IOException {
        return this.scpLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty(host, "No host")), port, username, password);
    }

    @Override
    public CloseableScpClient scpLogin(String host, String username, KeyPair identity) throws IOException {
        return this.scpLogin(host, 22, username, identity);
    }

    @Override
    public CloseableScpClient scpLogin(String host, int port, String username, KeyPair identity) throws IOException {
        return this.scpLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty(host, "No host")), port, username, identity);
    }

    @Override
    public CloseableScpClient scpLogin(InetAddress host, String username, String password) throws IOException {
        return this.scpLogin(host, 22, username, password);
    }

    @Override
    public CloseableScpClient scpLogin(InetAddress host, int port, String username, String password) throws IOException {
        return this.scpLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host, "No host address"), port), username, password);
    }

    @Override
    public CloseableScpClient scpLogin(InetAddress host, String username, KeyPair identity) throws IOException {
        return this.scpLogin(host, 22, username, identity);
    }

    @Override
    public CloseableScpClient scpLogin(InetAddress host, int port, String username, KeyPair identity) throws IOException {
        return this.scpLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host, "No host address"), port), username, identity);
    }

    @Override
    public CloseableScpClient scpLogin(SocketAddress target, String username, String password) throws IOException {
        return this.createScpClient(this.sessionLogin(target, username, password));
    }

    @Override
    public CloseableScpClient scpLogin(SocketAddress target, String username, KeyPair identity) throws IOException {
        return this.createScpClient(this.sessionLogin(target, username, identity));
    }

    protected CloseableScpClient createScpClient(ClientSession session) throws IOException {
        try {
            ScpClient client = Objects.requireNonNull(session, "No client session").createScpClient();
            ClassLoader loader = this.getClass().getClassLoader();
            Class[] interfaces = new Class[]{CloseableScpClient.class};
            return (CloseableScpClient)Proxy.newProxyInstance(loader, interfaces, (proxy, method, args) -> {
                String name = method.getName();
                try {
                    if (("close".equals(name) || "isOpen".equals(name)) && GenericUtils.isEmpty(args)) {
                        return method.invoke((Object)session, args);
                    }
                    return method.invoke((Object)client, args);
                }
                catch (Throwable t) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("invoke(CloseableScpClient#{}) failed ({}) to execute: {}", new Object[]{name, t.getClass().getSimpleName(), t.getMessage()});
                    }
                    throw t;
                }
            });
        }
        catch (Exception e) {
            this.log.warn("createScpClient({}) failed ({}) to create proxy: {}", new Object[]{session, e.getClass().getSimpleName(), e.getMessage()});
            try {
                session.close();
            }
            catch (Exception t) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("createScpClient({}) failed ({}) to close session: {}", new Object[]{session, t.getClass().getSimpleName(), t.getMessage()});
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("createScpClient(" + session + ") session close failure details", (Throwable)t);
                }
                e.addSuppressed(t);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }
}

