/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.WarnStatus;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.logback.internal.LogEntryImpl;
import org.ops4j.pax.logging.logback.internal.LogReaderServiceAccess;
import org.ops4j.pax.logging.logback.internal.PaxEventHandler;
import org.ops4j.pax.logging.logback.internal.PaxLoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogService;
import org.slf4j.impl.StaticLoggerBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaxLoggingServiceImpl
implements PaxLoggingService,
org.knopflerfish.service.log.LogService,
ManagedService,
ServiceFactory {
    private final LogReaderServiceAccess m_logReader;
    private final EventAdminPoster m_eventAdmin;
    private final BundleContext m_bundleContext;
    private final PaxContext m_paxContext;
    private final boolean m_useStaticContext;
    private final String m_staticConfigFile;
    private final LoggerContext m_logbackContext;
    private final String m_fqcn = this.getClass().getName();
    private int m_logLevel = 4;
    private static final String DEFAULT_SERVICE_LOG_LEVEL = "org.ops4j.pax.logging.DefaultServiceLog.level";
    private static final String LOGBACK_CONFIG_FILE_KEY = "org.ops4j.pax.logging.logback.config.file";
    public static final String LOGGER_CONTEXT_BUNDLECONTEXT_KEY = "org.ops4j.pax.logging.logback.bundlecontext";

    public PaxLoggingServiceImpl(@Nonnull BundleContext bundleContext, @Nonnull LogReaderServiceAccess logReader, @Nonnull EventAdminPoster eventAdmin) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext cannot be null");
        }
        this.m_bundleContext = bundleContext;
        if (logReader == null) {
            throw new IllegalArgumentException("logReader cannot be null");
        }
        this.m_logReader = logReader;
        if (eventAdmin == null) {
            throw new IllegalArgumentException("eventAdmin cannot be null");
        }
        this.m_eventAdmin = eventAdmin;
        this.m_paxContext = new PaxContext();
        this.m_useStaticContext = Boolean.valueOf(bundleContext.getProperty("org.ops4j.pax.logging.StaticLogbackContext"));
        if (this.m_useStaticContext) {
            this.m_logbackContext = (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
        } else {
            this.m_logbackContext = new LoggerContext();
            this.m_logbackContext.start();
        }
        this.m_staticConfigFile = bundleContext.getProperty("org.ops4j.pax.logging.StaticLogbackFile");
        this.configureDefaults();
    }

    public PaxLogger getLogger(Bundle bundle, String category, String fqcn) {
        Logger logger = this.m_logbackContext.getLogger(category == null ? "ROOT" : category);
        return new PaxLoggerImpl(bundle, logger, fqcn, this, new PaxEventHandler(){

            public void handleEvents(Bundle bundle, @Nullable ServiceReference sr, int level, String message, Throwable exception) {
                LogEntryImpl entry = new LogEntryImpl(bundle, sr, level, message, exception);
                PaxLoggingServiceImpl.this.m_logReader.fireEvent(entry);
                PaxLoggingServiceImpl.this.m_eventAdmin.postEvent(bundle, level, (LogEntry)entry, message, exception, sr, PaxLoggingServiceImpl.this.getPaxContext().getContext());
            }
        });
    }

    public int getLogLevel() {
        return this.m_logLevel;
    }

    public void log(int level, String message) {
        this.logImpl(null, level, message, null, this.m_fqcn);
    }

    public void log(int level, String message, @Nullable Throwable exception) {
        this.logImpl(null, level, message, exception, this.m_fqcn);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.logImpl(sr == null ? null : sr.getBundle(), level, message, null, this.m_fqcn);
    }

    public void log(ServiceReference sr, int level, String message, @Nullable Throwable exception) {
        this.logImpl(sr == null ? null : sr.getBundle(), level, message, exception, this.m_fqcn);
    }

    void log(@Nullable Bundle bundle, int level, String message, @Nullable Throwable exception) {
        this.logImpl(bundle, level, message, exception, this.m_fqcn);
    }

    private void logImpl(@Nullable Bundle bundle, int level, String message, @Nullable Throwable exception, String fqcn) {
        String category = "[undefined]";
        if (bundle != null && null == (category = bundle.getSymbolicName())) {
            category = "[bundle@" + bundle.getBundleId() + ']';
        }
        try {
            PaxLogger logger = this.getLogger(bundle, category, fqcn);
            switch (level) {
                case 1: {
                    logger.error(message, exception);
                    break;
                }
                case 2: {
                    logger.warn(message, exception);
                    break;
                }
                case 3: {
                    logger.inform(message, exception);
                    break;
                }
                case 4: {
                    logger.debug(message, exception);
                    break;
                }
                default: {
                    logger.warn("Undefined Level: " + level + " : " + message, exception);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            this.m_logbackContext.getStatusManager().add(new WarnStatus("Runtime logging failure", this.m_logbackContext, e));
        }
    }

    public void updated(Dictionary configuration) throws ConfigurationException {
        if (configuration == null) {
            if (this.m_staticConfigFile == null) {
                this.configureDefaults();
            }
            return;
        }
        Object configfile = configuration.get(LOGBACK_CONFIG_FILE_KEY);
        if (this.m_staticConfigFile == null || configfile != null && !this.m_staticConfigFile.equals(configfile)) {
            if (configfile != null) {
                File f = new File(configfile.toString());
                if (f.exists()) {
                    try {
                        this.configureLogback(f);
                    }
                    catch (RuntimeException e) {
                        this.m_logbackContext.getStatusManager().add(new WarnStatus("Error loading Logback configuration from '" + f + "'", this.m_logbackContext, e));
                    }
                } else {
                    this.m_logbackContext.getStatusManager().add(new WarnStatus("Configuration said to load '" + f + "' but that file does not exist", this.m_logbackContext));
                    this.configureLogback(null);
                }
            } else {
                this.configureLogback(null);
            }
        }
        this.configurePax(configuration);
        this.updateLevels(configuration);
    }

    private void configureDefaults() {
        if (this.m_staticConfigFile != null) {
            File f = new File(this.m_staticConfigFile);
            try {
                this.configureLogback(f);
            }
            catch (RuntimeException e) {
                this.m_logbackContext.getStatusManager().add(new WarnStatus("Error loading Logback configuration from '" + f + "'", this.m_logbackContext, e));
            }
        } else {
            ConsoleAppender<ILoggingEvent> consoleAppender = this.configureLogbackDefaults();
            consoleAppender.addInfo("default: setting up console logging at WARN level");
        }
        String levelName = this.m_bundleContext.getProperty(DEFAULT_SERVICE_LOG_LEVEL);
        levelName = levelName == null ? "DEBUG" : levelName.trim();
        this.m_logLevel = PaxLoggingServiceImpl.convertLevel(levelName);
    }

    private void configureLogback(@Nullable File configFile) {
        ConsoleAppender<ILoggingEvent> consoleAppender = this.configureLogbackDefaults();
        if (configFile != null) {
            try {
                String hostName = InetAddress.getLocalHost().getCanonicalHostName();
                int n = hostName.indexOf(46);
                if (n >= 0) {
                    hostName = hostName.substring(0, n);
                }
                this.m_logbackContext.putProperty("HOSTNAMENONCANON", hostName.toLowerCase(Locale.ENGLISH));
            }
            catch (UnknownHostException hostName) {
                // empty catch block
            }
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(this.m_logbackContext);
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                configurator.doConfigure(configFile);
                this.m_logbackContext.getLogger("ROOT").detachAppender((Appender<ILoggingEvent>)consoleAppender);
            }
            catch (JoranException e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    private ConsoleAppender<ILoggingEvent> configureLogbackDefaults() {
        ConsoleAppender<ILoggingEvent> consoleAppender = this.makeConsoleAppender();
        this.m_logbackContext.reset();
        this.m_logbackContext.getLogger("ROOT").addAppender((Appender<ILoggingEvent>)consoleAppender);
        this.m_logbackContext.putObject(LOGGER_CONTEXT_BUNDLECONTEXT_KEY, this.m_bundleContext);
        this.m_logbackContext.getStatusManager().add(new StatusListener(){

            public void addStatusEvent(Status status) {
                String output;
                if (!(status.getLevel() != 2 && status.getLevel() != 1 || (output = String.valueOf(status)).contains("No appenders present") || output.contains("non started appender"))) {
                    System.err.println(output);
                    Throwable t = status.getThrowable();
                    if (t != null) {
                        t.printStackTrace(System.err);
                    }
                }
            }
        });
        return consoleAppender;
    }

    private ConsoleAppender<ILoggingEvent> makeConsoleAppender() {
        ThresholdFilter filter = new ThresholdFilter();
        filter.setContext(this.m_logbackContext);
        filter.setLevel("WARN");
        filter.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(this.m_logbackContext);
        encoder.setPattern("%d %-5level [%file:%line] %msg - %logger{20}%n");
        encoder.start();
        ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender<ILoggingEvent>();
        consoleAppender.setContext(this.m_logbackContext);
        consoleAppender.setName("DEFAULT-CONSOLE");
        consoleAppender.addFilter(filter);
        consoleAppender.setEncoder(encoder);
        consoleAppender.start();
        return consoleAppender;
    }

    private void updateLevels(Dictionary config) {
        Enumeration keys = config.keys();
        while (keys.hasMoreElements()) {
            Level level;
            String name = (String)keys.nextElement();
            if (name.equals("log4j.rootLogger")) {
                level = this.extractLevel((String)config.get(name));
                this.m_logbackContext.getLogger("ROOT").setLevel(level);
            }
            if (!name.startsWith("log4j.logger.")) continue;
            level = this.extractLevel((String)config.get(name));
            String packageName = name.substring("log4j.logger.".length());
            this.m_logbackContext.getLogger(packageName).setLevel(level);
        }
    }

    private Level extractLevel(String log4jLevelConfig) {
        String[] config = log4jLevelConfig.split(",");
        return Level.toLevel(config[0]);
    }

    private void configurePax(Dictionary config) {
        Object size = config.get("pax.logging.entries.size");
        if (null != size) {
            try {
                this.m_logReader.setMaxEntries(Integer.parseInt((String)size));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object getService(final Bundle bundle, ServiceRegistration registration) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ManagedPaxLoggingService
        implements PaxLoggingService,
        LogService,
        ManagedService {
            private final String fqcn = this.getClass().getName();

            ManagedPaxLoggingService() {
            }

            public void log(int level, String message) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, null, this.fqcn);
            }

            public void log(int level, String message, @Nullable Throwable exception) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, exception, this.fqcn);
            }

            public void log(ServiceReference sr, int level, String message) {
                Bundle b = bundle == null && sr != null ? sr.getBundle() : bundle;
                PaxLoggingServiceImpl.this.logImpl(b, level, message, null, this.fqcn);
            }

            public void log(ServiceReference sr, int level, String message, Throwable exception) {
                Bundle b = bundle == null && sr != null ? sr.getBundle() : bundle;
                PaxLoggingServiceImpl.this.logImpl(b, level, message, exception, this.fqcn);
            }

            public int getLogLevel() {
                return PaxLoggingServiceImpl.this.getLogLevel();
            }

            public PaxLogger getLogger(Bundle myBundle, String category, String fqcn) {
                return PaxLoggingServiceImpl.this.getLogger(myBundle, category, fqcn);
            }

            public void updated(Dictionary configuration) throws ConfigurationException {
                PaxLoggingServiceImpl.this.updated(configuration);
            }

            public PaxContext getPaxContext() {
                return PaxLoggingServiceImpl.this.getPaxContext();
            }
        }
        return new ManagedPaxLoggingService();
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public PaxContext getPaxContext() {
        return this.m_paxContext;
    }

    private static int convertLevel(String levelName) {
        if ("DEBUG".equals(levelName)) {
            return 4;
        }
        if ("INFO".equals(levelName)) {
            return 3;
        }
        if ("ERROR".equals(levelName)) {
            return 1;
        }
        if ("WARN".equals(levelName)) {
            return 2;
        }
        return 4;
    }

    public void stop() {
        this.m_logbackContext.putObject(LOGGER_CONTEXT_BUNDLECONTEXT_KEY, null);
        if (!this.m_useStaticContext) {
            this.m_logbackContext.stop();
        }
    }
}

